/*
 * Decompiled with CFR 0.152.
 */
package z1gned.goetyrevelation;

import com.Polarice3.Goety.client.render.SummonApostleRenderer;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import z1gned.goetyrevelation.client.ModLayerAndModels;
import z1gned.goetyrevelation.client.event.NetherStarShaders;
import z1gned.goetyrevelation.client.model.PhantomServantModel;
import z1gned.goetyrevelation.client.model.WitherServantModel;
import z1gned.goetyrevelation.client.render.PhantomServantRenderer;
import z1gned.goetyrevelation.client.render.WitherServantRenderer;
import z1gned.goetyrevelation.config.ModConfig;
import z1gned.goetyrevelation.entitiy.ModEntityType;
import z1gned.goetyrevelation.entitiy.PhantomServant;
import z1gned.goetyrevelation.item.ModItems;
import z1gned.goetyrevelation.tag.ModTags;

@Mod(value="goety_revelation")
public class ModMain {
    public static final String MODID = "goety_revelation";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"goety_revelation");
    public static final RegistryObject<SoundEvent> APOLLYON_OVERWORLD_THEME = ModMain.createSound("apollyon_theme_overworld");
    public static final RegistryObject<SoundEvent> APOLLYON_NETHER_THEME = ModMain.createSound("apollyon_theme_nether");
    public static final RegistryObject<SoundEvent> APOLLYON_THEME_POST = ModMain.createSound("apollyon_theme_post");

    static RegistryObject<SoundEvent> createSound(String name) {
        SoundEvent event = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(MODID, name));
        return SOUNDS.register(name, () -> event);
    }

    public ModMain() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModEntityType.ENTITY_TYPE.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        modEventBus.addListener(this::setupEntityAttributeCreation);
        modEventBus.addListener(this::commonSetup);
        ModTags.init();
        SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC, "goety_revelation.toml");
        ModConfig.loadConfig(ModConfig.SPEC, FMLPaths.CONFIGDIR.get().resolve("goety_revelation.toml").toString());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Apollyon is Coming!");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Apollyon is Coming!");
    }

    private void setupEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntityType.PHANTOM_SERVANT.get(), PhantomServant.setCustomAttributes().m_22265_());
        event.put((EntityType)ModEntityType.WITHER_SERVANT.get(), WitherBoss.m_31501_().m_22265_());
    }

    @Mod.EventBusSubscriber(modid="goety_revelation", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(ModLayerAndModels.PHANTOM_SERVANT_MODEL, PhantomServantModel::createBodyLayer);
            event.registerLayerDefinition(ModLayerAndModels.WITHER_SERVANT_MODEL, WitherServantModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void onRegisterRenders(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ModEntityType.PHANTOM_SERVANT.get(), PhantomServantRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntityType.WITHER_SERVANT.get(), WitherServantRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntityType.SUMMON_APOLLYON.get(), SummonApostleRenderer::new);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onRegisterShaders(RegisterShadersEvent event) {
            NetherStarShaders.onRegisterShaders(event);
        }
    }
}

