/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import rikka.lanserverproperties.CommonWidgets;
import rikka.lanserverproperties.ConfigContainer;
import rikka.lanserverproperties.IShareToLanScreenParamAccessor;
import rikka.lanserverproperties.ModifyLanScreen;

public class OpenToLanScreenEx {
    private static final Component lanServerOptionsLabel = Component.m_237115_((String)"lanserverproperties.button.lan_server_options");
    private static final Component portDescLabel = Component.m_237115_((String)"lanserverproperties.gui.port");
    private final ShareToLanScreen screen;
    private final IShareToLanScreenParamAccessor stlParamAccessor;
    private Button startButton = null;
    private ConfigContainer configContainer;
    private CommonWidgets commonWidgets;

    public OpenToLanScreenEx(ShareToLanScreen screen, IShareToLanScreenParamAccessor stlParamAccessor) {
        this.screen = screen;
        this.stlParamAccessor = stlParamAccessor;
        this.configContainer = new ConfigContainer.Vanilla(stlParamAccessor);
    }

    private static <T extends AbstractWidget> T findWidget(List<? extends GuiEventListener> list, Class<T> cls, String vanillaLangKey) {
        for (GuiEventListener guiEventListener : list) {
            Component component;
            AbstractWidget widget;
            if (!(guiEventListener instanceof AbstractWidget) || !cls.isAssignableFrom((widget = (AbstractWidget)guiEventListener).getClass()) || !((component = widget.m_6035_()).m_214077_() instanceof TranslatableContents)) continue;
            TranslatableContents content = (TranslatableContents)component.m_214077_();
            if (content.m_237508_().equals(vanillaLangKey)) {
                return (T)widget;
            }
            Object[] args = content.m_237523_();
            if (args.length == 0 || !(args[0] instanceof MutableComponent)) continue;
            MutableComponent mutableComponent = (MutableComponent)args[0];
            if (!(component.m_214077_() instanceof TranslatableContents) || !(mutableComponent.m_214077_() instanceof TranslatableContents) || !(content = (TranslatableContents)mutableComponent.m_214077_()).m_237508_().equals(vanillaLangKey)) continue;
            return (T)widget;
        }
        return null;
    }

    public void postInitShareToLanScreen(Font textRenderer, List<? extends GuiEventListener> list, Consumer<GuiEventListener> widgetAdder, Consumer<GuiEventListener> widgetRemover) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91091_()) {
            return;
        }
        this.configContainer.loadFromPreferences(false);
        this.startButton = OpenToLanScreenEx.findWidget(list, Button.class, "lanServer.start");
        final CycleButton allowCommandsSelector = OpenToLanScreenEx.findWidget(list, CycleButton.class, "selectWorld.allowCommands");
        final CycleButton gameModeSelector = OpenToLanScreenEx.findWidget(list, CycleButton.class, "selectWorld.gameMode");
        final EditBox portEdit = OpenToLanScreenEx.findWidget(list, EditBox.class, "lanServer.port");
        this.commonWidgets = new CommonWidgets((Screen)this.screen, this.configContainer, textRenderer, widgetAdder){

            @Override
            protected void onButtonStatusUpdated(boolean shouldEnableButtons) {
                OpenToLanScreenEx.this.startButton.f_93623_ = shouldEnableButtons;
            }

            @Override
            public void syncWidgetValues() {
                super.syncWidgetValues();
                allowCommandsSelector.m_168892_((Object)OpenToLanScreenEx.this.configContainer.getGuiCommandEnabled());
                gameModeSelector.m_168892_((Object)OpenToLanScreenEx.this.configContainer.getGuiGameType());
                portEdit.m_94144_(String.valueOf(OpenToLanScreenEx.this.configContainer.getGuiPort()));
            }
        };
        this.commonWidgets.syncWidgetValues();
        this.stlParamAccessor.movePortEditBox(this.screen.f_96543_ / 2 - 154, this.screen.f_96544_ - 54, 147, 20);
    }

    public static void initPauseScreen(Screen gui, List<? extends GuiEventListener> list, Consumer<GuiEventListener> widgetAdder) {
        Button optionButton;
        Minecraft mc = Minecraft.m_91087_();
        Button shareToLanButton = OpenToLanScreenEx.findWidget(list, Button.class, "menu.shareToLan");
        if (shareToLanButton != null) {
            shareToLanButton.f_93623_ = mc.m_91091_();
        }
        if (mc.m_91091_() && mc.m_91092_().m_6992_() && (optionButton = OpenToLanScreenEx.findWidget(list, Button.class, "menu.options")) != null) {
            ImageButton lanServerSettings = new ImageButton(gui.f_96543_ / 2 - 124, optionButton.m_252907_(), 20, 20, 0, 106, 20, Button.f_93617_, 256, 256, button -> mc.m_91152_((Screen)new ModifyLanScreen(gui)), lanServerOptionsLabel);
            lanServerSettings.m_257544_(Tooltip.m_257550_((Component)lanServerOptionsLabel));
            widgetAdder.accept((GuiEventListener)lanServerSettings);
        }
    }

    public static void postDraw(Screen gui, Font textRenderer, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91091_()) {
            guiGraphics.m_280430_(textRenderer, portDescLabel, gui.f_96543_ / 2 - 155, gui.f_96544_ - 66, 0xA0A0A0);
            guiGraphics.m_280430_(textRenderer, ModifyLanScreen.maxPlayerDescLabel, gui.f_96543_ / 2 + 5, gui.f_96544_ - 66, 0xA0A0A0);
        }
    }

    public void onPortEditBoxChanged() {
        this.commonWidgets.updateButtonStatus(this.startButton.f_93623_);
    }

    public int getDefaultPort() {
        return this.configContainer.preferences.defaultPort;
    }

    public void onOpenToLanClosed() {
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        this.configContainer.applyToCurrentServer(server);
    }
}

