/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import rikka.lanserverproperties.IShareToLanScreenParamAccessor;
import rikka.lanserverproperties.OpenToLanScreenEx;

@Mod(value="lanserverproperties")
public class LanServerProperties {
    public static final String MODID = "lanserverproperties";
    public static LanServerProperties INSTANCE = null;

    public LanServerProperties() {
        if (INSTANCE != null) {
            throw new RuntimeException("Duplicated Class Instantiation: CustomItems");
        }
        INSTANCE = this;
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientHandler::registerGuiEventHandler);
    }

    public static OpenToLanScreenEx attachLSPData(ShareToLanScreen screen) {
        return new OpenToLanScreenEx(screen, new ForgeSTLParamAccessor(screen));
    }

    private static OpenToLanScreenEx getLSPData(ShareToLanScreen screen) {
        throw new RuntimeException("Coremod implementation failed!");
    }

    public static void setMaxPlayers(IntegratedServer server, int num) {
        PlayerList playerList = server.m_6846_();
        playerList.f_11193_ = num;
    }

    private static class ForgeSTLParamAccessor
    implements IShareToLanScreenParamAccessor {
        private final ShareToLanScreen gui;

        private ForgeSTLParamAccessor(ShareToLanScreen gui) {
            this.gui = gui;
        }

        @Override
        public Screen getLastScreen() {
            return this.gui.f_96643_;
        }

        @Override
        public GameType getGameType() {
            return this.gui.f_169427_;
        }

        @Override
        public boolean isCommandEnabled() {
            return this.gui.f_96647_;
        }

        @Override
        public void setGameType(GameType gameType) {
            this.gui.f_169427_ = gameType;
        }

        @Override
        public void setCommandEnabled(boolean commandEnabled) {
            this.gui.f_96647_ = commandEnabled;
        }

        @Override
        public void setPort(int port) {
            this.gui.f_256852_ = port;
        }

        @Override
        public int getPort() {
            return this.gui.f_256852_;
        }

        @Override
        public void movePortEditBox(int x, int y, int width, int height) {
            this.gui.f_256803_.m_264152_(x, y);
            this.gui.f_256803_.m_93674_(width);
            this.gui.f_256803_.setHeight(height);
        }
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void registerGuiEventHandler() {
            MinecraftForge.EVENT_BUS.addListener(ClientHandler::onGuiPostInit);
            MinecraftForge.EVENT_BUS.addListener(ClientHandler::onGuiDraw);
        }

        public static void onGuiPostInit(ScreenEvent.Init.Post event) {
            Screen gui = event.getScreen();
            if (gui instanceof ShareToLanScreen) {
                OpenToLanScreenEx hook = LanServerProperties.getLSPData((ShareToLanScreen)gui);
                hook.postInitShareToLanScreen(gui.f_96547_, event.getListenersList(), arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0), arg_0 -> ((ScreenEvent.Init.Post)event).removeListener(arg_0));
            } else if (gui instanceof PauseScreen) {
                OpenToLanScreenEx.initPauseScreen(gui, event.getListenersList(), arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
            }
        }

        public static void onGuiDraw(ScreenEvent.Render.Post event) {
            Screen gui = event.getScreen();
            if (!(gui instanceof ShareToLanScreen)) {
                return;
            }
            OpenToLanScreenEx.postDraw(gui, gui.f_96547_, event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick());
        }
    }
}

