/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import rikka.lanserverproperties.ConfigContainer;
import rikka.lanserverproperties.IntegerEditBox;
import rikka.lanserverproperties.OnlineMode;

public abstract class CommonWidgets {
    private static final Component preferenceEnabledLabel = Component.m_237115_((String)"lanserverproperties.options.preference_enabled");
    private static final Component preferenceEnabledTooltip = Component.m_237115_((String)"lanserverproperties.options.preference_enabled.message");
    private static final Component preferenceLoadLabel = Component.m_237115_((String)"lanserverproperties.button.preference_load");
    private static final Component preferenceSaveLabel = Component.m_237115_((String)"lanserverproperties.button.preference_save");
    private static final Component pvpAllowedLabel = Component.m_237115_((String)"lanserverproperties.gui.pvp_allowed");
    private static final Component maxPlayerDescLabel = Component.m_237115_((String)"lanserverproperties.gui.max_player");
    private static final Component alwaysOfflineLabel = Component.m_237115_((String)"lanserverproperties.gui.always_offline");
    private static final Component alwaysOfflineDescLabel = Component.m_237115_((String)"lanserverproperties.gui.always_offline.message");
    private static final Function<String, Boolean> maxPlayerValidator = IntegerEditBox.makeValidator(0, 16);
    private final Button savePreferenceButton;
    private final CycleButton<Boolean> enablePreferenceOption;
    private final CycleButton<OnlineMode> onlineModeOption;
    private final CycleButton<Boolean> pvpAllowedOption;
    private final IntegerEditBox maxPlayerEditBox;
    private final EditBox alwaysOfflinesEditBox;
    private final ConfigContainer configContainer;

    public CommonWidgets(Screen screen, ConfigContainer configContainer, Font textRenderer, Consumer<GuiEventListener> widgetAdder) {
        this.configContainer = configContainer;
        this.savePreferenceButton = Button.m_253074_((Component)preferenceSaveLabel, btn -> {
            configContainer.copyToPreferences();
            configContainer.preferences.save();
        }).m_252987_(screen.f_96543_ / 2 - 155, 16, 150, 20).m_253136_();
        widgetAdder.accept((GuiEventListener)this.savePreferenceButton);
        this.enablePreferenceOption = CycleButton.m_168919_().m_168948_((Object)configContainer.preferences.enablePreference).m_232498_(curState -> Tooltip.m_257550_((Component)preferenceEnabledTooltip)).m_168936_(screen.f_96543_ / 2 + 5, 16, 150, 20, preferenceEnabledLabel, (cycleButton, newVal) -> {
            configContainer.preferences.enablePreference = newVal;
        });
        widgetAdder.accept((GuiEventListener)this.enablePreferenceOption);
        this.onlineModeOption = new CycleButton.Builder(state -> state.stateName).m_168961_((Object[])OnlineMode.values()).m_168948_((Object)configContainer.onlineMode).m_232498_(curState -> Tooltip.m_257550_((Component)curState.tooltip)).m_168929_().m_168936_(screen.f_96543_ / 2 - 155, 124, 150, 20, OnlineMode.translation, (dummyButton, newVal) -> {
            configContainer.onlineMode = newVal;
        });
        widgetAdder.accept((GuiEventListener)this.onlineModeOption);
        this.pvpAllowedOption = CycleButton.m_168916_((boolean)configContainer.pvpAllowed).m_168936_(screen.f_96543_ / 2 + 5, 124, 150, 20, pvpAllowedLabel, (dummyButton, newVal) -> {
            configContainer.pvpAllowed = newVal;
        });
        widgetAdder.accept((GuiEventListener)this.pvpAllowedOption);
        this.maxPlayerEditBox = new IntegerEditBox(textRenderer, screen.f_96543_ / 2 + 5, screen.f_96544_ - 54, 147, 20, maxPlayerDescLabel, configContainer.maxPlayer, ieb -> {
            this.updateButtonStatus();
            if (ieb.isContentValid()) {
                configContainer.maxPlayer = ieb.getValueAsInt();
            }
        }, maxPlayerValidator, null);
        widgetAdder.accept((GuiEventListener)this.maxPlayerEditBox);
        this.alwaysOfflinesEditBox = new EditBox(textRenderer, screen.f_96543_ / 2 - 180, 146, 360, 20, alwaysOfflineLabel);
        this.alwaysOfflinesEditBox.m_94194_(false);
        this.alwaysOfflinesEditBox.m_257544_(Tooltip.m_257550_((Component)alwaysOfflineDescLabel));
        this.alwaysOfflinesEditBox.m_94199_(1024);
        this.alwaysOfflinesEditBox.m_94144_(configContainer.playersAlwaysOffline);
        this.alwaysOfflinesEditBox.m_94151_(newValue -> {
            configContainer.playersAlwaysOffline = newValue;
        });
        widgetAdder.accept((GuiEventListener)this.alwaysOfflinesEditBox);
        ImageButton showAOEButton = new ImageButton(screen.f_96543_ / 2 - 180, 124, 20, 20, 0, 0, 20, new ResourceLocation("textures/gui/accessibility.png"), 32, 64, button -> this.alwaysOfflinesEditBox.f_93624_ ^= true, alwaysOfflineLabel);
        showAOEButton.m_257544_(Tooltip.m_257550_((Component)alwaysOfflineLabel));
        widgetAdder.accept((GuiEventListener)showAOEButton);
        ImageButton loadPrefButton = new ImageButton(screen.f_96543_ / 2 - 180, 16, 12, 18, 0, 207, 18, new ResourceLocation("textures/gui/recipe_book.png"), 256, 256, button -> {
            configContainer.loadFromPreferences(true);
            this.syncWidgetValues();
        }, preferenceLoadLabel);
        loadPrefButton.m_257544_(Tooltip.m_257550_((Component)preferenceLoadLabel));
        widgetAdder.accept((GuiEventListener)loadPrefButton);
    }

    public void syncWidgetValues() {
        this.enablePreferenceOption.m_168892_((Object)this.configContainer.preferences.enablePreference);
        this.onlineModeOption.m_168892_((Object)this.configContainer.onlineMode);
        this.pvpAllowedOption.m_168892_((Object)this.configContainer.pvpAllowed);
        this.maxPlayerEditBox.m_94144_("" + this.configContainer.maxPlayer);
        this.alwaysOfflinesEditBox.m_94144_(this.configContainer.playersAlwaysOffline);
    }

    protected abstract void onButtonStatusUpdated(boolean var1);

    public void updateButtonStatus() {
        this.updateButtonStatus(true);
    }

    public void updateButtonStatus(boolean lastPortValidity) {
        boolean shouldEnableButtons = lastPortValidity && this.maxPlayerEditBox.isContentValid();
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91091_()) {
            return;
        }
        this.onButtonStatusUpdated(shouldEnableButtons);
        this.savePreferenceButton.f_93623_ = shouldEnableButtons;
    }
}

