/*
 * Decompiled with CFR 0.152.
 */
package com.kamikaguya.ash_of_sin_soul_like_boss_battle.events;

import com.kamikaguya.ash_of_sin_soul_like_boss_battle.config.SoulLikeBossBattleConfig;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="ash_of_sin_soul_like_boss_battle", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AshOfSinSoulLikeBossBattleEvent {
    public static final boolean SOUL_LIKE_BOSS_BATTLE_ON = (Boolean)SoulLikeBossBattleConfig.SOUL_LIKE_BOSS_BATTLE_ON.get();
    public static final int DISTANCE = (Integer)SoulLikeBossBattleConfig.BOSS_BATTLE_DISTANCE.get();
    public static final boolean ANTI_ON = (Boolean)SoulLikeBossBattleConfig.ANTI_IRON_GOLEM.get();

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (SOUL_LIKE_BOSS_BATTLE_ON) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            Level world = player.m_9236_();
            double playerX = player.m_20185_();
            double playerY = player.m_20186_();
            double playerZ = player.m_20189_();
            List<String> soulLikeBossEntityList = ((List)SoulLikeBossBattleConfig.SOUL_LIKE_BOSS_BATTLE_ENTITY.get()).stream().map(s -> s).toList();
            for (String bossName : soulLikeBossEntityList) {
                EntityType bossType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(bossName));
                if (bossType == null) continue;
                List nearbyEntities = world.m_45976_(LivingEntity.class, new AABB(playerX - (double)DISTANCE, playerY - 8.0, playerZ - (double)DISTANCE, playerX + (double)DISTANCE, playerY + 8.0, playerZ + (double)DISTANCE));
                for (LivingEntity nearbyEntity : nearbyEntities) {
                    if (!bossType.equals(nearbyEntity.m_6095_()) || !AshOfSinSoulLikeBossBattleEvent.allNearbyPlayerDied(world, nearbyEntity, player)) continue;
                    nearbyEntity.m_21219_();
                    if (nearbyEntity.m_21213_() <= 20) continue;
                    nearbyEntity.m_21153_(nearbyEntity.m_21233_());
                }
            }
        }
    }

    public static boolean allNearbyPlayerDied(Level world, LivingEntity boss, ServerPlayer player) {
        List nearbyPlayers = world.m_45976_(ServerPlayer.class, new AABB(boss.m_20185_() - (double)DISTANCE, boss.m_20186_() - 8.0, boss.m_20189_() - (double)DISTANCE, boss.m_20185_() + (double)DISTANCE, boss.m_20186_() + 8.0, boss.m_20189_() + (double)DISTANCE));
        return nearbyPlayers.stream().allMatch(LivingEntity::m_21224_);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (SOUL_LIKE_BOSS_BATTLE_ON && ANTI_ON) {
            List<String> soulLikeBossEntityList = ((List)SoulLikeBossBattleConfig.SOUL_LIKE_BOSS_BATTLE_ENTITY.get()).stream().map(s -> s).toList();
            List<String> ironGolemEntityList = ((List)SoulLikeBossBattleConfig.IRON_GOLEM.get()).stream().map(s -> s).toList();
            for (String bossEntityName : soulLikeBossEntityList) {
                EntityType bossType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(bossEntityName));
                for (String ironGolemEntityName : ironGolemEntityList) {
                    EntityType ironGolemType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(ironGolemEntityName));
                    LivingEntity boss = event.getEntity();
                    DamageSource source = event.getSource();
                    Entity ironGolem01 = source.m_7639_();
                    Entity ironGolem02 = source.m_7640_();
                    if (ironGolem01 != null && boss.m_6095_().equals(bossType) && ironGolem01.m_6095_().equals(ironGolemType)) {
                        event.setAmount(0.0f);
                        ironGolem01.m_6074_();
                    }
                    if (ironGolem02 == null || !boss.m_6095_().equals(bossType) || !ironGolem02.m_6095_().equals(ironGolemType)) continue;
                    event.setAmount(0.0f);
                    ironGolem02.m_6074_();
                }
            }
        }
    }
}

