/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.packets.server;

import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class PacketCursedXPScrollKey {
    private final boolean pressed;

    public PacketCursedXPScrollKey(boolean pressed) {
        this.pressed = pressed;
    }

    public static void encode(PacketCursedXPScrollKey msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.pressed);
    }

    @NotNull
    public static PacketCursedXPScrollKey decode(FriendlyByteBuf buf) {
        return new PacketCursedXPScrollKey(buf.readBoolean());
    }

    public static void handle(PacketCursedXPScrollKey msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer playerServ = ((NetworkEvent.Context)context.get()).getSender();
            if (SuperpositionHandler.hasCurio((LivingEntity)playerServ, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL)) {
                ItemStack scroll = SuperpositionHandler.getCurioStack((LivingEntity)playerServ, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL);
                EnigmaticAddonItems.CURSED_XP_SCROLL.trigger(playerServ.m_9236_(), scroll, (Player)playerServ, InteractionHand.MAIN_HAND, false);
            }
        });
        context.get().setPacketHandled(true);
    }
}

