/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.mixin.entity;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WitherBoss.class})
public abstract class MixinWitherBoss
extends Monster {
    @Unique
    private boolean enigmaticAddons$lastPower = false;
    @Unique
    private int enigmaticAddons$lcount = 0;

    protected MixinWitherBoss(EntityType<? extends Monster> type, Level world) {
        super(type, world);
    }

    @Shadow
    public abstract boolean m_7090_();

    @Shadow
    public abstract void m_31454_(int var1, int var2);

    @Inject(method={"customServerAiStep"}, at={@At(value="HEAD")})
    public void customServerAiStep(CallbackInfo ci) {
        if (SuperAddonHandler.isCurseBoosted((LivingEntity)this)) {
            if (this.m_7090_() && !this.enigmaticAddons$lastPower) {
                this.enigmaticAddons$randomSkeleton(2 + this.f_19796_.m_188503_(2));
                this.enigmaticAddons$lastPower = this.m_7090_();
            }
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(8.0));
            for (Entity entity : entities) {
                Monster living;
                if (!(entity instanceof Monster) || (living = (Monster)entity) == this || !living.m_6336_().equals(MobType.f_21641_) || living.m_5448_() != this) continue;
                living.m_6710_(null);
            }
            if (this.f_19797_ % 40 == 0) {
                this.enigmaticAddons$lastPower = this.m_7090_();
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    public void hurtMix(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (SuperAddonHandler.isCurseBoosted((LivingEntity)this) && this.m_7090_() && ((Boolean)cir.getReturnValue()).booleanValue() && this.f_19796_.m_188503_(10) == 0) {
            int temp = Math.max(1, Mth.m_14167_((float)(amount / 7.5f)));
            temp = this.f_19796_.m_188503_(temp);
            this.enigmaticAddons$lcount += temp;
            if (this.enigmaticAddons$lcount > 10) {
                return;
            }
            this.enigmaticAddons$randomSkeleton(temp);
        }
    }

    @Unique
    private void enigmaticAddons$randomSkeleton(int count) {
        if (count <= 0 || this.m_9236_().m_5776_()) {
            return;
        }
        count = Math.min(count, 3);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12562_, SoundSource.NEUTRAL, 5.0f, 0.0f);
        for (int i = 0; i < count; ++i) {
            double dz;
            double dy;
            double dx;
            WitherSkeleton skeleton = new WitherSkeleton(EntityType.f_20497_, this.m_9236_());
            skeleton.m_146884_(this.m_20182_());
            if (this.f_19796_.m_188501_() < 0.4f) {
                skeleton.m_8061_(EquipmentSlot.MAINHAND, EnchantmentHelper.m_220292_((RandomSource)this.f_19796_, (ItemStack)new ItemStack((ItemLike)Items.f_42425_), (int)((int)(5.0f + 1.6f * (float)this.f_19796_.m_188503_(18))), (boolean)false));
            } else {
                skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
            }
            skeleton.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42425_));
            int randomCount = 0;
            do {
                if (randomCount++ <= 12) continue;
                return;
            } while (!skeleton.m_20984_(dx = skeleton.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0, dy = skeleton.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8), dz = skeleton.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0, true));
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123765_, skeleton.m_20185_(), skeleton.m_20227_(0.5), skeleton.m_20189_(), 20, (double)this.m_20205_(), (double)this.m_20206_(), (double)this.m_20205_(), 0.0);
            if (this.m_5448_() != null) {
                skeleton.m_6710_(this.m_5448_());
            }
            this.m_9236_().m_7967_((Entity)skeleton);
        }
    }
}

