/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TotemOfMalice
extends ItemBaseCurio
implements ICursed {
    public static final List<ResourceLocation> extraRaiderList = new ArrayList<ResourceLocation>();
    public static Omniconfig.DoubleParameter raiderBoost;
    public static Omniconfig.DoubleParameter raiderResistance;

    public TotemOfMalice() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_());
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("TotemofMalice");
        raiderBoost = builder.comment("The damage modifier to the Raiders.").max(400.0).min(0.0).getDouble("RaiderDamageBoost", 1.5);
        raiderResistance = builder.comment("The damage resistance to the Raiders.").max(400.0).min(0.0).getDouble("RaiderDamageResistance", 0.5);
        extraRaiderList.clear();
        String[] list = builder.config.getStringList("TotemofMaliceExtraRaiderList", "Balance Options", new String[0], "List of entities that will be affected as Raider by the Totem of Malice. Examples: minecraft:witch. Changing this option required game restart to take effect.");
        Arrays.stream(list).forEach(entry -> extraRaiderList.add(new ResourceLocation(entry)));
        builder.popPrefix();
    }

    public static ItemStack getValidTotem(Player player) {
        for (NonNullList stacks : player.m_150109_().f_35979_) {
            for (ItemStack itemstack : stacks) {
                if (itemstack.m_41619_() || !itemstack.m_150930_((Item)EnigmaticAddonItems.TOTEM_OF_MALICE) || !TotemOfMalice.isPowerful(itemstack)) continue;
                return itemstack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean isEnable(Player player, Boolean needUnbroken) {
        if (!SuperpositionHandler.isTheCursedOne((Player)player)) {
            return false;
        }
        if (needUnbroken.booleanValue()) {
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE)) {
                ItemStack totem = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE);
                return TotemOfMalice.isPowerful(totem);
            }
            return !TotemOfMalice.getValidTotem(player).m_41619_();
        }
        if (SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE)) {
            return true;
        }
        return SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE);
    }

    public static void hurtAndBreak(ItemStack stack, LivingEntity entity) {
        if (!(entity.m_9236_().m_5776_() || entity instanceof Player && ((Player)entity).m_150110_().f_35937_)) {
            entity.f_19802_ = 60;
            TotemOfMalice.setTotemPower(stack, TotemOfMalice.getTotemPower(stack) - 1);
        }
    }

    public static boolean isPowerful(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        int damage = TotemOfMalice.getTotemPower(stack);
        return damage > 0;
    }

    public static int getTotemPower(ItemStack stack) {
        return !stack.m_41782_() ? 0 : stack.m_41783_().m_128451_("MalicePower");
    }

    public static void setTotemPower(ItemStack stack, int damage) {
        int level = stack.getEnchantmentLevel(Enchantments.f_44986_);
        stack.m_41784_().m_128405_("MalicePower", Mth.m_14045_((int)damage, (int)0, (int)Math.min(2 + level, 8)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("%.0f", 100.0 * raiderBoost.getValue()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("%.0f", 100.0 * raiderResistance.getValue()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            if (TotemOfMalice.isPowerful(stack)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice4");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice5");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice4_alt");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice5_alt");
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    public boolean m_5812_(ItemStack stack) {
        return TotemOfMalice.isPowerful(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44986_;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        int level = stack.getEnchantmentLevel(Enchantments.f_44986_);
        return Math.round((float)TotemOfMalice.getTotemPower(stack) * 13.0f / Math.min(2.0f + (float)level, 8.0f));
    }

    public int m_142159_(ItemStack stack) {
        int level = stack.getEnchantmentLevel(Enchantments.f_44986_);
        float stackMaxDamage = Math.min(2.0f + (float)level, 8.0f);
        float f = Math.max(0.0f, (float)TotemOfMalice.getTotemPower(stack) / stackMaxDamage);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)(0.5f + f * 0.5f));
    }
}

