/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.contents.entities.ThrownQuartzDagger;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;

public class QuartzScepter
extends ItemBase {
    public static Omniconfig.IntParameter shootInterval;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public QuartzScepter() {
        super(ItemBase.getDefaultProperties().m_41497_(Rarity.RARE).m_41487_(1).m_41503_(160));
        MinecraftForge.EVENT_BUS.register((Object)this);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 1.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-1.6f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("QuartzScepter");
        shootInterval = builder.comment("The shoot interval time of daggers. Measured as ticks.").max(40.0).min(1.0).getInt("ShootInterval", 8);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.quartzScepter1");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.quartzScepter2");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.quartzScepter3");
        if (stack.m_41793_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity, LivingEntity user) {
        stack.m_41622_(2, user, consumer -> consumer.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemInHand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int cooldown = 40;
            if (!SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.ARTIFICIAL_FLOWER)) {
                cooldown += 20;
            }
            stack.m_41622_(this.m_8105_(stack) / 8, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
            player.m_36335_().m_41524_((Item)this, cooldown);
            player.m_9236_().m_247517_(null, player.m_20183_(), SoundEvents.f_11914_, SoundSource.PLAYERS);
            player.m_6674_(player.m_7655_());
        }
        return stack;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int tick) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int pass = this.m_8105_(stack) - tick;
            stack.m_41622_(pass / 8, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
            if (!SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.ARTIFICIAL_FLOWER)) {
                pass += 50;
            }
            player.m_36335_().m_41524_((Item)this, 20 + pass / 5);
            player.m_6674_(player.m_7655_());
        }
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int tick) {
        int delay = shootInterval.getValue();
        if (SuperpositionHandler.hasCurio((LivingEntity)user, (Item)EnigmaticAddonItems.QUARTZ_RING)) {
            delay -= 2;
        }
        if (tick % delay == 0 && !level.f_46443_ && user instanceof Player) {
            Player player = (Player)user;
            ThrownQuartzDagger dagger = new ThrownQuartzDagger((LivingEntity)player, level);
            RandomSource random = player.m_217043_();
            double x = player.m_20185_() + (double)((random.m_188501_() - 0.5f) * 0.6f);
            double y = player.m_20188_() - 0.4000000014901161 + (double)(random.m_188501_() * 0.6f);
            double z = player.m_20189_() + (double)((random.m_188501_() - 0.5f) * 0.6f);
            dagger.m_6034_(x, y, z);
            dagger.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, SuperpositionHandler.hasCurio((LivingEntity)user, (Item)EnigmaticAddonItems.QUARTZ_RING) ? 1.6f : 1.2f, 1.0f);
            double value = player.m_21051_(Attributes.f_22286_).m_22135_();
            int luck = (int)Math.max(Math.floor(value * (double)0.8f + 0.5), 0.0);
            dagger.m_36781_(dagger.m_36789_() + (double)luck);
            dagger.m_20242_(true);
            level.m_7967_((Entity)dagger);
            level.m_6269_(null, (Entity)player, SoundEvents.f_12520_, SoundSource.PLAYERS, 0.2f, 1.6f);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public boolean m_6832_(ItemStack self, ItemStack stack) {
        return stack.m_150930_(Items.f_42692_) || super.m_6832_(self, stack);
    }
}

