/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.HunterGuidebook;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class OdeToLiving
extends ItemBase
implements Vanishable {
    public static Omniconfig.IntParameter cooldown;
    public static Omniconfig.PerhapsParameter synergyDamageReduction;

    public OdeToLiving() {
        super(OdeToLiving.getDefaultProperties().m_41487_(1).m_41497_(Rarity.RARE));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("OdetoLivingBeings");
        cooldown = builder.comment("Active ability cooldown for Ode to Living Beings. Measured in ticks. 20 ticks equal to 1 second.").max(32768.0).getInt("Cooldown", 1200);
        synergyDamageReduction = builder.comment("The percentage subtracted from damage redirected by Guide to Feral Hunt, if this is also possessed.").max(100.0).getPerhaps("SynergyDamageReduction", 75);
        builder.popPrefix();
    }

    public static boolean isProtectedAnimal(Player player, Animal animal) {
        ItemStack book = SuperAddonHandler.getItem(player, (Item)EnigmaticAddonItems.LIVING_ODE);
        if (book.m_41619_()) {
            book = SuperAddonHandler.findBookInBag(player, (Item)EnigmaticAddonItems.LIVING_ODE);
        }
        return !OdeToLiving.containInList(book, (LivingEntity)animal) && EnigmaticItems.ANIMAL_GUIDEBOOK.isProtectedAnimal((LivingEntity)animal);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.m_36335_().m_41519_((Item)this)) {
            NeutralMob neutral;
            boolean noAction = true;
            if (OdeToLiving.containInList(stack, target)) {
                OdeToLiving.removeFromList(stack, target);
                noAction = false;
            }
            if (target instanceof NeutralMob && (neutral = (NeutralMob)target).m_21660_()) {
                if (target instanceof Animal && neutral.m_5448_() == player) {
                    neutral.m_21662_();
                }
                noAction = false;
            }
            if (noAction) {
                return InteractionResult.PASS;
            }
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123750_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 5, (double)target.m_20205_(), 0.1, (double)target.m_20205_(), 0.1);
            }
            if (!player.m_150110_().f_35937_) {
                player.m_36335_().m_41524_((Item)this, cooldown.getValue());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean containInList(ItemStack stack, LivingEntity entity) {
        ListTag tag = stack.m_41784_().m_128437_("BannedMobList", 10);
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("id", entity.m_6095_().m_20675_());
        return tag.contains((Object)compoundtag);
    }

    public static void addBlackList(ItemStack stack, LivingEntity entity) {
        ListTag tag = stack.m_41784_().m_128437_("BannedMobList", 10);
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("id", entity.m_6095_().m_20675_());
        if (!tag.contains((Object)compoundtag)) {
            tag.add((Object)compoundtag);
        }
        stack.m_41700_("BannedMobList", (Tag)tag);
    }

    public static void removeFromList(ItemStack stack, LivingEntity entity) {
        ListTag tag = stack.m_41784_().m_128437_("BannedMobList", 10);
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("id", entity.m_6095_().m_20675_());
        tag.remove((Object)compoundtag);
        stack.m_41700_("BannedMobList", (Tag)tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde3");
            if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.isTheCursedOne((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.animalGuidebook4");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.animalGuidebook5");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde6");
            if (Minecraft.m_91087_().f_91074_ != null && SuperAddonHandler.isTheBlessedOne((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde7_alt");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde7");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde8");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPetHurt(@NotNull LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof OwnableEntity) {
            Player player;
            TamableAnimal pet;
            OwnableEntity own = (OwnableEntity)entity;
            if (entity instanceof TamableAnimal && !(pet = (TamableAnimal)entity).m_21824_()) {
                return;
            }
            LivingEntity owner = own.m_269323_();
            if (owner instanceof Player && SuperpositionHandler.hasItem((Player)(player = (Player)owner), (Item)EnigmaticItems.HUNTER_GUIDEBOOK) && SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.LIVING_ODE) && owner.m_9236_() == entity.m_9236_() && owner.m_20270_((Entity)entity) <= (float)HunterGuidebook.effectiveDistance.getValue()) {
                event.setCanceled(true);
                owner.m_6469_(event.getSource(), event.getAmount() * synergyDamageReduction.getValue().asModifierInverted());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDamage(@NotNull LivingDamageEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof Player && (player = (Player)entity2).m_21205_().m_150930_((Item)EnigmaticAddonItems.LIVING_ODE)) {
            Animal animal;
            ItemStack livingOde = player.m_21205_();
            if (entity instanceof Animal && OdeToLiving.isProtectedAnimal(player, animal = (Animal)entity)) {
                OdeToLiving.addBlackList(livingOde, entity);
            }
            if (SuperAddonHandler.isTheBlessedOne(player)) {
                List animals = player.m_9236_().m_45976_(Animal.class, entity.m_20191_().m_82400_(10.0));
                for (Animal animal2 : animals) {
                    if (!(animal2 instanceof NeutralMob)) continue;
                    NeutralMob neutralMob = (NeutralMob)animal2;
                    if (animal2.getClass() == entity.getClass() || animal2.m_5448_() != null) continue;
                    neutralMob.m_6710_(entity);
                }
            }
        }
    }
}

