/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBasePotion;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AstralPotion
extends ItemBasePotion {
    public static Omniconfig.IntParameter cooldown;
    public static Omniconfig.DoubleParameter durationMultiplier;

    public AstralPotion() {
        super(AstralPotion.getDefaultProperties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("PotionofCosmic");
        cooldown = builder.comment("The cooldown of Potion of Cosmic. Measured in ticks.").max(32000.0).getInt("Cooldown", 2400);
        durationMultiplier = builder.comment("The Duration Multiplier of Potion of Cosmic.").max(32.0).getDouble("DurationMultiplier", 1.6);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.astralPotion1");
            if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"isDrunk", (boolean)false)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.astralPotion2");
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (!entityIn.m_9236_().f_46443_) {
                if (player.getPersistentData().m_128451_("CosmicPotion") > 0) {
                    if (!ItemNBTHelper.getBoolean((ItemStack)stack, (String)"isDrunk", (boolean)false)) {
                        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"isDrunk", (boolean)true);
                    }
                } else if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"isDrunk", (boolean)false)) {
                    ItemNBTHelper.setBoolean((ItemStack)stack, (String)"isDrunk", (boolean)false);
                }
            }
        }
    }

    public void onConsumed(Level world, Player player, ItemStack potion) {
        world.m_5594_(null, player.m_20183_(), EnigmaticSounds.CHARGED_ON, SoundSource.PLAYERS, (float)(0.8 + Math.random() * 0.2), (float)(0.8 + Math.random() * 0.2));
        if (player.getPersistentData().m_128451_("CosmicPotion") <= 0) {
            Collection activeEffects = player.m_21220_();
            if (!activeEffects.isEmpty()) {
                player.getPersistentData().m_128405_("CosmicPotion", cooldown.getValue());
                for (MobEffectInstance effect : activeEffects) {
                    if (effect.f_19503_ <= 0) continue;
                    effect.f_19503_ = (int)(durationMultiplier.getValue() * (double)effect.f_19503_);
                }
            }
        } else {
            player.getPersistentData().m_128473_("CosmicPotion");
            player.m_21219_();
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 600));
        }
    }
}

