/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.contents.entities.AbyssProjectile;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.packets.clients.PacketPlaySound;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.addon.registries.EnigmaticAddonParticles;
import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.IEldritch;
import com.aizistral.enigmaticlegacy.entities.PermanentItemEntity;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public class AnnihilatingSword
extends SwordItem
implements IEldritch {
    public static Omniconfig.PerhapsParameter onlyMainHandModifier;
    public static Omniconfig.PerhapsParameter damageEnchantmentPerModifier;
    public static Omniconfig.PerhapsParameter energyMultiplier;
    public static Omniconfig.PerhapsParameter chargingDamageResistance;
    public static final List<ResourceLocation> IngredientList;
    private static final String[] defaultIngredientList;
    private static final Tier TIER;

    public AnnihilatingSword() {
        super(TIER, 11, -2.8f, new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC).m_41486_());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("DecisionofAnnihilation");
        onlyMainHandModifier = builder.comment("The damage modifier when offhand is empty. Measured as percentage.").min(100.0).getPerhaps("OnlyMainHandModifier", 100);
        damageEnchantmentPerModifier = builder.comment("The damage modifier per every level of damage enchantments. Measured as percentage.").min(10.0).getPerhaps("DamageEnchantmentPerModifier", 15);
        energyMultiplier = builder.comment("The damage multiplier per every level of energy. Measured as percentage.").min(10.0).getPerhaps("EnergyMultiplier", 20);
        chargingDamageResistance = builder.comment("The damage resistance when charging with the Decision of Annihilation. Measured as percentage.").max(90.0).min(0.0).getPerhaps("ChargingDamageResistance", 80);
        IngredientList.clear();
        builder.forceSynchronized(true);
        String[] list = builder.config.getStringList("DecisionofAnnihilationCraftingIngredients", "Balance Options", defaultIngredientList, "List of items that will be the crafting ingredients of the Decision of Annihilation. Examples: enigmaticlegacy:etherium_ingot. Changing this option required game restart to take effect.");
        Arrays.stream(list).forEach(entry -> IngredientList.add(new ResourceLocation(entry)));
        builder.popPrefix();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parry(Level level, ServerPlayer blocker, DamageSource source, float damage, ItemStack stack) {
        Object entities;
        int tick = stack.m_41779_() - blocker.m_21212_();
        stack.m_41622_(Mth.m_14143_((float)(damage / 2.0f)), (LivingEntity)blocker, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        blocker.m_36335_().m_41524_(stack.m_41720_(), Mth.m_14045_((int)tick, (int)30, (int)50) - (tick <= 8 ? 5 : 0));
        blocker.m_6674_(blocker.m_7655_());
        blocker.m_5810_();
        blocker.getPersistentData().m_128405_("AnniInvTime", 15);
        if (source.m_7639_() != null) {
            EnigmaticAddons.packetInstance.send(PacketDistributor.PLAYER.with(() -> blocker), (Object)new PacketPlaySound(SoundEvents.f_12346_, 0.5f, 1.1f + 0.2f * blocker.m_217043_().m_188501_()));
        }
        if (tick <= 8 && source.m_7639_() != null) {
            EnigmaticAddons.packetInstance.send(PacketDistributor.PLAYER.with(() -> blocker), (Object)new PacketPlaySound(SoundEvents.f_11668_, 0.5f, 1.2f + 0.3f * blocker.m_217043_().m_188501_()));
            AnnihilatingSword.addEnergy(level, stack, blocker);
        }
        float dmg = (float)(blocker.m_21204_().m_22181_(Attributes.f_22281_) + 8.0 + (double)damage);
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            entities = level.m_45976_(LivingEntity.class, attacker.m_20191_().m_82400_(1.2));
            Iterator iterator = entities.iterator();
            while (iterator.hasNext()) {
                LivingEntity entity2 = (LivingEntity)iterator.next();
                if (entity2 == blocker) continue;
                double xRatio = blocker.m_20185_() - entity2.m_20185_();
                double zRatio = blocker.m_20189_() - entity2.m_20189_();
                entity2.f_19812_ = true;
                Vec3 vec = entity2.m_20184_();
                Vec3 add = new Vec3(xRatio, 0.0, zRatio).m_82541_().m_82490_(tick < 25 ? (double)1.2f : (double)0.55f).m_82490_(1.0 - 0.5 * entity2.m_21133_(Attributes.f_22278_));
                if (tick <= 8) {
                    entity2.m_6469_(entity2.m_269291_().m_269333_((LivingEntity)blocker), dmg * 0.5f);
                }
                entity2.m_20334_(vec.f_82479_ / 2.0 - add.f_82479_, entity2.m_20096_() ? Math.min(0.4, vec.f_82480_ / 2.0 + 0.5) : vec.f_82480_, vec.f_82481_ / 2.0 - add.f_82481_);
            }
            return;
        }
        entities = source.m_7640_();
        if (!(entities instanceof Projectile)) return;
        Projectile projectile = (Projectile)entities;
        if (tick > 8) return;
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            if (arrow.f_36705_ == AbstractArrow.Pickup.ALLOWED) return;
        }
        boolean bl = true;
        boolean discard = bl;
        if (!discard) return;
        AbyssProjectile abyssProjectile = new AbyssProjectile(blocker.m_9236_(), (LivingEntity)blocker);
        abyssProjectile.setDamage(dmg * 4.0f);
        if (source.m_7639_() != null) {
            abyssProjectile.setTarget(source.m_7639_());
        }
        abyssProjectile.m_146884_(projectile.m_20182_());
        abyssProjectile.m_20256_(projectile.m_20184_().m_82490_(-1.6));
        blocker.m_9236_().m_7967_((Entity)abyssProjectile);
        projectile.m_146870_();
    }

    private static void addEnergy(Level level, ItemStack stack, ServerPlayer player) {
        boolean abyssBoost = SuperAddonHandler.isAbyssBoost((Player)player);
        int part = stack.m_41784_().m_128451_("AnniEnergyPart");
        if ((part += player.m_217043_().m_188503_(abyssBoost ? 6 : 4) + 1) > 10) {
            part -= 10;
            int energy = stack.m_41784_().m_128451_("AnniEnergy");
            EnigmaticAddons.packetInstance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketPlaySound(EnigmaticSounds.CHARGED_ON, 1.8f, 0.5f + 0.25f * (float)energy));
            stack.m_41784_().m_128405_("AnniEnergy", Math.min(abyssBoost ? 5 : 3, energy + 1));
        }
        stack.m_41784_().m_128405_("AnniEnergyPart", part);
    }

    public static void sweep(Player player, int level, float damage) {
        damage *= 1.2f + 0.08f * (float)level;
        Vec3 position = player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0);
        Vec3 offset = new Vec3((double)(level + 3), 0.5, (double)(level + 3));
        AABB box = new AABB(position.m_82546_(offset), position.m_82549_(offset));
        float ratio = (float)Math.PI / 180 * player.m_146908_();
        box = box.m_82386_((double)((float)(-level) * Mth.m_14031_((float)ratio)), 0.0, (double)((float)level * Mth.m_14089_((float)ratio)));
        List entities = player.m_9236_().m_6443_(LivingEntity.class, box, Entity::m_6084_);
        for (LivingEntity entity : entities) {
            ArmorStand armorStand;
            if (entity == player || player.m_7307_((Entity)entity) || entity instanceof ArmorStand && (armorStand = (ArmorStand)entity).m_31677_() || (double)entity.m_20270_((Entity)player) > player.getEntityReach() + (double)level || !(entity.m_20270_((Entity)player) < (float)level) && !(entity.m_20182_().m_82546_(player.m_20182_()).m_82526_(player.m_20156_()) > 0.0)) continue;
            entity.m_147240_((double)level * 0.5 + 0.4, (double)Mth.m_14031_((float)ratio), (double)(-Mth.m_14089_((float)ratio)));
            entity.m_6469_(player.m_269291_().m_269075_(player), damage);
            Level level2 = entity.m_9236_();
            if (!(level2 instanceof ServerLevel)) continue;
            ServerLevel server = (ServerLevel)level2;
            server.m_8767_((ParticleOptions)EnigmaticAddonParticles.ABYSS_CHAOS, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 16, (double)entity.m_20205_(), (double)(entity.m_20206_() / 2.0f), (double)entity.m_20205_(), 0.0);
        }
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.2f, 0.2f);
        player.m_6674_(InteractionHand.MAIN_HAND);
        player.m_36334_();
        player.m_36346_();
        player.getPersistentData().m_128350_("AnniSweepDamage", damage);
        player.getPersistentData().m_128405_("AnniSweepTick", 5);
        player.getPersistentData().m_128405_("AnniSweepEnergy", level);
    }

    public static void rangeAttack(Player player, int level, float damage) {
        for (int i = 0; i < 4 * level; ++i) {
            AbyssProjectile abyssProjectile = new AbyssProjectile(player.m_9236_(), (LivingEntity)player);
            abyssProjectile.setDamage(damage);
            abyssProjectile.m_146884_(new Vec3(player.m_20208_(1.0), player.m_20187_(), player.m_20262_(1.0)));
            abyssProjectile.m_20256_(abyssProjectile.m_20182_().m_82546_(player.m_20182_()).m_82520_(0.0, 0.32, 0.0).m_82490_(1.5));
            player.m_9236_().m_7967_((Entity)abyssProjectile);
        }
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.25f, 1.5f);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.2f, 0.2f);
        player.m_6674_(InteractionHand.MAIN_HAND);
        player.m_36334_();
        player.m_36346_();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        int energy = stack.m_41784_().m_128451_("AnniEnergy");
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(15 + energy * 3), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)energy * 0.1 - 2.8, AttributeModifier.Operation.ADDITION));
        if (energy > 0) {
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(UUID.fromString("2e24be65-2fe7-4311-8892-8f9eb7d51f80"), "Weapon modifier", (double)energy * 0.3, AttributeModifier.Operation.ADDITION));
        }
        return slot == EquipmentSlot.MAINHAND ? builder.build() : super.getAttributeModifiers(slot, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticaddons.annihilatingSwordOwner").m_130940_(EnigmaticAddons.Acceptors.contains(player.m_20148_()) ? ChatFormatting.RED : ChatFormatting.LIGHT_PURPLE));
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword4");
            if (player != null && player.m_21206_().equals(stack)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword5Off");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword6Off");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword5Main", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("+%d%%", this.getMainHandModifier(stack))});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword6Main");
            }
            int energy = stack.m_41784_().m_128451_("AnniEnergy");
            if (energy > 0) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword7", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{energy});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.annihilatingSword8", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("\u00d7%.02f", Float.valueOf(1.0f + (float)energy * energyMultiplier.getValue().asModifier()))});
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateWorthyOnesOnly(list);
            if (player != null && SuperAddonHandler.isAbyssBoost((Player)player)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.abyssBoost");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateCursedOnesOnly(list);
        }
        if (stack.m_41793_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (!SuperpositionHandler.isTheWorthyOne((Player)player)) {
            return InteractionResultHolder.m_19098_((Object)itemInHand);
        }
        if (hand.equals((Object)InteractionHand.OFF_HAND) && player.m_21205_().m_41619_()) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemInHand);
        }
        if (hand.equals((Object)InteractionHand.MAIN_HAND) && player.m_21206_().m_41619_() && itemInHand.m_41784_().m_128451_("AnniEnergy") > 0) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemInHand);
        }
        return InteractionResultHolder.m_19098_((Object)itemInHand);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity living, int tick) {
        Player player;
        if (living instanceof Player && (player = (Player)living).m_21206_().m_150930_((Item)this)) {
            player.m_36335_().m_41524_((Item)this, 8);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        ItemStack mainHandItem;
        int energy;
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_21205_().m_150930_((Item)this) && (energy = (mainHandItem = player.m_21205_()).m_41784_().m_128451_("AnniEnergy")) > 0) {
            float damage = (float)player.m_21204_().m_22181_(Attributes.f_22281_) + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
            if (SuperAddonHandler.isAbyssBoost(player)) {
                AnnihilatingSword.sweep(player, energy, damage);
                AnnihilatingSword.rangeAttack(player, energy, damage);
            } else if (player.m_20096_() || player.m_9236_().m_8055_(player.m_20183_().m_6625_(2)).m_60815_()) {
                AnnihilatingSword.sweep(player, energy, damage);
            } else {
                AnnihilatingSword.rangeAttack(player, energy, damage);
            }
            player.m_36335_().m_41524_((Item)this, 100 - energy * 8);
            stack.m_41622_(energy * 3, (LivingEntity)player, user -> user.m_21166_(EquipmentSlot.MAINHAND));
            int level = stack.getEnchantmentLevel(Enchantments.f_44986_);
            if (level > 0 && player.m_217043_().m_188503_(level + 3) < level) {
                mainHandItem.m_41784_().m_128405_("AnniEnergy", energy / 2);
            } else {
                mainHandItem.m_41784_().m_128473_("AnniEnergy");
            }
        }
        return stack;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6883_(ItemStack stack, Level world, Entity entity, int id, boolean selected) {
        if (world.m_5776_()) return;
        CompoundTag tag = stack.m_41784_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (tag.m_128403_("AnniOwner")) {
                UUID playerUUID = player.m_20148_();
                long code = tag.m_128454_("AnniCode");
                if (code == SuperAddonHandler.encodeUUID(playerUUID)) {
                    if (tag.m_128342_("AnniOwner").equals(player.m_20148_())) return;
                    stack.m_41774_(1);
                    return;
                }
                if (EnigmaticAddons.Acceptors.contains(playerUUID)) {
                    tag.m_128356_("AnniCode", SuperAddonHandler.encodeUUID(playerUUID));
                    return;
                }
                stack.m_41774_(1);
                return;
            }
        }
        stack.m_41774_(1);
    }

    private int getMainHandModifier(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        int maxLevel = 0;
        for (Enchantment enc : enchantments.keySet()) {
            if (!(enc instanceof DamageEnchantment) || (Integer)enchantments.get(enc) <= maxLevel) continue;
            maxLevel = (Integer)enchantments.get(enc);
        }
        return onlyMainHandModifier.getValue().asPercentage() + maxLevel * damageEnchantmentPerModifier.getValue().asPercentage();
    }

    private Multimap<Attribute, AttributeModifier> getAttackSpeedBonus() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("015012f8-8638-4c33-8f4a-b187680e8b80"), "Block Bonus", 2.0, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        return target.m_20191_().m_82377_(1.75, 0.3, 1.75);
    }

    public int m_8105_(ItemStack stack) {
        int energy = stack.m_41784_().m_128451_("AnniEnergy");
        return energy > 0 ? 24 : 32000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        LivingEntity victim = event.getEntity();
        if (victim.getPersistentData().m_128451_("AnniInvTime") > 0) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        LivingEntity entity;
        LivingEntity victim = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).m_21205_().m_150930_((Item)this)) {
            ItemStack mainHandItem;
            int energy;
            if (entity.m_21206_().m_41619_()) {
                event.setAmount(event.getAmount() * (1.0f + 0.01f * (float)this.getMainHandModifier(entity.m_21205_())));
            }
            if ((energy = (mainHandItem = entity.m_21205_()).m_41784_().m_128451_("AnniEnergy")) > 0) {
                event.setAmount(event.getAmount() * (1.0f + (float)energy * energyMultiplier.getValue().asModifier()));
            }
            if (EnigmaticAddons.Acceptors.contains(entity.m_20148_())) {
                CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(handler -> {
                    IItemHandlerModifiable curios = handler.getEquippedCurios();
                    for (int i = 0; i < handler.getSlots() - 1; ++i) {
                        if (!(curios.getStackInSlot(i).m_41720_() instanceof IEldritch)) continue;
                        event.setAmount(event.getAmount() * 1.05f);
                    }
                });
            }
        }
        if (victim.m_21211_().m_150930_((Item)this) && victim.m_7655_() == InteractionHand.MAIN_HAND) {
            event.setAmount(event.getAmount() * (1.0f - chargingDamageResistance.getValue().asModifier()));
        }
        if (EnigmaticAddons.Acceptors.contains(victim.m_20148_())) {
            CuriosApi.getCuriosInventory((LivingEntity)victim).ifPresent(handler -> {
                IItemHandlerModifiable curios = handler.getEquippedCurios();
                for (int i = 0; i < handler.getSlots() - 1; ++i) {
                    if (!(curios.getStackInSlot(i).m_41720_() instanceof IEldritch)) continue;
                    event.setAmount(event.getAmount() * 0.95f);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttackLast(LivingDamageEvent event) {
        LivingEntity entity;
        LivingEntity victim = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).m_21205_().m_150930_((Item)this)) {
            if (!entity.m_21206_().m_41619_()) {
                return;
            }
            CompoundTag data = victim.getPersistentData();
            float annihilation = data.m_128457_("AnnihilationPoint") + 0.1f * event.getAmount() / victim.m_21223_();
            if (entity.m_217043_().m_188501_() < annihilation) {
                Level level;
                data.m_128379_("AnnihilationKill", true);
                if (victim.m_6084_()) {
                    event.setAmount(event.getAmount() * 10.0f);
                }
                if ((level = entity.m_9236_()) instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.m_8767_((ParticleOptions)EnigmaticAddonParticles.ABYSS_CHAOS, victim.m_20185_(), victim.m_20188_(), victim.m_20189_(), 16, (double)victim.m_20205_(), (double)(victim.m_20206_() / 2.0f), (double)entity.m_20205_(), 0.0);
                }
            }
            data.m_128350_("AnnihilationPoint", annihilation);
        }
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingTickEvent event) {
        Level level;
        Player player;
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_5776_()) {
            int anniInvTime;
            if (entity.getPersistentData().m_128471_("AnnihilationKill")) {
                entity.m_6469_(entity.m_269291_().m_287172_(), entity.m_21233_() / 3.0f);
            }
            if ((anniInvTime = entity.getPersistentData().m_128451_("AnniInvTime")) > 0) {
                entity.m_21204_().m_22178_(this.getAttackSpeedBonus());
                entity.getPersistentData().m_128405_("AnniInvTime", anniInvTime - 1);
            } else {
                entity.m_21204_().m_22161_(this.getAttackSpeedBonus());
                entity.getPersistentData().m_128473_("AnniInvTime");
            }
        } else {
            float powerTime = entity.getPersistentData().m_128457_("AnniPowerTick");
            entity.getPersistentData().m_128350_("AnniLastTick", powerTime);
            powerTime = entity.m_21211_().m_150930_((Item)this) && entity.m_7655_().equals((Object)InteractionHand.MAIN_HAND) ? Math.min(24.0f, (float)entity.m_21212_()) : (24.0f - powerTime < 1.0f ? 24.0f : (powerTime += (24.0f - powerTime) * 0.2f));
            entity.getPersistentData().m_128350_("AnniPowerTick", powerTime);
        }
        if (entity instanceof Player && SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)entity)) && player.getPersistentData().m_128451_("AnniSweepTick") > 0 && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int energy = player.getPersistentData().m_128451_("AnniSweepEnergy");
            int tick = player.getPersistentData().m_128451_("AnniSweepTick");
            float base = (float)Math.PI / 180 * player.m_146908_();
            double x = -(3.0 + 0.3 * (double)energy) * (double)Mth.m_14031_((float)((float)((double)base + (double)((float)(tick - 3) * 25.0f) * (Math.PI / 180)))) + player.m_20185_() - (double)(Mth.m_14031_((float)base) * 0.6f);
            double y = player.m_20227_(0.5);
            double z = (3.0 + 0.3 * (double)energy) * (double)Mth.m_14089_((float)((float)((double)base + (double)((float)(tick - 3) * 25.0f) * (Math.PI / 180)))) + player.m_20189_() + (double)(Mth.m_14089_((float)base) * 0.6f);
            server.m_5594_(null, player.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.25f, 1.5f);
            server.m_8767_((ParticleOptions)EnigmaticAddonParticles.ABYSS_CHAOS, x, y, z, 32, 1.0, 1.0, 1.0, 0.02);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123771_, x, y, z, 32, 1.0, 1.0, 1.0, 0.02);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
            player.getPersistentData().m_128405_("AnniSweepTick", tick - 1);
            float damage = player.getPersistentData().m_128457_("AnniSweepDamage");
            double o = 0.8 + 0.45 * (double)energy;
            AABB aabb = new AABB(x - o, y - o, z - o, x + o, y + o, z + o);
            List entities = server.m_6443_(LivingEntity.class, aabb, Entity::m_6084_);
            for (LivingEntity target : entities) {
                if (target == player || player.m_7307_((Entity)target) || target instanceof ArmorStand && ((ArmorStand)target).m_31677_()) continue;
                target.m_6469_(SuperAddonHandler.damageSource((Entity)target, EnigmaticAddonDamageTypes.ABYSS, (Entity)player), damage * 0.4f);
            }
        }
    }

    static {
        IngredientList = new ArrayList<ResourceLocation>();
        defaultIngredientList = new String[]{"enigmaticlegacy:cosmic_heart", "enigmaticlegacy:evil_ingot", "enigmaticlegacy:twisted_heart"};
        TIER = new ForgeTier(10, 3268, 10.8f, 8.0f, 64, BlockTags.f_144284_, () -> Ingredient.f_43901_);
    }

    public static class Unknown
    extends SwordItem
    implements IEldritch {
        public Unknown() {
            super(TIER, 11, -2.2f, new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC).m_41486_());
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        private int getCount(ItemStack stack, Level world, @Nullable Player player) {
            int demand = stack.m_41784_().m_128451_("AnniCacheDemand");
            if (demand <= 0 || player != null && player.f_19797_ % 1200 == 0) {
                int size = 0;
                for (EntityType value : ForgeRegistries.ENTITY_TYPES.getValues()) {
                    try {
                        if (!(value.m_20615_(world) instanceof LivingEntity)) continue;
                        ++size;
                    }
                    catch (Exception exception) {}
                }
                int i = 20 + Mth.m_14107_((double)(Math.pow(size, 0.875) * 0.8974862694740295));
                i = player != null && EnigmaticAddons.Acceptors.contains(player.m_20148_()) ? i * 4 / 5 : i;
                stack.m_41784_().m_128405_("AnniCacheDemand", i);
                return i;
            }
            return demand;
        }

        public void m_6883_(ItemStack stack, Level world, Entity entity, int id, boolean selected) {
            ListTag list;
            Player player;
            CompoundTag tag = stack.m_41784_();
            if (entity instanceof Player && SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)entity)) && player.m_6844_(EquipmentSlot.HEAD).equals(stack) && tag.m_128471_("AnniAvailable") && (list = stack.m_41784_().m_128437_("AnniSoulCount", 10)).size() > this.getCount(stack, world, player)) {
                world.m_5594_(player, player.m_20183_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                ItemStack sword = EnigmaticAddonItems.ANNIHILATING_SWORD.m_7968_();
                UUID uuid = player.m_20148_();
                player.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                sword.m_41784_().m_128362_("AnniOwner", uuid);
                sword.m_41784_().m_128356_("AnniCode", SuperAddonHandler.encodeUUID(uuid));
                PermanentItemEntity itemEntity = new PermanentItemEntity(world, player.m_20185_(), player.m_20227_(0.6), player.m_20189_(), sword);
                itemEntity.setOwnerId(uuid);
                itemEntity.setThrowerId(uuid);
                world.m_7967_((Entity)itemEntity);
            }
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
            ListTag list = stack.m_41784_().m_128437_("AnniSoulCount", 10);
            int count = this.getCount(stack, EnigmaticLegacy.PROXY.getCentralWorld(), null);
            if (count < 10) {
                return super.getAttributeModifiers(slot, stack);
            }
            int multi = Mth.m_14045_((int)(list.size() / (count / 10)), (int)0, (int)9);
            if (multi <= 0) {
                return super.getAttributeModifiers(slot, stack);
            }
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(UUID.fromString("00a4d7d3-d8ef-4df9-b6a7-5ed39f6a7c24"), "?? modifier", (double)((float)(-count) * 0.1f), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("f286bd6f-49ed-4f61-a14b-ba538a3c0f3f"), "?? modifier", -0.1 * (double)multi, AttributeModifier.Operation.MULTIPLY_TOTAL));
            return slot == EquipmentSlot.HEAD ? builder.build() : super.getAttributeModifiers(slot, stack);
        }

        public EquipmentSlot getEquipmentSlot(ItemStack stack) {
            return stack.m_41784_().m_128471_("AnniAvailable") ? EquipmentSlot.HEAD : null;
        }

        public boolean m_5812_(ItemStack stack) {
            return true;
        }

        public boolean m_8120_(ItemStack stack) {
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateWorthyOnesOnly(list);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onDeath(LivingDeathEvent event) {
            ItemStack item;
            Player player;
            LivingEntity victim = event.getEntity();
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof Player && SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)entity)) && (item = player.m_6844_(EquipmentSlot.HEAD)).m_150930_((Item)this)) {
                ListTag tag = item.m_41784_().m_128437_("AnniSoulCount", 10);
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128359_("id", victim.m_6095_().m_20675_());
                if (!tag.contains((Object)compoundtag)) {
                    tag.add((Object)compoundtag);
                }
                item.m_41700_("AnniSoulCount", (Tag)tag);
            }
        }
    }
}

