/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.entities;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEntities;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class SoulFlameBall
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<Boolean> ID_FIRED = SynchedEntityData.m_135353_(SoulFlameBall.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int fireTime = 0;
    @Nullable
    private UUID targetUUID;
    @Nullable
    private Entity cachedTarget;

    public SoulFlameBall(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
        this.m_20242_(true);
    }

    public SoulFlameBall(Level world, LivingEntity owner) {
        this(EnigmaticAddonEntities.SOUL_FLAME_BALL, world);
        this.m_5602_((Entity)owner);
        int id = this.getPersistentData().m_128451_("BallID");
        int offset = id * 18 + owner.f_19797_ % 90;
        Vec3 position = owner.m_20318_(0.0f).m_82549_(owner.m_20184_()).m_82520_(0.0, (double)owner.m_20206_() * 0.4, 0.0);
        this.m_146884_(position.m_82520_(Math.sin(0.06981317007977318 * (double)offset), 0.0, Math.cos(0.06981317007977318 * (double)offset)));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID_FIRED, (Object)false);
    }

    public boolean isFired() {
        return (Boolean)this.f_19804_.m_135370_(ID_FIRED);
    }

    public void setFired(boolean isPowered) {
        this.f_19804_.m_135381_(ID_FIRED, (Object)isPowered);
    }

    public void checkTarget() {
        Entity owner = this.m_19749_();
        if (owner == null || this.f_19797_ < 10) {
            return;
        }
        List livingEntities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(16.0), entity -> entity.m_6084_() && entity instanceof Targeting);
        for (LivingEntity livingEntity : livingEntities) {
            LivingEntity target = ((Targeting)livingEntity).m_5448_();
            if (target == null || !target.m_7306_(owner)) continue;
            this.setTarget((Entity)livingEntity);
            if (!this.isFired()) {
                this.m_20256_(this.m_20182_().m_82546_(owner.m_20182_()).m_82520_(0.0, 0.32, 0.0).m_82490_(1.5));
            }
            this.setFired(true);
            break;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (this.fireTime > 125 || owner == null) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.isFired()) {
                Vec3 movement = this.m_20184_();
                Entity cachedTarget = this.getCachedTarget();
                if (cachedTarget != null && cachedTarget.m_6084_()) {
                    Vec3 target = new Vec3(cachedTarget.m_20185_(), cachedTarget.m_20227_(0.5), cachedTarget.m_20189_());
                    Vec3 delta = target.m_82546_(this.m_20182_());
                    if (delta.m_82553_() < 16.0) {
                        delta = delta.m_82541_().m_82490_(0.56).m_82549_(movement);
                    } else {
                        this.checkTarget();
                    }
                    movement = delta.m_82490_((double)0.7f);
                    this.m_20256_(movement);
                    double d4 = movement.m_165924_();
                    this.m_146922_((float)(Mth.m_14136_((double)(-movement.f_82479_), (double)(-movement.f_82481_)) * 57.2957763671875));
                    this.m_146926_((float)(Mth.m_14136_((double)movement.f_82480_, (double)d4) * 57.2957763671875));
                } else {
                    this.checkTarget();
                }
                HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
                if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_(hitresult);
                }
                this.f_19854_ = this.m_20185_();
                this.f_19855_ = this.m_20186_();
                this.f_19856_ = this.m_20189_();
                this.m_6034_(this.m_20185_() + movement.f_82479_, this.m_20186_() + movement.f_82480_, this.m_20189_() + movement.f_82481_);
                ++this.fireTime;
            } else {
                List playerList = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(10.0));
                boolean flag = false;
                for (Player player : playerList) {
                    if (owner != player) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.m_146870_();
                } else {
                    this.checkTarget();
                    int id = this.getPersistentData().m_128451_("BallID");
                    int offset = id * 18 + owner.f_19797_ % 90;
                    Vec3 position = new Vec3(owner.m_20185_(), owner.m_20186_(), owner.m_20189_()).m_82520_(0.0, (double)owner.m_20206_() * 0.4, 0.0);
                    this.m_146884_(position.m_82520_(Math.sin(0.06981317007977318 * (double)offset), 0.0, Math.cos(0.06981317007977318 * (double)offset)));
                }
            }
        } else {
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (this.isFired()) {
                Vec3 movement = this.m_20184_();
                for (int i = 1; i < 3; ++i) {
                    double x = this.m_20185_() + movement.f_82479_ * (double)i / 3.0;
                    double y = this.m_20227_(0.5) + movement.f_82480_ * (double)i / 3.0;
                    double z = this.m_20189_() + movement.f_82481_ * (double)i / 3.0;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected boolean m_5603_(Entity entity) {
        return !this.m_150171_(entity) && super.m_5603_(entity);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Entity target = hitResult.m_82443_();
            if (target == this.m_19749_()) {
                return;
            }
            int level = target.getPersistentData().m_128451_("IllusionSoulLevel");
            float damage = Math.min(2.0f + (float)level, livingEntity.m_21233_() * 0.75f);
            target.m_6469_(SuperAddonHandler.damageSource(target, (ResourceKey<DamageType>)DamageTypes.f_268515_, (Entity)this, this.m_19749_()), damage);
            target.f_19802_ = 0;
            target.getPersistentData().m_128405_("IllusionSoulLevel", level + 1);
            Vec3 mv = this.m_20184_().m_82490_(0.5);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + mv.f_82479_, this.m_20186_() + mv.f_82480_, this.m_20189_() + mv.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
        }
    }

    public void setTarget(@Nullable Entity entity) {
        if (entity != null) {
            this.targetUUID = entity.m_20148_();
            this.cachedTarget = entity;
        }
    }

    @Nullable
    public Entity getCachedTarget() {
        Level level;
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.cachedTarget = server.m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    public void m_7380_(CompoundTag tag) {
        if (this.targetUUID != null) {
            tag.m_128362_("TargetUUID", this.targetUUID);
        }
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("TargetUUID")) {
            this.targetUUID = tag.m_128342_("TargetUUID");
            this.cachedTarget = null;
        }
    }

    public ItemStack m_7846_() {
        return EnigmaticAddonItems.SOUL_FLAME_BALL.m_7968_();
    }
}

