/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.crafting;

import auviotre.enigmatic.addon.contents.items.DragonBow;
import auviotre.enigmatic.addon.contents.items.UltimatePotionAddon;
import auviotre.enigmatic.addon.helpers.PotionAddonHelper;
import com.aizistral.enigmaticlegacy.helpers.PotionHelper;
import com.aizistral.enigmaticlegacy.items.UltimatePotionSplash;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class DragonBowBrewingRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<DragonBowBrewingRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(DragonBowBrewingRecipe::new);

    public DragonBowBrewingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess access) {
        ItemStack bow = null;
        boolean hasWater = false;
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack checkedStack = inventory.m_8020_(i);
            if (checkedStack.m_41619_()) continue;
            if (checkedStack.m_41720_() instanceof DragonBow) {
                if (bow != null) {
                    return ItemStack.f_41583_;
                }
                bow = checkedStack.m_41777_();
                continue;
            }
            if (checkedStack.m_41720_() instanceof SplashPotionItem) {
                if (PotionUtils.m_43579_((ItemStack)checkedStack) == Potions.f_43599_) {
                    hasWater = true;
                }
                effects.addAll(PotionUtils.m_43579_((ItemStack)checkedStack).m_43488_());
                continue;
            }
            if (checkedStack.m_41720_() instanceof UltimatePotionSplash) {
                effects.addAll(PotionHelper.getEffects((ItemStack)checkedStack));
                continue;
            }
            if (!(checkedStack.m_41720_() instanceof UltimatePotionAddon.Splash)) continue;
            effects.addAll(PotionAddonHelper.getEffects(checkedStack));
        }
        if (bow == null) {
            return ItemStack.f_41583_;
        }
        if (hasWater) {
            DragonBow.resetEffect(bow);
            return bow;
        }
        for (MobEffectInstance effect : effects) {
            DragonBow.addEffect(bow, effect);
        }
        return effects.isEmpty() ? ItemStack.f_41583_ : bow;
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        ItemStack bow = null;
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack checkedStack = inventory.m_8020_(i);
            if (checkedStack.m_41619_()) continue;
            if (checkedStack.m_41720_() instanceof DragonBow) {
                if (bow != null) {
                    return false;
                }
                bow = checkedStack.m_41777_();
                continue;
            }
            if (checkedStack.m_41720_() instanceof SplashPotionItem) {
                potions.add(checkedStack);
                continue;
            }
            if (checkedStack.m_41720_() instanceof UltimatePotionSplash) {
                potions.add(checkedStack);
                continue;
            }
            if (!(checkedStack.m_41720_() instanceof UltimatePotionAddon.Splash)) continue;
            potions.add(checkedStack);
        }
        return bow != null && !potions.isEmpty() && potions.toArray().length <= DragonBow.maxPotionAmount.getValue();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

