/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.handlers;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.delicacy.contents.enchantments.SlicingEnchantment;
import auviotre.enigmatic.delicacy.contents.items.AbyssalStew;
import auviotre.enigmatic.delicacy.contents.items.AstralCruet;
import auviotre.enigmatic.delicacy.contents.items.GluttonyCharm;
import auviotre.enigmatic.delicacy.contents.objects.FoodEffectRefreshCommand;
import auviotre.enigmatic.delicacy.contents.objects.abyss.AbyssDataCapability;
import auviotre.enigmatic.delicacy.contents.objects.abyss.IAbyssData;
import auviotre.enigmatic.delicacy.handlers.SuperDelightHandler;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightBlocks;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEffects;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEnchantments;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightItems;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightTags;
import com.aizistral.enigmaticlegacy.config.OmniconfigHandler;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ExperienceHelper;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.tag.ModTags;

@Mod.EventBusSubscriber(modid="enigmaticdelicacy")
public class EnigmaticDelightEventHandler {
    public static final List<ResourceKey<DamageType>> ATTACK_LIST = List.of(DamageTypes.f_268566_, DamageTypes.f_268464_, DamageTypes.f_268433_);
    public static final Map<Player, AABB> DESOLATION_BOOST_BOXES = new WeakHashMap<Player, AABB>();

    @SubscribeEvent
    public void onWandererTradesEvent(@NotNull WandererTradesEvent event) {
        List rareTrades = event.getRareTrades();
        rareTrades.add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 9), new ItemStack((ItemLike)EnigmaticDelightItems.ENIGMATIC_SEED), 2, 5, 0.25f));
    }

    @SubscribeEvent
    public void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity entity = event.getEntity();
        LivingEntity target = event.getNewTarget();
        if (entity instanceof Targeting) {
            Targeting targetedEntity = (Targeting)entity;
            if (target instanceof Player) {
                Player player = (Player)target;
                if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET && entity.m_21188_() != player && (targetedEntity.m_5448_() == null || !targetedEntity.m_5448_().m_6084_()) && player.m_21023_((MobEffect)EnigmaticDelightEffects.FADING_EFFECT)) {
                    event.setCanceled(true);
                }
                if (entity.m_21188_() != player && (targetedEntity.m_5448_() == null || !targetedEntity.m_5448_().m_6084_()) && SuperAddonHandler.isAbyssBoost((Player)player) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.DESOLATION_RING)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onCriticalHit(@NotNull CriticalHitEvent event) {
        Player player = event.getEntity();
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticDelightItems.WEAPON_CHARM) && player.m_21051_(Attributes.f_22283_).m_22135_() < 1.5) {
            event.setDamageModifier(event.getDamageModifier() + 0.5f);
        }
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticDelightItems.GLUTTONY_CHARM)) {
            float crit = (float)((double)SuperDelightHandler.getMissingFoodProperty(event.getEntity()) * GluttonyCharm.critModifier.getValue());
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.HELL_BLADE_CHARM) && crit > 0.75f) {
                crit += 0.35f;
            }
            event.setDamageModifier(event.getDamageModifier() + crit);
        }
        if (player.m_21023_((MobEffect)EnigmaticDelightEffects.ASTRAL_DRUNKENNESS_EFFECT)) {
            int amplifier = player.m_21124_((MobEffect)EnigmaticDelightEffects.ASTRAL_DRUNKENNESS_EFFECT).m_19564_();
            event.setDamageModifier(event.getDamageModifier() + (float)(amplifier + 1) * 0.1f);
        }
    }

    @SubscribeEvent
    public void onFoodStart(@NotNull LivingEntityUseItemEvent.Start event) {
        LivingEntity entity = event.getEntity();
        if (event.getItem().m_41614_() && entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                if (entity.m_21023_((MobEffect)EnigmaticDelightEffects.ASTRAL_DRUNKENNESS_EFFECT)) {
                    int amplifier = entity.m_21124_((MobEffect)EnigmaticDelightEffects.ASTRAL_DRUNKENNESS_EFFECT).m_19564_();
                    event.setDuration(Mth.m_14107_((double)((double)event.getDuration() * (1.0 + (double)amplifier * 0.15))));
                }
                if (SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticDelightBlocks.ASTRAL_CRUET.m_5456_())) {
                    event.setDuration(event.getDuration() + 5);
                }
            }
        }
    }

    @SubscribeEvent
    public void onFoodFinish(@NotNull LivingEntityUseItemEvent.Finish event) {
        FoodProperties foodProperties;
        int floor;
        Player player;
        LivingEntity entity = event.getEntity();
        if (event.getItem().m_204117_(EnigmaticDelightTags.CELESTIAL_FRUIT_FOOD) && entity instanceof Player) {
            player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                if (entity.m_21023_((MobEffect)EnigmaticDelightEffects.ASTRAL_DRUNKENNESS_EFFECT)) {
                    MobEffectInstance effect = entity.m_21124_((MobEffect)EnigmaticDelightEffects.ASTRAL_DRUNKENNESS_EFFECT);
                    int amplifier = effect.m_19564_();
                    int duration = effect.m_19557_();
                    if (amplifier >= 3) {
                        entity.m_7292_(new MobEffectInstance((MobEffect)EnigmaticDelightEffects.ASTRAL_DRUNKENNESS_EFFECT, 3600, 4));
                    } else {
                        entity.m_7292_(new MobEffectInstance((MobEffect)EnigmaticDelightEffects.ASTRAL_DRUNKENNESS_EFFECT, 3600 + duration, amplifier + 1));
                    }
                } else {
                    entity.m_7292_(new MobEffectInstance((MobEffect)EnigmaticDelightEffects.ASTRAL_DRUNKENNESS_EFFECT, 7200));
                }
            }
        }
        if (event.getItem().m_41614_() && entity instanceof Player && SuperpositionHandler.hasItem((Player)(player = (Player)entity), (Item)EnigmaticDelightBlocks.ASTRAL_CRUET.m_5456_()) && !player.m_150110_().f_35937_ && (floor = Mth.m_14143_((float)((float)(foodProperties = event.getItem().getFoodProperties((LivingEntity)player)).m_38744_() * AstralCruet.extraNutritionModifier.getValue().asModifier()))) != 0) {
            player.m_36324_().m_38707_(floor, foodProperties.m_38745_());
        }
    }

    @SubscribeEvent
    public void onTick(@NotNull LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        int slicing = entity.getPersistentData().m_128451_("Slicing");
        if (slicing > 0) {
            entity.m_21204_().m_22178_(SlicingEnchantment.getModifier(slicing));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(@NotNull TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        if (event.phase == TickEvent.Phase.START && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SuperAddonHandler.getCapability((Player)serverPlayer, AbyssDataCapability.ABYSS_DATA).ifPresent(cap -> {
                cap.tick((Player)serverPlayer);
                if (cap.getTick() == 1) {
                    AbyssalStew.giveHeart(player);
                }
            });
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.DESOLATION_RING) && SuperAddonHandler.isAbyssBoost((Player)player)) {
                DESOLATION_BOOST_BOXES.put(player, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)player, (double)12.0));
            } else {
                DESOLATION_BOOST_BOXES.remove(player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)livingEntity)) && SuperAddonHandler.isAbyssBoost((Player)player)) {
            boolean infinitum = false;
            if (player.m_21205_() != null && player.m_21205_().m_41720_() == EnigmaticItems.THE_INFINITUM) {
                infinitum = true;
            } else if (player.m_21206_() != null && player.m_21206_().m_41720_() == EnigmaticItems.THE_INFINITUM) {
                infinitum = true;
            }
            if (infinitum && Math.random() <= AbyssalStew.theInfinitumDisAttackProbability.getValue().asMultiplier(false)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onHitEntity(@NotNull LivingHurtEvent event) {
        Player player;
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_21051_(Attributes.f_22283_).m_22135_() > 1.75) {
            if (ATTACK_LIST.stream().anyMatch(arg_0 -> ((DamageSource)source).m_276093_(arg_0)) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticDelightItems.WEAPON_CHARM)) {
                event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19613_, 50, 1));
            }
        }
        if (entity instanceof Player && EnchantmentHelper.m_44836_((Enchantment)EnigmaticDelightEnchantments.SLICING, (LivingEntity)(player = (Player)entity)) > 0 && entity.getPersistentData().m_128451_("Slicing") > 0) {
            entity.getPersistentData().m_128473_("Slicing");
        }
    }

    @SubscribeEvent
    public void onCropBreak(@NotNull BlockEvent.BreakEvent event) {
        IPlantable plant;
        Block block;
        LevelAccessor level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Player player = event.getPlayer();
        if (!player.m_7500_() && player.m_217043_().m_188503_(4) == 0 && (block = state.m_60734_()) instanceof IPlantable && (plant = (IPlantable)block).getPlantType((BlockGetter)level, pos) == PlantType.CROP) {
            CropBlock crop;
            if (state.m_204336_(ModTags.UNAFFECTED_BY_RICH_SOIL) || plant instanceof CropBlock && (crop = (CropBlock)plant).m_52305_(state) != crop.m_7419_()) {
                return;
            }
            BlockState belowState = level.m_8055_(pos.m_7495_());
            if (belowState.m_60713_((Block)EnigmaticDelightBlocks.INFINISOIL) || belowState.m_60713_((Block)EnigmaticDelightBlocks.INFINISOIL_FARMLAND)) {
                Block.m_49881_((BlockState)state, (Level)((Level)level), (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)player, (ItemStack)player.m_21205_().m_41777_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLootTablesLoaded(LootTableLoadEvent event) {
        if (!OmniconfigHandler.customDungeonLootEnabled.getValue()) {
            return;
        }
        if (SuperpositionHandler.getOverworldDungeons().contains(event.getName())) {
            LootPool enigmatic_seed = SuperpositionHandler.constructLootPool((String)"enigmatic_seed", (float)-6.0f, (float)1.0f, (LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticDelightItems.ENIGMATIC_SEED, (int)100)});
            LootTable modified = event.getTable();
            modified.addPool(enigmatic_seed);
            event.setTable(modified);
        }
    }

    @SubscribeEvent
    public void registryCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IAbyssData.class);
    }

    @SubscribeEvent
    public void registryCommands(RegisterCommandsEvent event) {
        FoodEffectRefreshCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void attachEntitiesCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(AbyssDataCapability.ID_ABYSS_DATA, AbyssDataCapability.createProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        Player original = event.getOriginal();
        original.reviveCaps();
        LazyOptional oldHandler = SuperAddonHandler.getCapability((Player)original, AbyssDataCapability.ABYSS_DATA);
        LazyOptional newHandler = SuperAddonHandler.getCapability((Player)player, AbyssDataCapability.ABYSS_DATA);
        oldHandler.ifPresent(oldData -> newHandler.ifPresent(newData -> newData.readTag(oldData.writeTag())));
        original.invalidateCaps();
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        Player player = event.getPlayer();
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.m_41619_() && !right.m_41619_() && player != null) {
            ItemStack output;
            if (left.m_150930_((Item)EnigmaticDelightItems.CURSE_BLADE) && right.m_150930_((Item)EnigmaticDelightItems.CURSED_SOUL_FRAGMENT)) {
                output = EnigmaticDelightItems.CURSE_CRYSTAL_KNIFE.m_7968_();
                event.setOutput(output);
                event.setCost(Math.max(20, ExperienceHelper.getPlayerXPLevel((Player)player)));
                event.setMaterialCost(1);
            }
            if (left.m_150930_((Item)EnigmaticItems.UNWITNESSED_AMULET) && right.m_150930_((Item)EnigmaticDelightItems.CURSED_SOUL_FRAGMENT)) {
                output = EnigmaticDelightItems.CURSE_CRYSTAL_PENDANT.m_7968_();
                event.setOutput(output);
                event.setCost(Math.max(20, ExperienceHelper.getPlayerXPLevel((Player)player)));
                event.setMaterialCost(1);
            }
        }
    }
}

