/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.objects.abyss;

import auviotre.enigmatic.delicacy.EnigmaticDelicacy;
import auviotre.enigmatic.delicacy.contents.objects.abyss.IAbyssData;
import auviotre.enigmatic.delicacy.packets.server.PacketAbyssSync;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class AbyssDataCapability {
    public static final Capability<IAbyssData> ABYSS_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<IAbyssData>(){});
    public static final ResourceLocation ID_ABYSS_DATA = new ResourceLocation("enigmaticdelicacy", "abyss_data");

    public static ICapabilityProvider createProvider() {
        return new Provider();
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        final LazyOptional<IAbyssData> optional;
        final IAbyssData handler = new Wrapper();

        Provider() {
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return ABYSS_DATA.orEmpty(capability, this.optional);
        }

        public CompoundTag serializeNBT() {
            return this.handler.writeTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.handler.readTag(nbt);
        }
    }

    public static class Wrapper
    implements IAbyssData {
        int abyssTick = 0;
        boolean init = true;

        @Override
        public int getTick() {
            return this.abyssTick;
        }

        @Override
        public void setTick(int tick) {
            this.abyssTick = tick;
        }

        @Override
        public void reset() {
            this.abyssTick = 0;
        }

        @Override
        public void tick(Player player) {
            this.tick(player, 1);
        }

        @Override
        public void tick(Player player, int count) {
            if (this.init) {
                this.init = false;
            } else if (player.m_6084_()) {
                this.abyssTick = Math.max(0, this.abyssTick - count);
            }
            this.update((ServerPlayer)player);
        }

        private void update(ServerPlayer player) {
            EnigmaticDelicacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketAbyssSync(this.abyssTick));
        }

        @Override
        public CompoundTag writeTag() {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("AbyssTick", this.abyssTick);
            return compound;
        }

        @Override
        public void readTag(CompoundTag nbt) {
            this.abyssTick = nbt.m_128451_("AbyssTick");
        }
    }
}

