/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.items;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GlisteningHeart
extends ItemBase {
    public static Omniconfig.PerhapsParameter damageResistance;
    public static Omniconfig.PerhapsParameter resistanceThreshold;
    public static Omniconfig.IntParameter cooldown;

    public GlisteningHeart() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.RARE).m_41503_(100));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("GlisteningHeartofProtection");
        cooldown = builder.comment("The protection skill cooldown of Glistening Heart of Protection.").getInt("Cooldown", 240);
        damageResistance = builder.comment("The damage resistance when equipped Glistening Heart of Protection.").max(90.0).getPerhaps("DamageResistance", 75);
        resistanceThreshold = builder.comment("The resistance threshold to fully resist when equipped Glistening Heart of Protection.").max(90.0).getPerhaps("ResistanceThreshold", 60);
        builder.popPrefix();
    }

    public static boolean Enable(Player player) {
        if (SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticDelightItems.GLISTENING_HEART)) {
            ItemStack stack = SuperAddonHandler.getItem((Player)player, (Item)EnigmaticDelightItems.GLISTENING_HEART);
            return stack.m_41773_() < stack.m_41776_() && !player.m_36335_().m_41519_((Item)EnigmaticDelightItems.GLISTENING_HEART);
        }
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_36335_().m_41519_((Item)this)) {
                stack.m_41721_(0);
            }
            if (stack.m_41773_() == stack.m_41776_()) {
                player.m_36335_().m_41524_((Item)this, cooldown.getValue());
            }
        }
    }

    public CreativeModeTab getCreativeTab() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.glisteningHeart1", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"80%"});
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.glisteningHeart2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"60%"});
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.glisteningHeart3");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.glisteningHeart4", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{GlisteningHeart.minimizeNumber((double)((double)cooldown.getValue() / 20.0))});
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDamage(LivingDamageEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && GlisteningHeart.Enable(player = (Player)livingEntity)) {
            int resist = Mth.m_14143_((float)(event.getAmount() * damageResistance.getValue().asModifier()));
            ItemStack stack = SuperAddonHandler.getItem((Player)player, (Item)EnigmaticDelightItems.GLISTENING_HEART);
            if (resist > 0) {
                event.setAmount(event.getAmount() - (float)resist);
                stack.m_41622_(resist, (LivingEntity)player, consumer -> {});
            }
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && GlisteningHeart.Enable(player = (Player)livingEntity) && event.getAmount() > event.getEntity().m_21223_() * resistanceThreshold.getValue().asModifier()) {
            Entity entity = event.getSource().m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                attacker.m_147240_(0.6, attacker.m_20185_() - player.m_20185_(), attacker.m_20189_() - player.m_20189_());
            }
            event.setCanceled(true);
            player.m_36335_().m_41524_((Item)this, cooldown.getValue());
        }
    }
}

