/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.entities;

import auviotre.enigmatic.delicacy.contents.blocks.EtheriumStove;
import auviotre.enigmatic.delicacy.contents.guis.EtheriumStoveMenu;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightMenus;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightTiles;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class EtheriumStoveBlockEntity
extends SyncedBlockEntity
implements WorldlyContainer,
MenuProvider,
StackedContentsCompatible {
    private static final VoxelShape GRILLING_AREA = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final int INVENTORY_SLOT_COUNT = 6;
    protected final ContainerData dataAccess;
    private final ItemStackHandler inventory = new ItemStackHandler(6){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private final int[] cookingTimes = new int[6];
    private final int[] cookingTimesTotal = new int[6];
    private final ResourceLocation[] lastRecipeIDs = new ResourceLocation[6];
    private final ItemStackHandler furnaceStack = new ItemStackHandler(2);
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44108_);
    int furnaceTime = 0;
    int furnaceTimeTotal = 0;

    public EtheriumStoveBlockEntity(BlockPos pos, BlockState state) {
        super(EnigmaticDelightTiles.ETHERIUM_STOVE, pos, state);
        this.dataAccess = new ContainerData(){

            public int m_6413_(int id) {
                return switch (id) {
                    case 0 -> EtheriumStoveBlockEntity.this.furnaceTime;
                    case 1 -> EtheriumStoveBlockEntity.this.furnaceTimeTotal;
                    default -> 0;
                };
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    case 0: {
                        EtheriumStoveBlockEntity.this.furnaceTime = value;
                        break;
                    }
                    case 1: {
                        EtheriumStoveBlockEntity.this.furnaceTimeTotal = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, EtheriumStoveBlockEntity stove) {
        boolean isStoveLit = (Boolean)state.m_61143_((Property)EtheriumStove.LIT);
        if (stove.isStoveBlockedAbove()) {
            if (!ItemUtils.isInventoryEmpty((IItemHandler)stove.inventory)) {
                ItemUtils.dropItems((Level)level, (BlockPos)pos, (IItemHandler)stove.inventory);
                stove.inventoryChanged();
            }
        } else if (isStoveLit) {
            stove.cookAndOutputItems();
        } else {
            for (int i = 0; i < stove.inventory.getSlots(); ++i) {
                if (stove.cookingTimes[i] <= 0) continue;
                stove.cookingTimes[i] = Mth.m_14045_((int)(stove.cookingTimes[i] - 3), (int)0, (int)stove.cookingTimesTotal[i]);
            }
        }
        if (isStoveLit) {
            BlockPos abovePos = stove.f_58858_.m_7494_();
            BlockState aboveState = stove.f_58857_.m_8055_(abovePos);
            BlockEntity blockEntity = stove.f_58857_.m_7702_(abovePos);
            if (blockEntity instanceof CookingPotBlockEntity) {
                CookingPotBlockEntity cookingPot = (CookingPotBlockEntity)blockEntity;
                CookingPotBlockEntity.cookingTick((Level)level, (BlockPos)abovePos, (BlockState)aboveState, (CookingPotBlockEntity)cookingPot);
            }
            ItemStack itemstack = stove.furnaceStack.getStackInSlot(1);
            AbstractCookingRecipe recipe = !stove.furnaceStack.getStackInSlot(0).m_41619_() ? (AbstractCookingRecipe)stove.quickCheck.m_213657_((Container)stove, level).orElse(null) : null;
            int size = stove.m_6893_();
            if (stove.canBurn(level.m_9598_(), recipe, stove.furnaceStack, size)) {
                stove.furnaceTime += 4;
                if (stove.furnaceTime >= stove.furnaceTimeTotal) {
                    stove.furnaceTime = 0;
                    stove.furnaceTimeTotal = EtheriumStoveBlockEntity.getTotalCookTime(level, stove);
                    if (stove.burn(level.m_9598_(), recipe, stove.furnaceStack, size)) {
                        stove.inventoryChanged();
                    }
                }
            } else {
                stove.furnaceTime = 0;
            }
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, EtheriumStoveBlockEntity stove) {
        for (int i = 0; i < stove.inventory.getSlots(); ++i) {
            if (stove.inventory.getStackInSlot(i).m_41619_() || !(level.f_46441_.m_188501_() < 0.2f)) continue;
            Vec2 stoveItemVector = stove.getStoveItemOffset(i);
            Direction direction = (Direction)state.m_61143_((Property)EtheriumStove.FACING);
            int directionIndex = direction.m_122416_();
            Vec2 offset = directionIndex % 2 == 0 ? stoveItemVector : new Vec2(stoveItemVector.f_82471_, stoveItemVector.f_82470_);
            double x = (double)pos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * offset.f_82470_) + (double)((float)direction.m_122427_().m_122429_() * offset.f_82470_);
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * offset.f_82471_) + (double)((float)direction.m_122427_().m_122431_() * offset.f_82471_);
            for (int k = 0; k < 3; ++k) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    private static int getTotalCookTime(Level level, EtheriumStoveBlockEntity blockEntity) {
        return blockEntity.quickCheck.m_213657_((Container)blockEntity, level).map(AbstractCookingRecipe::m_43753_).orElse(200);
    }

    public void m_142466_(CompoundTag tag) {
        int[] arrayCookingTimesTotal;
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        } else {
            this.inventory.deserializeNBT(tag);
        }
        if (tag.m_128425_("CookingTimes", 11)) {
            arrayCookingTimesTotal = tag.m_128465_("CookingTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTimes, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimesTotal.length));
        }
        if (tag.m_128425_("CookingTotalTimes", 11)) {
            arrayCookingTimesTotal = tag.m_128465_("CookingTotalTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTimesTotal, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimesTotal.length));
        }
        if (tag.m_128441_("FurnaceStack")) {
            this.furnaceStack.deserializeNBT(tag.m_128469_("FurnaceStack"));
        } else {
            this.furnaceStack.deserializeNBT(tag);
        }
        this.furnaceTime = tag.m_128451_("FurnaceTime");
        this.furnaceTimeTotal = tag.m_128451_("FurnaceTimeTotal");
    }

    public void m_183515_(CompoundTag compound) {
        this.writeItems(compound);
        compound.m_128385_("CookingTimes", this.cookingTimes);
        compound.m_128385_("CookingTotalTimes", this.cookingTimesTotal);
        compound.m_128405_("FurnaceTime", this.furnaceTime);
        compound.m_128405_("FurnaceTimeTotal", this.furnaceTimeTotal);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("FurnaceStack", (Tag)this.furnaceStack.serializeNBT());
        return compound;
    }

    private boolean canBurn(RegistryAccess access, AbstractCookingRecipe recipe, ItemStackHandler stacks, int size) {
        if (!stacks.getStackInSlot(0).m_41619_() && recipe != null) {
            ItemStack itemstack = recipe.m_5874_((Container)this, access);
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack result = stacks.getStackInSlot(1);
            if (result.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)result, (ItemStack)itemstack)) {
                return false;
            }
            if (result.m_41613_() + itemstack.m_41613_() <= size && result.m_41613_() + itemstack.m_41613_() <= result.m_41741_()) {
                return true;
            }
            return result.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    private boolean burn(RegistryAccess access, @Nullable AbstractCookingRecipe recipe, ItemStackHandler stacks, int size) {
        if (recipe != null && this.canBurn(access, recipe, stacks, size)) {
            ItemStack ingredient = stacks.getStackInSlot(0);
            ItemStack output = recipe.m_5874_((Container)this, access);
            ItemStack result = stacks.getStackInSlot(1);
            if (result.m_41619_()) {
                stacks.setStackInSlot(1, output.m_41777_());
            } else if (result.m_150930_(output.m_41720_())) {
                result.m_41769_(output.m_41613_());
            }
            ingredient.m_41774_(1);
            return true;
        }
        return false;
    }

    private void cookAndOutputItems() {
        if (this.f_58857_ != null) {
            boolean didInventoryChange = false;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack resultStack;
                ItemStack stoveStack = this.inventory.getStackInSlot(i);
                if (stoveStack.m_41619_()) continue;
                int n = i;
                int n2 = this.cookingTimes[n] + 2;
                this.cookingTimes[n] = n2;
                int time = n2;
                if (this.cookingTimes[i] < this.cookingTimesTotal[i]) continue;
                SimpleContainer inventoryWrapper = new SimpleContainer(new ItemStack[]{stoveStack});
                Optional<CampfireCookingRecipe> recipe = this.getMatchingRecipe((Container)inventoryWrapper, i);
                if (recipe.isPresent() && !(resultStack = recipe.get().m_8043_(this.f_58857_.m_9598_())).m_41619_()) {
                    ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)resultStack.m_41777_(), (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (double)(this.f_58857_.f_46441_.m_188583_() * (double)0.01f), (double)0.1f, (double)(this.f_58857_.f_46441_.m_188583_() * (double)0.01f));
                }
                this.inventory.setStackInSlot(i, ItemStack.f_41583_);
                didInventoryChange = true;
            }
            if (didInventoryChange) {
                this.inventoryChanged();
            }
        }
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public boolean addItem(ItemStack itemStackIn, CampfireCookingRecipe recipe, int slot) {
        ItemStack slotStack;
        if (0 <= slot && slot < this.inventory.getSlots() && (slotStack = this.inventory.getStackInSlot(slot)).m_41619_()) {
            this.cookingTimesTotal[slot] = recipe.m_43753_();
            this.cookingTimes[slot] = 0;
            this.inventory.setStackInSlot(slot, itemStackIn.m_41620_(1));
            this.lastRecipeIDs[slot] = recipe.m_6423_();
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public Optional<CampfireCookingRecipe> getMatchingRecipe(Container recipeWrapper, int slot) {
        Recipe recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeIDs[slot] != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap(RecipeType.f_44111_).get(this.lastRecipeIDs[slot])) instanceof CampfireCookingRecipe && recipe.m_5818_(recipeWrapper, this.f_58857_)) {
            return Optional.of((CampfireCookingRecipe)recipe);
        }
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, recipeWrapper, this.f_58857_);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStackHandler getFurnaceStack() {
        return this.furnaceStack;
    }

    public boolean isStoveBlockedAbove() {
        if (this.f_58857_ != null) {
            BlockState above = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
            return Shapes.m_83157_((VoxelShape)GRILLING_AREA, (VoxelShape)above.m_60808_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()), (BooleanOp)BooleanOp.f_82689_);
        }
        return false;
    }

    public Vec2 getStoveItemOffset(int index) {
        float X_OFFSET = 0.3f;
        float Y_OFFSET = 0.2f;
        Vec2[] OFFSETS = new Vec2[]{new Vec2(0.3f, 0.2f), new Vec2(0.0f, 0.2f), new Vec2(-0.3f, 0.2f), new Vec2(0.3f, -0.2f), new Vec2(0.0f, -0.2f), new Vec2(-0.3f, -0.2f)};
        return OFFSETS[index];
    }

    private void addParticles() {
        if (this.f_58857_ != null) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).m_41619_() || !(this.f_58857_.f_46441_.m_188501_() < 0.2f)) continue;
                Vec2 stoveItemVector = this.getStoveItemOffset(i);
                Direction direction = (Direction)this.m_58900_().m_61143_((Property)EtheriumStove.FACING);
                int directionIndex = direction.m_122416_();
                Vec2 offset = directionIndex % 2 == 0 ? stoveItemVector : new Vec2(stoveItemVector.f_82471_, stoveItemVector.f_82470_);
                double x = (double)this.f_58858_.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * offset.f_82470_) + (double)((float)direction.m_122427_().m_122429_() * offset.f_82470_);
                double y = (double)this.f_58858_.m_123342_() + 1.0;
                double z = (double)this.f_58858_.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * offset.f_82471_) + (double)((float)direction.m_122427_().m_122431_() * offset.f_82471_);
                for (int k = 0; k < 3; ++k) {
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    public int m_6643_() {
        return this.furnaceStack.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.furnaceStack.getSlots(); ++i) {
            if (this.furnaceStack.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_8020_(int id) {
        return this.furnaceStack.getStackInSlot(id);
    }

    public ItemStack m_7407_(int id, int cnt) {
        ItemStack stack = this.furnaceStack.getStackInSlot(id);
        return id >= 0 && id < this.m_6643_() && !stack.m_41619_() && cnt > 0 ? stack.m_41620_(cnt) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int id) {
        if (id >= 0 && id < this.m_6643_()) {
            this.furnaceStack.setStackInSlot(id, ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int id, ItemStack itemStack) {
        ItemStack itemstack = this.furnaceStack.getStackInSlot(id);
        boolean flag = !itemStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)itemStack);
        this.furnaceStack.setStackInSlot(id, itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        if (id == 0 && !flag) {
            this.furnaceTimeTotal = EtheriumStoveBlockEntity.getTotalCookTime(this.f_58857_, this);
            this.furnaceTime = 0;
            this.inventoryChanged();
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        for (int i = 0; i < this.furnaceStack.getSlots(); ++i) {
            this.furnaceStack.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.enigmaticdelicacy.etherium_stove");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new EtheriumStoveMenu(EnigmaticDelightMenus.ETHERIUM_STOVE_MENU, i, inventory, (Container)this, this.dataAccess);
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(i, itemStack);
    }

    public boolean m_7013_(int id, ItemStack itemStack) {
        return id == 0;
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return true;
    }

    public void m_5809_(StackedContents stackedContents) {
        for (int i = 0; i < this.furnaceStack.getSlots(); ++i) {
            stackedContents.m_36491_(this.furnaceStack.getStackInSlot(i));
        }
    }
}

