/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.crafting;

import auviotre.enigmatic.delicacy.contents.items.EnchantmentDuplicator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnchantmentDuplicatorRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<EnchantmentDuplicatorRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(EnchantmentDuplicatorRecipe::new);

    public EnchantmentDuplicatorRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack duplicator = null;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack checkedStack = craftingContainer.m_8020_(i);
            if (checkedStack.m_41619_()) continue;
            if (checkedStack.m_41720_() instanceof EnchantmentDuplicator) {
                if (duplicator != null) {
                    return ItemStack.f_41583_;
                }
                duplicator = checkedStack.m_41777_();
                continue;
            }
            stackList.add(checkedStack);
        }
        if (duplicator != null && stackList.size() == 1 && this.canCopy(duplicator, (ItemStack)stackList.get(0))) {
            return this.copy((ItemStack)stackList.get(0));
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        ItemStack returned;
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        HashMap<ItemStack, Integer> stackList = new HashMap<ItemStack, Integer>();
        ItemStack duplicator = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkedItemStack = inv.m_8020_(i);
            if (checkedItemStack.m_41619_()) continue;
            if (checkedItemStack.m_41720_() instanceof EnchantmentDuplicator) {
                if (duplicator != null) {
                    return remaining;
                }
                duplicator = checkedItemStack.m_41777_();
                continue;
            }
            stackList.put(checkedItemStack, i);
        }
        if (duplicator != null && stackList.size() == 1 && this.canCopy(duplicator, returned = (ItemStack)stackList.keySet().iterator().next())) {
            remaining.set(((Integer)stackList.get(returned)).intValue(), (Object)returned.m_41777_());
        }
        return remaining;
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack duplicator = null;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack checkedStack = craftingContainer.m_8020_(i);
            if (checkedStack.m_41619_()) continue;
            if (checkedStack.m_41720_() instanceof EnchantmentDuplicator) {
                if (duplicator != null) {
                    return false;
                }
                duplicator = checkedStack.m_41777_();
                continue;
            }
            stackList.add(checkedStack);
        }
        return duplicator != null && stackList.size() == 1 && ((ItemStack)stackList.get(0)).m_41793_() && this.canCopy(duplicator, (ItemStack)stackList.get(0));
    }

    private ItemStack copy(ItemStack target) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)target);
        ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)book);
        return book;
    }

    private boolean canCopy(ItemStack duplicator, ItemStack target) {
        Objects.requireNonNull(duplicator.m_41720_());
        return target.m_41793_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

