/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.blocks;

import auviotre.enigmatic.addon.client.particles.StarDustParticle;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.delicacy.contents.blocks.AstralLeaves;
import auviotre.enigmatic.delicacy.contents.blocks.AstralWoodProperties;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class AstralFruit
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    public static final int MAX_AGE = 7;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)7.0, (double)14.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)14.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)14.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)14.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)6.0, (double)10.5, (double)6.0, (double)10.0, (double)14.5, (double)10.0), Block.m_49796_((double)6.0, (double)10.5, (double)6.0, (double)10.0, (double)14.5, (double)10.0), Block.m_49796_((double)6.0, (double)10.5, (double)6.0, (double)10.0, (double)14.5, (double)10.0), Block.m_49796_((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0)};

    public AstralFruit() {
        super(AstralWoodProperties.FRUIT);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return EnigmaticItems.ASTRAL_FRUIT.m_7968_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (SuperAddonHandler.isOKOne((Player)player) && 7 == (Integer)state.m_61143_((Property)AGE)) {
            level.m_245747_(pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 0.8f, player.m_217043_().m_188501_() + 0.5f, false);
            level.m_46961_(pos, true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        level.m_245747_(pos, SoundEvents.f_11988_, SoundSource.BLOCKS, 0.2f, player.m_217043_().m_188501_() + 0.5f, true);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE);
    }

    public BlockState getStateForAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(age));
    }

    public final boolean isMaxAge(BlockState state) {
        return this.getAge(state) >= 7;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState fromState, LevelAccessor level, BlockPos pos, BlockPos from) {
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, fromState, level, pos, from);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isAreaLoaded(pos, 1) && level.m_45524_(pos, 0) >= 9 && this.getAge(state) < 7 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(12) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return super.m_7898_(state, level, pos) && level.m_8055_(pos.m_7494_()).m_60734_() instanceof AstralLeaves;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) == 0 && this.getAge(state) >= 7) {
            double x = (float)pos.m_123341_() + 0.25f + 0.5f * random.m_188501_();
            double y = (float)pos.m_123342_() + 0.4f + 0.4f * random.m_188501_();
            double z = (float)pos.m_123343_() + 0.25f + 0.5f * random.m_188501_();
            world.m_7106_(StarDustParticle.get((RandomSource)random), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

