/*
 * Decompiled with CFR 0.152.
 */
package com.mcmostwolf.enchantmentlib.mixin;

import com.mcmostwolf.enchantmentlib.config.EnchantmentsConfig;
import com.mcmostwolf.enchantmentlib.util.EnchantmentHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public abstract class EnchantmentReload {
    @Inject(method={"getMaxLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectGetMaxLevel(CallbackInfoReturnable<Integer> cir) {
        Enchantment enchantment = (Enchantment)this;
        String location = EnchantmentHelper.getLocation(enchantment);
        if (EnchantmentsConfig.isLoad(enchantment) >= 2) {
            cir.setReturnValue((Object)EnchantmentsConfig.getMaxLevel(location));
        }
    }

    @Inject(method={"isTreasureOnly"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectIsTreasureOnly(CallbackInfoReturnable<Boolean> cir) {
        Enchantment enchantment = (Enchantment)this;
        String location = EnchantmentHelper.getLocation(enchantment);
        if (EnchantmentsConfig.isLoad(enchantment) >= 2) {
            cir.setReturnValue((Object)EnchantmentsConfig.isTreasure(location));
        }
    }

    @Inject(method={"isTradeable"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectIsTradeable(CallbackInfoReturnable<Boolean> cir) {
        Enchantment enchantment = (Enchantment)this;
        String location = EnchantmentHelper.getLocation(enchantment);
        if (EnchantmentsConfig.isLoad(enchantment) >= 2) {
            cir.setReturnValue((Object)EnchantmentsConfig.couldTrade(location));
        }
    }

    @Inject(method={"isCurse"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectIsCurse(CallbackInfoReturnable<Boolean> cir) {
        Enchantment enchantment = (Enchantment)this;
        String location = EnchantmentHelper.getLocation(enchantment);
        if (EnchantmentsConfig.isLoad(enchantment) >= 2) {
            cir.setReturnValue((Object)EnchantmentsConfig.isCurse(location));
        }
    }

    @Inject(method={"isDiscoverable"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectIsDiscoverable(CallbackInfoReturnable<Boolean> cir) {
        Enchantment enchantment = (Enchantment)this;
        String location = EnchantmentHelper.getLocation(enchantment);
        if (EnchantmentsConfig.isLoad(enchantment) >= 2) {
            cir.setReturnValue((Object)EnchantmentsConfig.couldFound(location));
        }
    }

    @Inject(method={"canApplyAtEnchantingTable"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void injectCanApplyAtEnchantingTable(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Enchantment enchantment = (Enchantment)this;
        String location = EnchantmentHelper.getLocation(enchantment);
        if (EnchantmentsConfig.isLoad(enchantment) >= 2) {
            cir.setReturnValue((Object)(EnchantmentsConfig.couldEnchantTable(location) && (Boolean)cir.getReturnValue() != false ? 1 : 0));
        }
    }

    @Inject(method={"canEnchant"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectCanEnchant(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Enchantment enchantment = (Enchantment)this;
        String location = EnchantmentHelper.getLocation(enchantment);
        if (EnchantmentsConfig.isLoad(enchantment) >= 2) {
            cir.setReturnValue((Object)(EnchantmentsConfig.couldAnvil(location) && (Boolean)cir.getReturnValue() != false ? 1 : 0));
        }
    }

    @Inject(method={"getRarity"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectGetRarity(CallbackInfoReturnable<Enchantment.Rarity> cir) {
        Enchantment enchantment = (Enchantment)this;
        String location = EnchantmentHelper.getLocation(enchantment);
        if (EnchantmentsConfig.isLoad(enchantment) >= 2) {
            cir.setReturnValue((Object)EnchantmentsConfig.getRarityByConfig(location));
        }
    }

    @Inject(method={"checkCompatibility"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectCheckCompatibility(Enchantment other, CallbackInfoReturnable<Boolean> cir) {
        Enchantment enchantment = (Enchantment)this;
        String location = EnchantmentHelper.getLocation(enchantment);
        if (EnchantmentsConfig.isLoad(enchantment) >= 2) {
            boolean result = true;
            for (String otherLocation : EnchantmentsConfig.getUnableCompatibility(location)) {
                if (other != ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(otherLocation))) continue;
                result = false;
                break;
            }
            cir.setReturnValue((Object)result);
        }
    }
}

