/*
 * Decompiled with CFR 0.152.
 */
package com.mcmostwolf.enchantmentlib.jei;

import com.mcmostwolf.enchantmentlib.api.IToggleEnchantment;
import com.mcmostwolf.enchantmentlib.jei.EnchantmentCategory;
import com.mcmostwolf.enchantmentlib.jei.FilterCategory;
import com.mcmostwolf.enchantmentlib.jei.FilterEntry;
import com.mcmostwolf.enchantmentlib.jei.WrappedEnchantment;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIView
implements IModPlugin {
    public static final RecipeType<WrappedEnchantment> REGISTRY = RecipeType.create((String)"wolfenchantmentlib", (String)"ue_enchantments", WrappedEnchantment.class);
    public static final RecipeType<FilterEntry> FILTER = RecipeType.create((String)"wolfenchantmentlib", (String)"ue_enchantment_filters", FilterEntry.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("wolfenchantmentlib", "core");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ObjectArrayList items = new ObjectArrayList();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack stack = new ItemStack((ItemLike)item);
            items.add(stack);
        }
        items.removeIf(ItemStack::m_41619_);
        List enchantments = (List)new ArrayList(ForgeRegistries.ENCHANTMENTS.getValues()).parallelStream().filter(this::isEnabled).map(arg_0 -> JEIView.lambda$registerRecipes$0((List)items, arg_0)).collect(Collectors.toCollection(ObjectArrayList::new));
        enchantments.sort(null);
        registration.addRecipes(REGISTRY, enchantments);
        ObjectArrayList filters = new ObjectArrayList();
        ArrayList<Object> temp = new ArrayList<ItemStack>(List.copyOf(items));
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues().stream().toList()) {
            for (ItemStack itemStack : items) {
                if (enchantment.m_6081_(itemStack)) continue;
                temp.remove(itemStack);
            }
            filters.add(new FilterEntry(enchantment, temp, (Component)Component.m_237115_((String)(enchantment.m_44704_() + ".desc"))));
            temp = new ArrayList(List.copyOf(items));
        }
        registration.addRecipes(FILTER, (List)filters);
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new EnchantmentCategory(registry.getJeiHelpers().getGuiHelper(), REGISTRY)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FilterCategory(registry.getJeiHelpers().getGuiHelper(), FILTER)});
    }

    public boolean isEnabled(Enchantment ench) {
        return !(ench instanceof IToggleEnchantment) || ((IToggleEnchantment)ench).isEnabled();
    }

    private static /* synthetic */ WrappedEnchantment lambda$registerRecipes$0(List items, Enchantment T) {
        return new WrappedEnchantment(T, items);
    }
}

