/*
 * Decompiled with CFR 0.152.
 */
package com.mcmostwolf.enchantmentlib.jei;

import com.mcmostwolf.enchantmentlib.jei.FilterEntry;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class FilterCategory
implements IRecipeCategory<FilterEntry> {
    RecipeType<FilterEntry> id;
    IDrawable drawable;
    IDrawable icon;

    public FilterCategory(IGuiHelper helper, RecipeType<FilterEntry> id) {
        this.id = id;
        this.drawable = helper.createDrawable(new ResourceLocation("wolfenchantmentlib:textures/inventory.png"), 4, 4, 169, 122);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42690_);
        EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44987_, 100));
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
    }

    public IDrawable getBackground() {
        return this.drawable;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<FilterEntry> getRecipeType() {
        return this.id;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"enchantmentlib.jei.filter");
    }

    public void draw(FilterEntry recipe, @NotNull IRecipeSlotsView view, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        List split = font.m_92923_((FormattedText)recipe.getDescription(), 165);
        for (int i = 0; i < Math.min(2, split.size()); ++i) {
            FormattedCharSequence formattedCharSequence = (FormattedCharSequence)split.get(i);
            Objects.requireNonNull(font);
            guiGraphics.m_280648_(font, formattedCharSequence, 4, (int)(25.0f + (float)(i * 9)), 0x404040);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FilterEntry entry, IFocusGroup group) {
        builder.addSlot(RecipeIngredientRole.INPUT, 76, 3).addItemStacks(entry.getDisplay());
        List<ItemStack>[] item = entry.getItems();
        for (int i = 0; i < item.length; ++i) {
            int x = i % 9;
            int y = i / 9;
            builder.addSlot(RecipeIngredientRole.CATALYST, 4 + x * 18, 49 + y * 18).addItemStacks(item[i]);
        }
    }
}

