/*
 * Decompiled with CFR 0.152.
 */
package com.mcmostwolf.enchantmentlib.jei;

import com.mcmostwolf.enchantmentlib.jei.WrappedEnchantment;
import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnchantmentCategory
implements IRecipeCategory<WrappedEnchantment> {
    RecipeType<WrappedEnchantment> id;
    IDrawable drawable;
    IDrawable icon;

    public EnchantmentCategory(IGuiHelper helper, RecipeType<WrappedEnchantment> id) {
        this.id = id;
        this.drawable = helper.createDrawable(new ResourceLocation("wolfenchantmentlib:textures/jei_all_slots_1.png"), 4, 5, 167, 120);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42690_);
        EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44987_, 100));
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
    }

    public RecipeType<WrappedEnchantment> getRecipeType() {
        return this.id;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"enchantmentlib.jei.name");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.drawable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(WrappedEnchantment recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        String s = ChatFormatting.UNDERLINE + I18n.m_118938_((String)recipe.ench.m_44704_(), (Object[])new Object[0]);
        guiGraphics.m_280488_(font, s, 85 - font.m_92895_(s) / 2, 3, 0);
        guiGraphics.m_280430_(font, (Component)Component.m_237115_((String)"enchantmentlib.jei.incompatible").m_130940_(ChatFormatting.RED), 13, 40, 0x404040);
        guiGraphics.m_280430_(font, (Component)Component.m_237115_((String)"enchantmentlib.jei.applicatble"), 101, 40, 0x404040);
    }

    public boolean handleInput(WrappedEnchantment recipe, double mouseX, double mouseY, InputConstants.Key input) {
        Minecraft mc = Minecraft.m_91087_();
        if (recipe.left.m_5953_(mouseX, mouseY) && recipe.pageIndex > 0) {
            recipe.left.m_7435_(mc.m_91106_());
            --recipe.pageIndex;
            return true;
        }
        if (recipe.right.m_5953_(mouseX, mouseY) && recipe.pageIndex < recipe.getIncompats(mc.f_91062_).size() / 10) {
            recipe.right.m_7435_(mc.m_91106_());
            ++recipe.pageIndex;
            return true;
        }
        return false;
    }

    private void addExtraData(ItemStack stack, WrappedEnchantment recipe) {
        stack.m_41700_("HideFlags", (Tag)IntTag.m_128679_((int)ItemStack.TooltipPart.ENCHANTMENTS.m_41809_()));
        ObjectArrayList components = new ObjectArrayList();
        components.add(Component.m_237110_((String)"enchantmentlib.jei.max_level", (Object[])new Object[]{Component.m_237113_((String)Integer.toString(recipe.ench.m_6586_())).m_130940_(ChatFormatting.WHITE)}).m_130948_(this.createColor(0xFFAA00)));
        components.add(Component.m_237115_((String)"enchantmentlib.jei.treasure").m_130948_(this.createColor(12226829)).m_7220_((Component)Component.m_237115_((String)(recipe.ench.m_6591_() ? "enchantmentlib.jei.yes" : "enchantmentlib.jei.no")).m_130940_(ChatFormatting.WHITE)).m_130948_(this.createColor(12226829)));
        components.add(Component.m_237115_((String)"enchantmentlib.jei.curse").m_130948_(this.createColor(10558997)).m_7220_((Component)Component.m_237115_((String)(recipe.ench.m_6589_() ? "enchantmentlib.jei.yes" : "enchantmentlib.jei.no")).m_130940_(ChatFormatting.WHITE)).m_130948_(this.createColor(10558997)));
        components.add(Component.m_237115_((String)"enchantmentlib.jei.tradeable").m_130948_(this.createColor(13206548)).m_7220_((Component)Component.m_237115_((String)(recipe.ench.m_6594_() ? "enchantmentlib.jei.yes" : "enchantmentlib.jei.no")).m_130940_(ChatFormatting.WHITE)).m_130948_(this.createColor(13206548)));
        components.add(Component.m_237115_((String)"enchantmentlib.jei.discover").m_130948_(this.createColor(12226829)).m_7220_((Component)Component.m_237115_((String)(recipe.ench.m_6592_() ? "enchantmentlib.jei.yes" : "enchantmentlib.jei.no")).m_130940_(ChatFormatting.WHITE)).m_130948_(this.createColor(12226829)));
        components.add(Component.m_237115_((String)"enchantmentlib.jei.books").m_130948_(this.createColor(12226829)).m_7220_((Component)Component.m_237115_((String)(recipe.ench.isAllowedOnBooks() ? "enchantmentlib.jei.yes" : "enchantmentlib.jei.no")).m_130940_(ChatFormatting.WHITE)).m_130948_(this.createColor(12226829)));
        components.add(Component.m_237110_((String)"enchantmentlib.jei.rarity", (Object[])new Object[]{Component.m_237115_((String)("enchantmentlib.jei." + recipe.ench.m_44699_().name().toLowerCase())).m_130940_(recipe.getFormatting(recipe.ench.m_44699_()))}).m_130948_(this.createColor(13310417)));
        CompoundTag nbt = stack.m_41698_("display");
        ListTag list = nbt.m_128437_("Lore", 8);
        for (Component entry : components) {
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)entry)));
        }
        nbt.m_128365_("Lore", (Tag)list);
    }

    private Style createColor(int color) {
        return Style.f_131099_.m_178520_(color).m_131155_(Boolean.valueOf(false));
    }

    public void setRecipe(IRecipeLayoutBuilder layout, WrappedEnchantment recipe, IFocusGroup focus) {
        int i;
        ObjectArrayList list = new ObjectArrayList();
        for (i = 0; i < 25; ++i) {
            list.add(new ObjectArrayList());
        }
        int m = recipe.validItems.size();
        for (i = 0; i < m; ++i) {
            ((List)list.get(1 + i % 12)).add(recipe.validItems.get(i));
        }
        m = recipe.incompats.size();
        for (i = 0; i < m; ++i) {
            ((List)list.get(13 + i % 12)).add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(recipe.incompats.get(i), 1)));
        }
        m = recipe.ench.m_6586_();
        for (i = recipe.ench.m_44702_(); i <= m; ++i) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42690_);
            EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(recipe.ench, i));
            this.addExtraData(stack, recipe);
            ((List)list.get(0)).add(stack);
        }
        layout.addSlot(RecipeIngredientRole.INPUT, 76, 17).addItemStacks((List)list.get(0));
        for (i = 0; i < 12; ++i) {
            layout.addSlot(RecipeIngredientRole.INPUT, 102 + i % 3 * 18, 49 + i / 3 * 18).addItemStacks((List)list.get(1 + i));
        }
        for (i = 0; i < 12; ++i) {
            layout.addSlot(RecipeIngredientRole.INPUT, 14 + i % 3 * 18, 49 + i / 3 * 18).addItemStacks((List)list.get(13 + i));
        }
    }
}

