/*
 * Decompiled with CFR 0.152.
 */
package com.mcmostwolf.enchantmentlib.config;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.mcmostwolf.enchantmentlib.config.EnchantmentConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.fml.loading.FMLPaths;

public class EnchantmentsConfig {
    private static final Map<String, Boolean> isTreasureMap = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> couldFoundMap = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> couldEnchantTableMap = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> couldAnvilMap = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> couldTradeMap = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> isCurseMap = new HashMap<String, Boolean>();
    private static final Map<String, Integer> maxLevelMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> qualityMap = new HashMap<String, Integer>();
    private static final Map<String, List<String>> unableCompatibilityMap = new HashMap<String, List<String>>();

    public static void loadConfig(Enchantment enchantment) {
        Gson gson = new Gson();
        String[] parts = enchantment.m_44704_().split("\\.");
        String modId = parts[1];
        String enchantmentName = parts[2];
        Path configDir = FMLPaths.CONFIGDIR.get().resolve(modId).resolve("enchantments");
        Path configPath = configDir.resolve(enchantmentName + ".json");
        try {
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            } else if (!Files.exists(configPath, new LinkOption[0])) {
                EnchantmentsConfig.createDefaultConfig(configPath, enchantment);
            }
            String content = Files.readString(configPath);
            List configs = (List)gson.fromJson(content, new TypeToken<List<EnchantmentConfig>>(){}.getType());
            for (EnchantmentConfig config : configs) {
                String key = config.enchantmentName;
                isTreasureMap.put(key, config.isTreasure);
                couldFoundMap.put(key, config.couldFound);
                couldEnchantTableMap.put(key, config.couldEnchantTable);
                couldAnvilMap.put(key, config.couldAnvil);
                couldTradeMap.put(key, config.couldTrade);
                isCurseMap.put(key, config.isCurse);
                maxLevelMap.put(key, config.maxLevel);
                qualityMap.put(key, config.quality);
                List<Object> compatibility = config.unableCompatibility != null ? config.unableCompatibility : List.of();
                unableCompatibilityMap.put(key, compatibility);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createDefaultConfig(Path configPath, Enchantment enchantment) throws IOException {
        String[] parts = enchantment.m_44704_().split("\\.");
        String modId = parts[1];
        String enchantmentName = parts[2];
        String defaultContent = String.format("[\n    {\n        \"enchantmentName\": \"%s\",\n        \"isTreasure\":%b,\n        \"couldFound\":%b,\n        \"couldEnchantTable\":%b,\n        \"couldAnvil\":%b,\n        \"couldTrade\":%b,\n        \"isCurse\":%b,\n        \"maxLevel\":%d,\n        \"quality\":%d,\n        \"unableCompatibility\":[]\n    }\n]", modId + ":" + enchantmentName, enchantment.m_6591_(), enchantment.m_6592_(), !enchantment.m_6591_(), true, enchantment.m_6594_(), enchantment.m_6589_(), enchantment.m_6586_(), EnchantmentsConfig.getQualityByRandom(enchantment.m_44699_()));
        Files.writeString(configPath, (CharSequence)defaultContent, new OpenOption[0]);
    }

    public static boolean isTreasure(String enchantmentName) {
        return isTreasureMap.getOrDefault(enchantmentName, false);
    }

    public static boolean couldFound(String enchantmentName) {
        return couldFoundMap.getOrDefault(enchantmentName, false);
    }

    public static Integer getMaxLevel(String enchantmentName) {
        return maxLevelMap.getOrDefault(enchantmentName, 1);
    }

    public static boolean couldEnchantTable(String enchantmentName) {
        return couldEnchantTableMap.getOrDefault(enchantmentName, false);
    }

    public static boolean couldAnvil(String enchantmentName) {
        return couldAnvilMap.getOrDefault(enchantmentName, false);
    }

    public static boolean couldTrade(String enchantmentName) {
        return couldTradeMap.getOrDefault(enchantmentName, false);
    }

    public static boolean isCurse(String enchantmentName) {
        return isCurseMap.getOrDefault(enchantmentName, false);
    }

    public static List<String> getUnableCompatibility(String enchantmentName) {
        return unableCompatibilityMap.getOrDefault(enchantmentName, List.of());
    }

    public static Enchantment.Rarity getRarityByConfig(String enchantmentName) {
        return switch (qualityMap.getOrDefault(enchantmentName, 0)) {
            case 1 -> Enchantment.Rarity.UNCOMMON;
            case 2 -> Enchantment.Rarity.RARE;
            case 3 -> Enchantment.Rarity.VERY_RARE;
            default -> Enchantment.Rarity.COMMON;
        };
    }

    private static int getQualityByRandom(Enchantment.Rarity rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case Enchantment.Rarity.COMMON -> 0;
            case Enchantment.Rarity.UNCOMMON -> 1;
            case Enchantment.Rarity.RARE -> 2;
            case Enchantment.Rarity.VERY_RARE -> 3;
        };
    }

    public static int isLoad(Enchantment enchantment) {
        String[] parts = enchantment.m_44704_().split("\\.");
        String modId = parts[1];
        String enchantmentName = parts[2];
        Path configDir = FMLPaths.CONFIGDIR.get().resolve(modId).resolve("enchantments");
        Path configPath = configDir.resolve(enchantmentName + ".json");
        if (!Files.exists(configDir, new LinkOption[0])) {
            return 0;
        }
        if (!Files.exists(configPath, new LinkOption[0])) {
            return 1;
        }
        return 2;
    }
}

