/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementType;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class RequirementMustContainIngredient
implements IRequirement {
    private final Ingredient ingredient;
    private final int quantity;

    public RequirementMustContainIngredient(Ingredient ingredient, int quantity) {
        this.ingredient = ingredient;
        this.quantity = Math.min(quantity, 4);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public boolean test(CrockPotCookingRecipe.Wrapper recipeWrapper) {
        return IntStream.range(0, recipeWrapper.m_6643_()).mapToObj(arg_0 -> ((CrockPotCookingRecipe.Wrapper)recipeWrapper).m_8020_(arg_0)).filter((Predicate<ItemStack>)this.ingredient).count() >= (long)this.quantity;
    }

    public static RequirementMustContainIngredient fromJson(JsonObject object) {
        return new RequirementMustContainIngredient(JsonUtils.getAsIngredient(object, "ingredient", true), GsonHelper.m_13927_((JsonObject)object, (String)"quantity"));
    }

    @Override
    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", RequirementType.MUST_CONTAIN_INGREDIENT.name());
        obj.add("ingredient", this.ingredient.m_43942_());
        obj.addProperty("quantity", (Number)this.quantity);
        return obj;
    }

    public static RequirementMustContainIngredient fromNetwork(FriendlyByteBuf buffer) {
        return new RequirementMustContainIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readByte());
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)RequirementType.MUST_CONTAIN_INGREDIENT);
        this.ingredient.m_43923_(buffer);
        buffer.writeByte(this.quantity);
    }
}

