/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.item.CrockPotItems;
import com.sihenzhang.crockpot.recipe.AbstractRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CrockPotCookingRecipe
extends AbstractRecipe<Wrapper> {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final List<IRequirement> requirements;
    private final ItemStack result;
    private final int priority;
    private final int weight;
    private final int cookingTime;
    private final int potLevel;

    public CrockPotCookingRecipe(ResourceLocation id, List<IRequirement> requirements, ItemStack result, int priority, int weight, int cookingTime, int potLevel) {
        super(id);
        this.requirements = ImmutableList.copyOf(requirements);
        this.result = result;
        this.priority = priority;
        this.weight = Math.max(weight, 1);
        this.cookingTime = cookingTime;
        this.potLevel = potLevel;
    }

    public boolean matches(Wrapper pContainer, Level pLevel) {
        return pContainer.getPotLevel() >= this.potLevel && this.requirements.stream().allMatch(r -> r.test(pContainer));
    }

    public ItemStack assemble(Wrapper pContainer, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public static Optional<CrockPotCookingRecipe> getRecipeFor(Wrapper container, Level level) {
        List recipes = level.m_7465_().m_44056_((RecipeType)CrockPotRecipes.CROCK_POT_COOKING_RECIPE_TYPE.get(), (Container)container, level);
        OptionalInt optionalMaxPriority = recipes.stream().mapToInt(CrockPotCookingRecipe::getPriority).max();
        if (optionalMaxPriority.isPresent()) {
            int maxPriority = optionalMaxPriority.getAsInt();
            SimpleWeightedRandomList.Builder matchedRecipes = SimpleWeightedRandomList.m_146263_();
            recipes.stream().filter(r -> r.getPriority() == maxPriority).forEach(r -> matchedRecipes.m_146271_(r, r.getWeight()));
            return matchedRecipes.m_146270_().m_216820_(RANDOM);
        }
        return Optional.empty();
    }

    public List<IRequirement> getRequirements() {
        return this.requirements;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public int getPotLevel() {
        return this.potLevel;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ItemStack m_8042_() {
        return ((Item)CrockPotItems.CROCK_POT.get()).m_7968_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CrockPotRecipes.CROCK_POT_COOKING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CrockPotRecipes.CROCK_POT_COOKING_RECIPE_TYPE.get();
    }

    public static class Wrapper
    extends SimpleContainer {
        private final FoodValues foodValues;
        private final int potLevel;

        public Wrapper(List<ItemStack> items, FoodValues foodValues, int potLevel) {
            super(items.toArray(new ItemStack[0]));
            this.foodValues = foodValues;
            this.potLevel = potLevel;
        }

        public FoodValues getFoodValues() {
            return this.foodValues;
        }

        public int getPotLevel() {
            return this.potLevel;
        }
    }

    public static class Serializer
    implements RecipeSerializer<CrockPotCookingRecipe> {
        public CrockPotCookingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            List<IRequirement> requirements = Streams.stream((Iterable)GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"requirements")).map(IRequirement::fromJson).toList();
            ItemStack result = JsonUtils.getAsItemStack(serializedRecipe, "result");
            int priority = GsonHelper.m_13927_((JsonObject)serializedRecipe, (String)"priority");
            int weight = GsonHelper.m_13824_((JsonObject)serializedRecipe, (String)"weight", (int)1);
            int cookingTime = GsonHelper.m_13927_((JsonObject)serializedRecipe, (String)"cookingtime");
            int potLevel = GsonHelper.m_13927_((JsonObject)serializedRecipe, (String)"potlevel");
            return new CrockPotCookingRecipe(recipeId, requirements, result, priority, weight, cookingTime, potLevel);
        }

        @Nullable
        public CrockPotCookingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int length = buffer.m_130242_();
            List<IRequirement> requirements = IntStream.range(0, length).mapToObj(i -> IRequirement.fromNetwork(buffer)).toList();
            ItemStack result = buffer.m_130267_();
            int priority = buffer.m_130242_();
            int weight = buffer.m_130242_();
            int cookingTime = buffer.m_130242_();
            byte potLevel = buffer.readByte();
            return new CrockPotCookingRecipe(recipeId, requirements, result, priority, weight, cookingTime, potLevel);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrockPotCookingRecipe recipe) {
            buffer.m_130130_(recipe.getRequirements().size());
            recipe.getRequirements().forEach(requirement -> requirement.toNetwork(buffer));
            buffer.m_130055_(recipe.getResult());
            buffer.m_130130_(recipe.getPriority());
            buffer.m_130130_(recipe.getWeight());
            buffer.m_130130_(recipe.getCookingTime());
            buffer.writeByte(recipe.getPotLevel());
        }
    }
}

