/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.util.JsonUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class RangedItem {
    public final Item item;
    public final int min;
    public final int max;

    public RangedItem(Item item, int min, int max) {
        Preconditions.checkArgument((min >= 0 || max >= 0 ? 1 : 0) != 0, (Object)"The count of RangedItem should not be less than 0");
        if (min == 0 && max == 0) {
            CrockPot.LOGGER.warn("The count of RangedItem is 0, make sure this is intentional!");
        }
        if (min > max) {
            CrockPot.LOGGER.warn("The minimum count of RangedItem is greater than the maximum count, make sure this is intentional!");
        }
        this.item = item;
        this.min = min;
        this.max = max;
    }

    public RangedItem(Item item, int count) {
        this(item, count, count);
    }

    public boolean isRanged() {
        return this.min != this.max;
    }

    public ItemStack getInstance(RandomSource random) {
        if (this.isRanged()) {
            return new ItemStack((ItemLike)this.item, Mth.m_216271_((RandomSource)random, (int)this.min, (int)this.max));
        }
        return new ItemStack((ItemLike)this.item, this.min);
    }

    public static RangedItem fromJson(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        JsonObject obj = GsonHelper.m_13918_((JsonElement)json, (String)"ranged item");
        Item item = JsonUtils.getAsItem(obj, "item");
        if (item != null) {
            if (obj.has("count")) {
                JsonElement e = obj.get("count");
                if (e.isJsonObject()) {
                    JsonObject count = e.getAsJsonObject();
                    if (count.has("min") && count.has("max")) {
                        int min = GsonHelper.m_13927_((JsonObject)count, (String)"min");
                        int max = GsonHelper.m_13927_((JsonObject)count, (String)"max");
                        return new RangedItem(item, min, max);
                    }
                    int minOrMax = GsonHelper.m_13824_((JsonObject)count, (String)"min", (int)GsonHelper.m_13824_((JsonObject)count, (String)"max", (int)1));
                    return new RangedItem(item, minOrMax);
                }
                int count = GsonHelper.m_13824_((JsonObject)obj, (String)"count", (int)1);
                return new RangedItem(item, count);
            }
            return new RangedItem(item, 1);
        }
        return null;
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.item).toString());
        if (this.isRanged()) {
            JsonObject count = new JsonObject();
            count.addProperty("min", (Number)this.min);
            count.addProperty("max", (Number)this.max);
            obj.add("count", (JsonElement)count);
        } else if (this.min > 1) {
            obj.addProperty("count", (Number)this.min);
        }
        return obj;
    }

    public static RangedItem fromNetwork(FriendlyByteBuf buffer) {
        Item item = Item.m_41445_((int)buffer.m_130242_());
        byte min = buffer.readByte();
        byte max = buffer.readByte();
        return new RangedItem(item, min, max);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(Item.m_41393_((Item)this.item));
        buffer.writeByte(this.min);
        buffer.writeByte(this.max);
    }
}

