/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddItemWithLootingEnchantModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemWithLootingEnchantModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemWithLootingEnchantModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)Codec.INT.fieldOf("count").forGetter(m -> m.count), (App)Codec.INT.fieldOf("limit").forGetter(m -> m.limit))).apply((Applicative)inst, AddItemWithLootingEnchantModifier::new)));
    private static final UniformGenerator RANDOM_NUMBER_GENERATOR = UniformGenerator.m_165780_((float)0.0f, (float)1.0f);
    private final Item item;
    private final int count;
    private final int limit;

    public AddItemWithLootingEnchantModifier(LootItemCondition[] conditionsIn, Item item, int count, int limit) {
        super(conditionsIn);
        this.item = item;
        this.count = count;
        this.limit = limit;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack result = new ItemStack((ItemLike)this.item, this.count);
        int lootingModifier = context.getLootingModifier();
        if (lootingModifier > 0) {
            float bonus = (float)lootingModifier * RANDOM_NUMBER_GENERATOR.m_142688_(context);
            result.m_41769_(Math.round(bonus));
            if (this.limit > 0 && result.m_41613_() > this.limit) {
                result.m_41764_(this.limit);
            }
        }
        generatedLoot.add((Object)result);
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

