/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item.food;

import com.sihenzhang.crockpot.capability.FoodCounterCapabilityHandler;
import com.sihenzhang.crockpot.item.food.CrockPotFoodProperties;
import com.sihenzhang.crockpot.util.I18nUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CrockPotFoodBlockItem
extends BlockItem {
    private final CrockPotFoodProperties foodProperties;

    public CrockPotFoodBlockItem(Block pBlock, CrockPotFoodProperties foodProperties) {
        super(pBlock, foodProperties.itemProperties);
        this.foodProperties = foodProperties;
    }

    public InteractionResult m_40576_(BlockPlaceContext pContext) {
        if (!pContext.m_7078_() && !pContext.m_7058_()) {
            return InteractionResult.FAIL;
        }
        return super.m_40576_(pContext);
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        super.m_5922_(pStack, pLevel, pLivingEntity);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            this.foodProperties.addCooldown((Item)this, player);
        }
        this.foodProperties.hurt(pLevel, pLivingEntity);
        this.foodProperties.heal(pLevel, pLivingEntity);
        this.foodProperties.removeEffects(pLevel, pLivingEntity);
        ItemStack containerStack = this.getCraftingRemainingItem(pStack);
        if (pStack.m_41619_()) {
            return containerStack;
        }
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (!player.m_150110_().f_35937_ && !player.m_150109_().m_36054_(containerStack)) {
                player.m_36176_(containerStack, false);
            }
        }
        return pStack;
    }

    public int m_8105_(ItemStack pStack) {
        return this.foodProperties.getUseDuration();
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return this.foodProperties.getUseAnimation();
    }

    public SoundEvent m_6061_() {
        return this.foodProperties.getSound();
    }

    public SoundEvent m_6023_() {
        return this.foodProperties.getSound();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.addAll(this.foodProperties.getTooltips());
        if (pLevel != null && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.getCapability(FoodCounterCapabilityHandler.FOOD_COUNTER_CAPABILITY).ifPresent(foodCounter -> pTooltipComponents.addAll(this.foodProperties.getEffectTooltips(foodCounter.hasEaten((Item)this))));
        }
        pTooltipComponents.add((Component)Component.m_237119_());
        pTooltipComponents.add((Component)I18nUtils.createTooltipComponent("placeable_while_sneaking").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

