/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item;

import com.google.common.base.Suppliers;
import com.sihenzhang.crockpot.base.CrockPotDamageTypes;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.block.CrockPotBlocks;
import com.sihenzhang.crockpot.effect.CrockPotEffects;
import com.sihenzhang.crockpot.entity.CrockPotEntities;
import com.sihenzhang.crockpot.item.CollectedDustItem;
import com.sihenzhang.crockpot.item.CreativeMilkmadeHatItem;
import com.sihenzhang.crockpot.item.CrockPotBaseItem;
import com.sihenzhang.crockpot.item.CrockPotBlockItem;
import com.sihenzhang.crockpot.item.CrockPotSeedsItem;
import com.sihenzhang.crockpot.item.GnawsCoinItem;
import com.sihenzhang.crockpot.item.MilkmadeHatItem;
import com.sihenzhang.crockpot.item.NetherosiaItem;
import com.sihenzhang.crockpot.item.ParrotEggItem;
import com.sihenzhang.crockpot.item.food.CandyItem;
import com.sihenzhang.crockpot.item.food.CrockPotFoodBlockItem;
import com.sihenzhang.crockpot.item.food.CrockPotFoodItem;
import com.sihenzhang.crockpot.item.food.CrockPotFoodProperties;
import com.sihenzhang.crockpot.item.food.FlowerSaladItem;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.item.food.IceCreamItem;
import com.sihenzhang.crockpot.util.I18nUtils;
import com.sihenzhang.crockpot.util.RLUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class CrockPotItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"crockpot");
    public static final RegistryObject<Item> CROCK_POT = ITEMS.register("crock_pot", () -> new CrockPotBlockItem((Block)CrockPotBlocks.CROCK_POT.get()));
    public static final RegistryObject<Item> PORTABLE_CROCK_POT = ITEMS.register("portable_crock_pot", () -> new CrockPotBlockItem((Block)CrockPotBlocks.PORTABLE_CROCK_POT.get(), new Item.Properties().m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> UNKNOWN_SEEDS = ITEMS.register("unknown_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.UNKNOWN_CROPS.get()));
    public static final RegistryObject<Item> ASPARAGUS_SEEDS = ITEMS.register("asparagus_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.ASPARAGUS.get()));
    public static final RegistryObject<Item> ASPARAGUS = ITEMS.register("asparagus", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.6f).hideEffects().build()));
    public static final RegistryObject<Item> CORN_SEEDS = ITEMS.register("corn_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.CORN.get()));
    public static final RegistryObject<Item> CORN = ITEMS.register("corn", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.6f).hideEffects().build()));
    public static final RegistryObject<Item> POPCORN = ITEMS.register("popcorn", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.8f).duration(FoodUseDuration.FAST).hideEffects().build()));
    public static final RegistryObject<Item> EGGPLANT_SEEDS = ITEMS.register("eggplant_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.EGGPLANT.get()));
    public static final RegistryObject<Item> EGGPLANT = ITEMS.register("eggplant", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.6f).hideEffects().build()));
    public static final RegistryObject<Item> COOKED_EGGPLANT = ITEMS.register("cooked_eggplant", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(5, 0.6f).hideEffects().build()));
    public static final RegistryObject<Item> GARLIC_SEEDS = ITEMS.register("garlic_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.GARLIC.get()));
    public static final RegistryObject<Item> GARLIC = ITEMS.register("garlic", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.6f).hideEffects().build()));
    public static final RegistryObject<Item> ONION_SEEDS = ITEMS.register("onion_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.ONION.get()));
    public static final RegistryObject<Item> ONION = ITEMS.register("onion", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.6f).hideEffects().build()));
    public static final RegistryObject<Item> PEPPER_SEEDS = ITEMS.register("pepper_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.PEPPER.get()));
    public static final RegistryObject<Item> PEPPER = ITEMS.register("pepper", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.6f).damage(CrockPotDamageTypes.SPICY, 1.0f).hideEffects().build()));
    public static final RegistryObject<Item> TOMATO_SEEDS = ITEMS.register("tomato_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.TOMATO.get()));
    public static final RegistryObject<Item> TOMATO = ITEMS.register("tomato", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.6f).hideEffects().build()));
    public static final Supplier<Set<Item>> SEEDS = Suppliers.memoize(() -> Set.of((Item)UNKNOWN_SEEDS.get(), (Item)ASPARAGUS_SEEDS.get(), (Item)CORN_SEEDS.get(), (Item)EGGPLANT_SEEDS.get(), (Item)GARLIC_SEEDS.get(), (Item)ONION_SEEDS.get(), (Item)PEPPER_SEEDS.get(), (Item)TOMATO_SEEDS.get()));
    public static final Supplier<Set<Item>> CROPS = Suppliers.memoize(() -> Set.of((Item)ASPARAGUS.get(), (Item)CORN.get(), (Item)EGGPLANT.get(), (Item)GARLIC.get(), (Item)ONION.get(), (Item)PEPPER.get(), (Item)TOMATO.get()));
    public static final Supplier<Set<Item>> COOKED_CROPS = Suppliers.memoize(() -> Set.of((Item)POPCORN.get(), (Item)COOKED_EGGPLANT.get()));
    public static final RegistryObject<Item> BIRDCAGE = ITEMS.register("birdcage", () -> new BlockItem((Block)CrockPotBlocks.BIRDCAGE.get(), new Item.Properties()));
    public static final Map<Parrot.Variant, RegistryObject<Item>> PARROT_EGGS = (Map)Util.m_137469_(new EnumMap(Parrot.Variant.class), map -> {
        for (Parrot.Variant variant : Parrot.Variant.values()) {
            map.put(variant, ITEMS.register("parrot_egg_" + variant.m_7912_(), () -> new ParrotEggItem(variant)));
        }
    });
    public static final RegistryObject<Item> CROCK_POT_UPGRADE_SMITHING_TEMPLATE = ITEMS.register("pot_upgrade_smithing_template", () -> new SmithingTemplateItem((Component)I18nUtils.createTooltipComponent("smithing_template.pot_upgrade.applies_to").m_130940_(ChatFormatting.BLUE), (Component)I18nUtils.createTooltipComponent("smithing_template.pot_upgrade.ingredients").m_130940_(ChatFormatting.BLUE), (Component)I18nUtils.createComponent("upgrade", "pot_upgrade").m_130940_(ChatFormatting.GRAY), (Component)I18nUtils.createTooltipComponent("smithing_template.pot_upgrade.base_slot_description"), (Component)I18nUtils.createTooltipComponent("smithing_template.pot_upgrade.additions_slot_description"), List.of(RLUtils.createRL("item/empty_slot_pot")), List.of(RLUtils.createRL("item/empty_slot_block"))));
    public static final RegistryObject<Item> BLACKSTONE_DUST = ITEMS.register("blackstone_dust", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> COLLECTED_DUST = ITEMS.register("collected_dust", CollectedDustItem::new);
    public static final RegistryObject<Item> COOKED_EGG = ITEMS.register("cooked_egg", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.6f).hideEffects().build()));
    public static final RegistryObject<Item> FROG_LEGS = ITEMS.register("frog_legs", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(2, 0.4f).meat().hideEffects().build()));
    public static final RegistryObject<Item> COOKED_FROG_LEGS = ITEMS.register("cooked_frog_legs", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(5, 0.7f).meat().hideEffects().build()));
    public static final RegistryObject<Item> HOGLIN_NOSE = ITEMS.register("hoglin_nose", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(3, 0.2f).meat().hideEffects().build()));
    public static final RegistryObject<Item> COOKED_HOGLIN_NOSE = ITEMS.register("cooked_hoglin_nose", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(8, 0.7f).meat().hideEffects().build()));
    public static final RegistryObject<Item> MILK_BOTTLE = ITEMS.register("milk_bottle", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder().alwaysEat().drink().craftRemainder(Items.f_42590_).tooltip("milk_bottle", ChatFormatting.DARK_AQUA).hideEffects().build()));
    public static final RegistryObject<Item> SYRUP = ITEMS.register("syrup", () -> new CrockPotFoodItem(CrockPotFoodProperties.builder(1, 0.3f).drink().sound(SoundEvents.f_11970_).hideEffects().build()));
    public static final RegistryObject<Item> VOLT_GOAT_HORN = ITEMS.register("volt_goat_horn", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> MILKMADE_HAT = ITEMS.register("milkmade_hat", MilkmadeHatItem::new);
    public static final RegistryObject<Item> CREATIVE_MILKMADE_HAT = ITEMS.register("creative_milkmade_hat", CreativeMilkmadeHatItem::new);
    public static final RegistryObject<Item> GNAWS_COIN = ITEMS.register("gnaws_coin", GnawsCoinItem::new);
    public static final RegistryObject<Item> ASPARAGUS_SOUP = ITEMS.register("asparagus_soup", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.ASPARAGUS_SOUP.get(), CrockPotFoodProperties.builder(4, 0.3f).duration(FoodUseDuration.FAST).alwaysEat().drink().removeEffect(MobEffects.f_19613_).removeEffect(MobEffects.f_19599_).removeEffect(MobEffects.f_19610_).removeEffect(MobEffects.f_19594_).build()));
    public static final RegistryObject<Item> AVAJ = ITEMS.register("avaj", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.AVAJ.get(), CrockPotFoodProperties.builder(2, 3.6f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19596_, 38800, 2).rarity(Rarity.EPIC).build()));
    public static final RegistryObject<Item> BACON_EGGS = ITEMS.register("bacon_eggs", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.BACON_EGGS.get(), CrockPotFoodProperties.builder(12, 0.8f).heal(4.0f).meat().build()));
    public static final RegistryObject<Item> BONE_SOUP = ITEMS.register("bone_soup", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.BONE_SOUP.get(), CrockPotFoodProperties.builder(10, 0.6f).effect(MobEffects.f_19617_, 2400, 1).meat().rarity(Rarity.UNCOMMON).build()));
    public static final RegistryObject<Item> BONE_STEW = ITEMS.register("bone_stew", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.BONE_STEW.get(), CrockPotFoodProperties.builder(20, 0.4f).duration(FoodUseDuration.SUPER_SLOW).effect(MobEffects.f_19601_, 1, 1).meat().build()));
    public static final RegistryObject<Item> BREAKFAST_SKILLET = ITEMS.register("breakfast_skillet", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.BREAKFAST_SKILLET.get(), CrockPotFoodProperties.builder(8, 0.8f).meat().build()));
    public static final RegistryObject<Item> BUNNY_STEW = ITEMS.register("bunny_stew", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.BUNNY_STEW.get(), CrockPotFoodProperties.builder(6, 0.8f).effect(MobEffects.f_19605_, 100).effect((Supplier<? extends MobEffect>)CrockPotEffects.WELL_FED, 2400).meat().build()));
    public static final RegistryObject<Item> CALIFORNIA_ROLL = ITEMS.register("california_roll", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.CALIFORNIA_ROLL.get(), CrockPotFoodProperties.builder(10, 0.6f).heal(4.0f).effect(MobEffects.f_19617_, 1200).meat().build()));
    public static final RegistryObject<Item> CANDY = ITEMS.register("candy", CandyItem::new);
    public static final RegistryObject<Item> CEVICHE = ITEMS.register("ceviche", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.CEVICHE.get(), CrockPotFoodProperties.builder(7, 0.7f).alwaysEat().effect(MobEffects.f_19606_, 400, 1).effect(MobEffects.f_19617_, 400, 1).meat().build()));
    public static final RegistryObject<Item> FISH_STICKS = ITEMS.register("fish_sticks", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.FISH_STICKS.get(), CrockPotFoodProperties.builder(7, 0.7f).effect(MobEffects.f_19605_, 600).meat().build()));
    public static final RegistryObject<Item> FISH_TACOS = ITEMS.register("fish_tacos", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.FISH_TACOS.get(), CrockPotFoodProperties.builder(8, 0.9f).heal(2.0f).meat().build()));
    public static final RegistryObject<Item> FLOWER_SALAD = ITEMS.register("flower_salad", FlowerSaladItem::new);
    public static final RegistryObject<Item> FROGGLE_BUNWICH = ITEMS.register("froggle_bunwich", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.FROGGLE_BUNWICH.get(), CrockPotFoodProperties.builder(7, 0.8f).meat().build()));
    public static final RegistryObject<Item> FRUIT_MEDLEY = ITEMS.register("fruit_medley", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.FRUIT_MEDLEY.get(), CrockPotFoodProperties.builder(8, 0.4f).effect(MobEffects.f_19596_, 3600).build()));
    public static final RegistryObject<Item> GAZPACHO = ITEMS.register("gazpacho", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.GAZPACHO.get(), CrockPotFoodProperties.builder(6, 0.4f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19607_, 12000).rarity(Rarity.UNCOMMON).build()));
    public static final RegistryObject<Item> GLOW_BERRY_MOUSSE = ITEMS.register("glow_berry_mousse", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.GLOW_BERRY_MOUSSE.get(), CrockPotFoodProperties.builder(6, 0.6f).duration(FoodUseDuration.FAST).effect(MobEffects.f_19619_, 200).rarity(Rarity.UNCOMMON).build()));
    public static final RegistryObject<Item> HONEY_HAM = ITEMS.register("honey_ham", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.HONEY_HAM.get(), CrockPotFoodProperties.builder(12, 0.8f).effect(MobEffects.f_19605_, 400).effect(MobEffects.f_19617_, 1200, 1).heal(6.0f).meat().build()));
    public static final RegistryObject<Item> HONEY_NUGGETS = ITEMS.register("honey_nuggets", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.HONEY_NUGGETS.get(), CrockPotFoodProperties.builder(8, 0.3f).effect(MobEffects.f_19605_, 200).effect(MobEffects.f_19617_, 1200).heal(4.0f).meat().build()));
    public static final RegistryObject<Item> HOT_CHILI = ITEMS.register("hot_chili", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.HOT_CHILI.get(), CrockPotFoodProperties.builder(9, 0.8f).effect(MobEffects.f_19600_, 1800).effect(MobEffects.f_19598_, 1800).meat().build()));
    public static final RegistryObject<Item> HOT_COCOA = ITEMS.register("hot_cocoa", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.HOT_COCOA.get(), CrockPotFoodProperties.builder(2, 0.1f).alwaysEat().drink().effect(MobEffects.f_19596_, 9600, 1).removeEffect(MobEffects.f_19597_).removeEffect(MobEffects.f_19599_).build()));
    public static final RegistryObject<Item> ICE_CREAM = ITEMS.register("ice_cream", IceCreamItem::new);
    public static final RegistryObject<Item> ICED_TEA = ITEMS.register("iced_tea", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.ICED_TEA.get(), CrockPotFoodProperties.builder(3, 0.1f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19596_, 12000, 1).effect(MobEffects.f_19603_, 6000, 1).build()));
    public static final RegistryObject<Item> JAMMY_PRESERVES = ITEMS.register("jammy_preserves", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.JAMMY_PRESERVES.get(), CrockPotFoodProperties.builder(6, 0.3f).duration(FoodUseDuration.FAST).build()));
    public static final RegistryObject<Item> KABOBS = ITEMS.register("kabobs", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.KABOBS.get(), CrockPotFoodProperties.builder(7, 0.7f).meat().build()));
    public static final RegistryObject<Item> MASHED_POTATOES = ITEMS.register("mashed_potatoes", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.MASHED_POTATOES.get(), CrockPotFoodProperties.builder(9, 0.6f).effect(MobEffects.f_19606_, 4800).build()));
    public static final RegistryObject<Item> MEAT_BALLS = ITEMS.register("meat_balls", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.MEAT_BALLS.get(), CrockPotFoodProperties.builder(9, 0.5f).meat().build()));
    public static final RegistryObject<Item> MONSTER_LASAGNA = ITEMS.register("monster_lasagna", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.MONSTER_LASAGNA.get(), CrockPotFoodProperties.builder(7, 0.2f).effect(MobEffects.f_19612_, 300).effect(MobEffects.f_19614_, 40).damage(CrockPotDamageTypes.MONSTER_FOOD, 6.0f).meat().build()));
    public static final RegistryObject<Item> MONSTER_TARTARE = ITEMS.register("monster_tartare", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.MONSTER_TARTARE.get(), CrockPotFoodProperties.builder(8, 0.7f).effect(MobEffects.f_19600_, 2400, 1).meat().rarity(Rarity.UNCOMMON).build()));
    public static final RegistryObject<Item> MOQUECA = ITEMS.register("moqueca", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.MOQUECA.get(), CrockPotFoodProperties.builder(14, 0.7f).duration(FoodUseDuration.SLOW).effect(MobEffects.f_19616_, 1800, 2).heal(6.0f).meat().rarity(Rarity.UNCOMMON).build()));
    public static final RegistryObject<Item> MUSHY_CAKE = ITEMS.register("mushy_cake", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.MUSHY_CAKE.get(), CrockPotFoodProperties.builder(6, 0.4f).duration(FoodUseDuration.FAST).alwaysEat().effect((Supplier<? extends MobEffect>)CrockPotEffects.WITHER_RESISTANCE, 1200).rarity(Rarity.UNCOMMON).build()));
    public static final RegistryObject<Item> NETHEROSIA = ITEMS.register("netherosia", NetherosiaItem::new);
    public static final RegistryObject<Item> PEPPER_POPPER = ITEMS.register("pepper_popper", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.PEPPER_POPPER.get(), CrockPotFoodProperties.builder(8, 0.8f).effect(MobEffects.f_19600_, 1200, 1).meat().build()));
    public static final RegistryObject<Item> PEROGIES = ITEMS.register("perogies", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.PEROGIES.get(), CrockPotFoodProperties.builder(8, 0.8f).heal(6.0f).meat().build()));
    public static final RegistryObject<Item> PLAIN_OMELETTE = ITEMS.register("plain_omelette", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.PLAIN_OMELETTE.get(), CrockPotFoodProperties.builder(7, 0.6f).meat().build()));
    public static final RegistryObject<Item> POTATO_SOUFFLE = ITEMS.register("potato_souffle", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.POTATO_SOUFFLE.get(), CrockPotFoodProperties.builder(8, 0.7f).effect(MobEffects.f_19606_, 1800, 1).rarity(Rarity.UNCOMMON).build()));
    public static final RegistryObject<Item> POTATO_TORNADO = ITEMS.register("potato_tornado", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.POTATO_TORNADO.get(), CrockPotFoodProperties.builder(8, 0.6f).duration(FoodUseDuration.FAST).removeEffect(MobEffects.f_19612_).build()));
    public static final RegistryObject<Item> POW_CAKE = ITEMS.register("pow_cake", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.POW_CAKE.get(), CrockPotFoodProperties.builder(2, 0.1f).alwaysEat().damage(CrockPotDamageTypes.POW_CAKE, 1.0f).build()));
    public static final RegistryObject<Item> PUMPKIN_COOKIE = ITEMS.register("pumpkin_cookie", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.PUMPKIN_COOKIE.get(), CrockPotFoodProperties.builder(10, 0.7f).duration(FoodUseDuration.FAST).removeEffect(MobEffects.f_19612_).build()));
    public static final RegistryObject<Item> RATATOUILLE = ITEMS.register("ratatouille", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.RATATOUILLE.get(), CrockPotFoodProperties.builder(6, 0.4f).duration(FoodUseDuration.FAST).build()));
    public static final RegistryObject<Item> SALMON_SUSHI = ITEMS.register("salmon_sushi", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.SALMON_SUSHI.get(), CrockPotFoodProperties.builder(5, 0.8f).duration(FoodUseDuration.FAST).heal(1.0f).meat().build()));
    public static final RegistryObject<Item> SALSA = ITEMS.register("salsa", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.SALSA.get(), CrockPotFoodProperties.builder(7, 0.8f).duration(FoodUseDuration.FAST).effect(MobEffects.f_19598_, 7200).build()));
    public static final RegistryObject<Item> SCOTCH_EGG = ITEMS.register("scotch_egg", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.SCOTCH_EGG.get(), CrockPotFoodProperties.builder(8, 1.0f).meat().build()));
    public static final RegistryObject<Item> SEAFOOD_GUMBO = ITEMS.register("seafood_gumbo", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.SEAFOOD_GUMBO.get(), CrockPotFoodProperties.builder(9, 0.7f).effect(MobEffects.f_19605_, 2400).meat().build()));
    public static final RegistryObject<Item> STUFFED_EGGPLANT = ITEMS.register("stuffed_eggplant", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.STUFFED_EGGPLANT.get(), CrockPotFoodProperties.builder(7, 0.6f).duration(FoodUseDuration.FAST).heal(2.0f).build()));
    public static final RegistryObject<Item> SURF_N_TURF = ITEMS.register("surf_n_turf", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.SURF_N_TURF.get(), CrockPotFoodProperties.builder(8, 1.2f).alwaysEat().effect(MobEffects.f_19605_, 600, 1).heal(8.0f).meat().build()));
    public static final RegistryObject<Item> TAFFY = ITEMS.register("taffy", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.TAFFY.get(), CrockPotFoodProperties.builder(5, 0.4f).duration(FoodUseDuration.FAST).alwaysEat().effect(MobEffects.f_19621_, 9600).damage(CrockPotDamageTypes.TAFFY, 1.0f).removeEffect(MobEffects.f_19614_).build()));
    public static final RegistryObject<Item> TEA = ITEMS.register("tea", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.TEA.get(), CrockPotFoodProperties.builder(3, 0.6f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19596_, 12000, 1).effect(MobEffects.f_19598_, 6000, 1).build()));
    public static final RegistryObject<Item> TROPICAL_BOUILLABAISSE = ITEMS.register("tropical_bouillabaisse", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.TROPICAL_BOUILLABAISSE.get(), CrockPotFoodProperties.builder(7, 0.6f).alwaysEat().effect((Supplier<? extends MobEffect>)CrockPotEffects.OCEAN_AFFINITY, 3000).meat().build()));
    public static final RegistryObject<Item> TURKEY_DINNER = ITEMS.register("turkey_dinner", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.TURKEY_DINNER.get(), CrockPotFoodProperties.builder(12, 0.8f).effect(MobEffects.f_19616_, 3600).meat().build()));
    public static final RegistryObject<Item> VEG_STINGER = ITEMS.register("veg_stinger", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.VEG_STINGER.get(), CrockPotFoodProperties.builder(6, 0.3f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19611_, 12000).build()));
    public static final RegistryObject<Item> VOLT_GOAT_JELLY = ITEMS.register("volt_goat_jelly", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.VOLT_GOAT_JELLY.get(), CrockPotFoodProperties.builder(4, 0.6f).alwaysEat().effect((MobEffect)CrockPotEffects.CHARGE.get(), 7200).meat().rarity(Rarity.UNCOMMON).build()));
    public static final RegistryObject<Item> WATERMELON_ICLE = ITEMS.register("watermelon_icle", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.WATERMELON_ICLE.get(), CrockPotFoodProperties.builder(5, 0.4f).duration(FoodUseDuration.FAST).effect(MobEffects.f_19596_, 3600).effect(MobEffects.f_19603_, 3600).removeEffect(MobEffects.f_19597_).build()));
    public static final RegistryObject<Item> WET_GOOP = ITEMS.register("wet_goop", () -> new CrockPotFoodBlockItem((Block)CrockPotBlocks.WET_GOOP.get(), CrockPotFoodProperties.builder().duration(FoodUseDuration.SUPER_SLOW).alwaysEat().effect(MobEffects.f_19604_, 200).tooltip("wet_goop", ChatFormatting.DARK_AQUA).build()));
    public static final Supplier<List<Item>> FOODS_WITHOUT_AVAJ = Suppliers.memoize(() -> List.of((Item)ASPARAGUS_SOUP.get(), (Item)BACON_EGGS.get(), (Item)BONE_SOUP.get(), (Item)BONE_STEW.get(), (Item)BREAKFAST_SKILLET.get(), (Item)BUNNY_STEW.get(), (Item)CALIFORNIA_ROLL.get(), (Item)CANDY.get(), (Item)CEVICHE.get(), (Item)FISH_STICKS.get(), (Item)FISH_TACOS.get(), (Item)FLOWER_SALAD.get(), (Item)FROGGLE_BUNWICH.get(), (Item)FRUIT_MEDLEY.get(), (Item)GAZPACHO.get(), (Item)GLOW_BERRY_MOUSSE.get(), (Item)HONEY_HAM.get(), (Item)HONEY_NUGGETS.get(), (Item)HOT_CHILI.get(), (Item)HOT_COCOA.get(), (Item)ICE_CREAM.get(), (Item)ICED_TEA.get(), (Item)JAMMY_PRESERVES.get(), (Item)KABOBS.get(), (Item)MASHED_POTATOES.get(), (Item)MEAT_BALLS.get(), (Item)MONSTER_LASAGNA.get(), (Item)MONSTER_TARTARE.get(), (Item)MOQUECA.get(), (Item)MUSHY_CAKE.get(), (Item)PEPPER_POPPER.get(), (Item)PEROGIES.get(), (Item)PLAIN_OMELETTE.get(), (Item)POTATO_SOUFFLE.get(), (Item)POTATO_TORNADO.get(), (Item)POW_CAKE.get(), (Item)PUMPKIN_COOKIE.get(), (Item)RATATOUILLE.get(), (Item)SALMON_SUSHI.get(), (Item)SALSA.get(), (Item)SCOTCH_EGG.get(), (Item)SEAFOOD_GUMBO.get(), (Item)STUFFED_EGGPLANT.get(), (Item)SURF_N_TURF.get(), (Item)TAFFY.get(), (Item)TEA.get(), (Item)TROPICAL_BOUILLABAISSE.get(), (Item)TURKEY_DINNER.get(), (Item)VEG_STINGER.get(), (Item)VOLT_GOAT_JELLY.get(), (Item)WATERMELON_ICLE.get()));
    public static final RegistryObject<Item> VOLT_GOAT_SPAWN_EGG = ITEMS.register("volt_goat_spawn_egg", () -> new ForgeSpawnEggItem(CrockPotEntities.VOLT_GOAT, 5531030, 13749071, new Item.Properties()));
    public static final Map<FoodCategory, RegistryObject<Item>> FOOD_CATEGORY_ITEMS = (Map)Util.m_137469_(new EnumMap(FoodCategory.class), map -> {
        for (FoodCategory category : FoodCategory.values()) {
            map.put(category, ITEMS.register("food_category_" + category.name().toLowerCase(Locale.ROOT), CrockPotBaseItem::new));
        }
    });

    private CrockPotItems() {
    }
}

