/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei.gui.requirement;

import com.google.common.collect.ImmutableList;
import com.sihenzhang.crockpot.integration.jei.gui.DrawableNineSliceResource;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCategoryMax;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCategoryMin;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCombinationAnd;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCombinationOr;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementMustContainIngredient;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementMustContainIngredientLessThan;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMax;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMin;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCombinationAnd;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCombinationOr;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredient;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredientLessThan;
import com.sihenzhang.crockpot.util.RLUtils;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractDrawableRequirement<T extends IRequirement>
implements IDrawable {
    protected final T requirement;
    protected final Component description;

    protected AbstractDrawableRequirement(T requirement, Component description) {
        this.requirement = requirement;
        this.description = description;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        this.drawRequirementBackground(guiGraphics, xOffset, yOffset);
    }

    private void drawRequirementBackground(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        DrawableNineSliceResource drawable = new DrawableNineSliceResource(RLUtils.createRL("textures/gui/jei/requirement_background.png"), 0, 0, 64, 64, this.getWidth(), this.getHeight(), 8, 8, 8, 8, 64, 64);
        drawable.draw(guiGraphics, xOffset, yOffset);
    }

    public abstract List<ItemStack> getInvisibleInputs();

    public abstract List<GuiItemStacksInfo> getGuiItemStacksInfos(int var1, int var2);

    public static AbstractDrawableRequirement<? extends IRequirement> createDrawable(IRequirement requirement) {
        if (requirement instanceof RequirementCategoryMax) {
            RequirementCategoryMax requirementCategoryMax = (RequirementCategoryMax)requirement;
            return new DrawableRequirementCategoryMax(requirementCategoryMax);
        }
        if (requirement instanceof RequirementCategoryMaxExclusive) {
            RequirementCategoryMaxExclusive requirementCategoryMaxExclusive = (RequirementCategoryMaxExclusive)requirement;
            return new DrawableRequirementCategoryMaxExclusive(requirementCategoryMaxExclusive);
        }
        if (requirement instanceof RequirementCategoryMin) {
            RequirementCategoryMin requirementCategoryMin = (RequirementCategoryMin)requirement;
            return new DrawableRequirementCategoryMin(requirementCategoryMin);
        }
        if (requirement instanceof RequirementCategoryMinExclusive) {
            RequirementCategoryMinExclusive requirementCategoryMinExclusive = (RequirementCategoryMinExclusive)requirement;
            return new DrawableRequirementCategoryMinExclusive(requirementCategoryMinExclusive);
        }
        if (requirement instanceof RequirementCombinationAnd) {
            RequirementCombinationAnd requirementCombinationAnd = (RequirementCombinationAnd)requirement;
            return new DrawableRequirementCombinationAnd(requirementCombinationAnd);
        }
        if (requirement instanceof RequirementCombinationOr) {
            RequirementCombinationOr requirementCombinationOr = (RequirementCombinationOr)requirement;
            return new DrawableRequirementCombinationOr(requirementCombinationOr);
        }
        if (requirement instanceof RequirementMustContainIngredient) {
            RequirementMustContainIngredient requirementMustContainIngredient = (RequirementMustContainIngredient)requirement;
            return new DrawableRequirementMustContainIngredient(requirementMustContainIngredient);
        }
        if (requirement instanceof RequirementMustContainIngredientLessThan) {
            RequirementMustContainIngredientLessThan requirementMustContainIngredientLessThan = (RequirementMustContainIngredientLessThan)requirement;
            return new DrawableRequirementMustContainIngredientLessThan(requirementMustContainIngredientLessThan);
        }
        throw new IllegalArgumentException("No valid requirement was found");
    }

    public static List<AbstractDrawableRequirement<? extends IRequirement>> getDrawables(List<IRequirement> requirements) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (requirements.isEmpty()) {
            builder.add((Object)new AbstractDrawableRequirement<IRequirement>(null, (Component)Component.m_237115_((String)"integration.crockpot.jei.crock_pot_cooking.requirement.no_requirement")){

                public int getWidth() {
                    return 6 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.description);
                }

                public int getHeight() {
                    return 14;
                }

                @Override
                public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
                    super.draw(guiGraphics, xOffset, yOffset);
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, this.description, xOffset + 3, yOffset + 3, 0, false);
                }

                @Override
                public List<ItemStack> getInvisibleInputs() {
                    return List.of();
                }

                @Override
                public List<GuiItemStacksInfo> getGuiItemStacksInfos(int xOffset, int yOffset) {
                    return List.of();
                }
            });
        } else {
            ArrayList<IRequirement> tmpRequirements = new ArrayList<IRequirement>(requirements);
            Iterator it = tmpRequirements.iterator();
            while (it.hasNext()) {
                IRequirement requirement = (IRequirement)it.next();
                if (requirement instanceof RequirementMustContainIngredient || requirement instanceof RequirementMustContainIngredientLessThan) {
                    Optional<RequirementMustContainIngredientLessThan> requirementMustContainIngredientLessThan;
                    if (requirement instanceof RequirementMustContainIngredient) {
                        RequirementMustContainIngredient requirementMustContainIngredient = (RequirementMustContainIngredient)requirement;
                        requirementMustContainIngredientLessThan = tmpRequirements.stream().filter(RequirementMustContainIngredientLessThan.class::isInstance).map(RequirementMustContainIngredientLessThan.class::cast).filter(r -> {
                            if (requirementMustContainIngredient.getQuantity() != r.getQuantity()) {
                                return false;
                            }
                            IntList first = requirementMustContainIngredient.getIngredient().m_43931_();
                            IntList second = r.getIngredient().m_43931_();
                            return first.size() == second.size() && first.containsAll((IntCollection)second) && second.containsAll((IntCollection)first);
                        }).findFirst();
                        if (requirementMustContainIngredientLessThan.isPresent()) {
                            builder.add((Object)new DrawableRequirementMustContainIngredient(requirementMustContainIngredient, (RequirementMustContainIngredientLessThan)requirementMustContainIngredientLessThan.get()));
                            continue;
                        }
                        builder.add(AbstractDrawableRequirement.createDrawable(requirement));
                        continue;
                    }
                    requirementMustContainIngredientLessThan = (RequirementMustContainIngredientLessThan)requirement;
                    Optional<RequirementMustContainIngredient> requirementMustContainIngredient = tmpRequirements.stream().filter(RequirementMustContainIngredient.class::isInstance).map(RequirementMustContainIngredient.class::cast).filter(arg_0 -> AbstractDrawableRequirement.lambda$getDrawables$1((RequirementMustContainIngredientLessThan)((Object)requirementMustContainIngredientLessThan), arg_0)).findFirst();
                    if (requirementMustContainIngredient.isPresent()) {
                        it.remove();
                        continue;
                    }
                    builder.add(AbstractDrawableRequirement.createDrawable(requirement));
                    continue;
                }
                builder.add(AbstractDrawableRequirement.createDrawable(requirement));
            }
        }
        return builder.build();
    }

    private static /* synthetic */ boolean lambda$getDrawables$1(RequirementMustContainIngredientLessThan requirementMustContainIngredientLessThan, RequirementMustContainIngredient r) {
        if (requirementMustContainIngredientLessThan.getQuantity() != r.getQuantity()) {
            return false;
        }
        IntList first = requirementMustContainIngredientLessThan.getIngredient().m_43931_();
        IntList second = r.getIngredient().m_43931_();
        return first.size() == second.size() && first.containsAll((IntCollection)second) && second.containsAll((IntCollection)first);
    }

    public static class GuiItemStacksInfo {
        public RecipeIngredientRole role;
        public List<ItemStack> stacks;
        public int x;
        public int y;

        public GuiItemStacksInfo(List<ItemStack> stacks, int x, int y, boolean isRenderOnly) {
            this.role = isRenderOnly ? RecipeIngredientRole.RENDER_ONLY : RecipeIngredientRole.INPUT;
            this.stacks = stacks;
            this.x = x;
            this.y = y;
        }

        public GuiItemStacksInfo(List<ItemStack> stacks, int x, int y) {
            this(stacks, x, y, false);
        }
    }
}

