/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Blocks;

public final class JeiUtils {
    private JeiUtils() {
    }

    public static List<List<ItemStack>> getPagedItemStacks(List<ItemStack> stacks, IFocusGroup focuses, RecipeIngredientRole role, int size) {
        List<ItemStack> focusedStacks = JeiUtils.getFocusedItemStacks(stacks, focuses, role);
        if (focusedStacks.size() <= size) {
            return focusedStacks.stream().map(List::of).toList();
        }
        ArrayList<List<ItemStack>> pagedItemStacks = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < size; ++i) {
            ArrayList<ItemStack> expandedStacks = new ArrayList<ItemStack>();
            expandedStacks.add(focusedStacks.get(i));
            pagedItemStacks.add(expandedStacks);
        }
        int pages = focusedStacks.size() / size + (focusedStacks.size() % size == 0 ? 0 : 1);
        for (int i = 1; i < pages; ++i) {
            for (int j = 0; j < size; ++j) {
                ((List)pagedItemStacks.get(j)).add(i * size + j < focusedStacks.size() ? focusedStacks.get(i * size + j) : null);
            }
        }
        return pagedItemStacks;
    }

    private static List<ItemStack> getFocusedItemStacks(List<ItemStack> stacks, IFocusGroup focuses, RecipeIngredientRole role) {
        if (focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, role).findAny().isPresent()) {
            return stacks.stream().filter(stack -> focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, role).anyMatch(focus -> ItemStack.m_41656_((ItemStack)stack, (ItemStack)((ItemStack)focus.getTypedValue().getIngredient())))).toList();
        }
        return List.copyOf(stacks);
    }

    public static List<ItemStack> getItemsFromIngredientWithoutEmptyTag(Ingredient ingredient) {
        return Arrays.stream(ingredient.m_43908_()).filter(stack -> !stack.m_150930_(Blocks.f_50375_.m_5456_()) || !stack.m_41786_().m_214077_().toString().contains("Empty Tag: ")).toList();
    }
}

