/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class FoodValuesDefinitionCache {
    private static Map<FoodCategory, Set<ItemStack>> CACHE;

    private FoodValuesDefinitionCache() {
    }

    public static void regenerate(Level level) {
        CACHE = null;
        EnumMap<FoodCategory, Set<ItemStack>> map = new EnumMap<FoodCategory, Set<ItemStack>>(FoodCategory.class);
        for (FoodCategory category : FoodCategory.values()) {
            map.put(category, FoodValuesDefinition.getMatchedItems(category, level));
        }
        CACHE = Map.copyOf(map);
    }

    public static Set<ItemStack> getMatchedItems(FoodCategory category) {
        return CACHE == null ? Set.of() : CACHE.get((Object)category);
    }
}

