/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.data.recipes.AbstractFinishedRecipe;
import com.sihenzhang.crockpot.data.recipes.AbstractRecipeBuilder;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.recipe.RangedItem;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class PiglinBarteringRecipeBuilder
extends AbstractRecipeBuilder {
    private final SimpleWeightedRandomList.Builder<RangedItem> weightedResults = SimpleWeightedRandomList.m_146263_();
    private final Ingredient ingredient;

    public PiglinBarteringRecipeBuilder(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public static PiglinBarteringRecipeBuilder piglinBartering(Ingredient ingredient) {
        return new PiglinBarteringRecipeBuilder(ingredient);
    }

    public PiglinBarteringRecipeBuilder addResult(ItemLike result, int min, int max, int weight) {
        this.weightedResults.m_146271_((Object)new RangedItem(result.m_5456_(), min, max), weight);
        return this;
    }

    public PiglinBarteringRecipeBuilder addResult(ItemLike result, int count, int weight) {
        this.weightedResults.m_146271_((Object)new RangedItem(result.m_5456_(), count), weight);
        return this;
    }

    public PiglinBarteringRecipeBuilder addResult(ItemLike result, int weight) {
        return this.addResult(result, 1, weight);
    }

    public Item m_142372_() {
        return null;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.ingredient, (SimpleWeightedRandomList<RangedItem>)this.weightedResults.m_146270_()));
    }

    public void m_176498_(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        throw new UnsupportedOperationException("Piglin Bartering Recipe does not have a default recipe id");
    }

    public void m_176500_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, String pRecipeId) {
        this.m_126140_(pFinishedRecipeConsumer, new ResourceLocation(pRecipeId));
    }

    public static class Result
    extends AbstractFinishedRecipe {
        private final Ingredient ingredient;
        private final SimpleWeightedRandomList<RangedItem> weightedResults;

        public Result(ResourceLocation id, Ingredient ingredient, SimpleWeightedRandomList<RangedItem> weightedResults) {
            super(id);
            this.ingredient = ingredient;
            this.weightedResults = weightedResults;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.ingredient.m_43942_());
            JsonArray results = new JsonArray();
            this.weightedResults.m_146338_().forEach(result -> {
                JsonElement rangedItemJson = ((RangedItem)result.m_146310_()).toJson();
                rangedItemJson.getAsJsonObject().addProperty("weight", (Number)result.m_142631_().m_146281_());
                results.add(rangedItemJson);
            });
            pJson.add("results", (JsonElement)results);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)CrockPotRecipes.PIGLIN_BARTERING_RECIPE_SERIALIZER.get();
        }
    }
}

