/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.data;

import com.sihenzhang.crockpot.block.AbstractCrockPotCropBlock;
import com.sihenzhang.crockpot.block.CornBlock;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.block.CrockPotBlocks;
import com.sihenzhang.crockpot.block.food.AbstractStackableFoodBlock;
import com.sihenzhang.crockpot.util.RLUtils;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class CrockPotBlockStateProvider
extends BlockStateProvider {
    public CrockPotBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "crockpot", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.crockPotBlock((Block)CrockPotBlocks.CROCK_POT.get());
        this.crockPotBlock((Block)CrockPotBlocks.PORTABLE_CROCK_POT.get());
        this.simpleBlock((Block)CrockPotBlocks.UNKNOWN_CROPS.get(), (ModelFile)this.models().getExistingFile(RLUtils.createRL("block/unknown_crops")));
        this.customStageCropBlock((Block)CrockPotBlocks.ASPARAGUS.get(), AbstractCrockPotCropBlock.f_52244_, List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(3)), new Property[0]);
        this.customStageCropBlock((Block)CrockPotBlocks.CORN.get(), CornBlock.f_52244_, List.of(), new Property[0]);
        this.customStageCrossBlock((Block)CrockPotBlocks.EGGPLANT.get(), AbstractCrockPotCropBlock.f_52244_, List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(3)), new Property[0]);
        this.customStageCropBlock((Block)CrockPotBlocks.GARLIC.get(), AbstractCrockPotCropBlock.f_52244_, List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(3)), new Property[0]);
        this.customStageCropBlock((Block)CrockPotBlocks.ONION.get(), AbstractCrockPotCropBlock.f_52244_, List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(3)), new Property[0]);
        this.customStageCropBlock((Block)CrockPotBlocks.PEPPER.get(), AbstractCrockPotCropBlock.f_52244_, List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(3)), new Property[0]);
        this.customStageCrossBlock((Block)CrockPotBlocks.TOMATO.get(), AbstractCrockPotCropBlock.f_52244_, List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(3)), new Property[0]);
        CrockPotBlocks.FOODS.get().forEach(this::foodBlock);
    }

    public void crockPotBlock(Block block) {
        String blockName = CrockPotBlockStateProvider.getBlockName(block);
        this.getVariantBuilder(block).forAllStates(state -> {
            StringBuilder sb = new StringBuilder(blockName);
            if (((Boolean)state.m_61143_((Property)CrockPotBlock.OPEN)).booleanValue()) {
                sb.append("_open");
            }
            if (((Boolean)state.m_61143_((Property)CrockPotBlock.LIT)).booleanValue()) {
                sb.append("_lit");
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(RLUtils.createRL(sb.toString()))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
        });
    }

    public void customStageCropBlock(Block block, IntegerProperty ageProperty, List<Integer> ageSuffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Integer age = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = CrockPotBlockStateProvider.getBlockName(block) + "_stage" + (ageSuffixes.isEmpty() ? age : (Integer)ageSuffixes.get(Math.min(ageSuffixes.size(), age)));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().crop(stageName, RLUtils.createRL("block/" + stageName))).renderType(RLUtils.createVanillaRL("cutout"))).build();
        }, ignored);
    }

    public void customStageCrossBlock(Block block, IntegerProperty ageProperty, List<Integer> ageSuffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Integer age = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = CrockPotBlockStateProvider.getBlockName(block) + "_stage" + (ageSuffixes.isEmpty() ? age : (Integer)ageSuffixes.get(Math.min(ageSuffixes.size(), age)));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, RLUtils.createRL("block/" + stageName))).renderType(RLUtils.createVanillaRL("cutout"))).build();
        }, ignored);
    }

    public void foodBlock(Block block) {
        String blockName = CrockPotBlockStateProvider.getBlockName(block);
        this.getVariantBuilder(block).forAllStates(state -> {
            AbstractStackableFoodBlock stackableBlock;
            int stackCount;
            StringBuilder sb = new StringBuilder(blockName);
            Block patt4904$temp = state.m_60734_();
            if (patt4904$temp instanceof AbstractStackableFoodBlock && (stackCount = ((Integer)state.m_61143_((Property)(stackableBlock = (AbstractStackableFoodBlock)patt4904$temp).getStacksProperty())).intValue()) != 1) {
                sb.append("_").append(stackCount - 1);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(RLUtils.createRL(sb.toString()))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
        });
    }

    protected static String getBlockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }
}

