/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client;

import com.sihenzhang.crockpot.CrockPotConfigs;
import com.sihenzhang.crockpot.effect.CrockPotEffects;
import com.sihenzhang.crockpot.util.RLUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crockpot")
public class GnawsGiftHungerOverlay {
    private static final ResourceLocation GNAWS_GIFT_ICONS = RLUtils.createRL("textures/gui/gnaws_gift.png");
    private static final Random RAND = new Random();
    private static int hungerBarOffset;

    @SubscribeEvent
    public static void onClientSetupEvent(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() != GuiOverlayManager.findOverlay((ResourceLocation)VanillaGuiOverlay.FOOD_LEVEL.id())) {
            return;
        }
        if (GnawsGiftHungerOverlay.shouldRender()) {
            hungerBarOffset = ((ForgeGui)Minecraft.m_91087_().f_91065_).rightHeight;
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() != GuiOverlayManager.findOverlay((ResourceLocation)VanillaGuiOverlay.FOOD_LEVEL.id())) {
            return;
        }
        if (GnawsGiftHungerOverlay.shouldRender()) {
            Minecraft mc = Minecraft.m_91087_();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            int left = mc.m_91268_().m_85445_() / 2 + 91;
            int top = mc.m_91268_().m_85446_() - hungerBarOffset;
            int tickCount = mc.f_91065_.m_93079_();
            RAND.setSeed((long)tickCount * 312871L);
            FoodData foodData = mc.f_91074_.m_36324_();
            int foodLevel = foodData.m_38702_();
            for (int i = 0; i < 10; ++i) {
                int idx = i * 2 + 1;
                int x = left - i * 8 - 9;
                int y = top;
                if (foodData.m_38722_() <= 0.0f && tickCount % (foodLevel * 3 + 1) == 0) {
                    y = top + (RAND.nextInt(3) - 1);
                }
                guiGraphics.m_280218_(GNAWS_GIFT_ICONS, x, y, 0, 0, 9, 9);
                if (idx < foodLevel) {
                    guiGraphics.m_280218_(GNAWS_GIFT_ICONS, x, y, 9, 0, 9, 9);
                    continue;
                }
                if (idx != foodLevel) continue;
                guiGraphics.m_280218_(GNAWS_GIFT_ICONS, x, y, 18, 0, 9, 9);
            }
        }
    }

    private static boolean shouldRender() {
        if (!((Boolean)CrockPotConfigs.GNAWS_GIFT_HUNGER_OVERLAY.get()).booleanValue()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return false;
        }
        if (!player.m_21023_((MobEffect)CrockPotEffects.GNAWS_GIFT.get())) {
            return false;
        }
        ForgeGui gui = (ForgeGui)mc.f_91065_;
        boolean isMounted = player.m_20202_() instanceof LivingEntity;
        return !isMounted && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements();
    }
}

