/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.mod.item.curio.CurioItems;
import org.confluence.mod.item.curio.combat.IAutoAttack;
import org.confluence.mod.item.curio.combat.IScope;
import org.confluence.mod.item.curio.construction.IRightClickSubtractor;
import org.confluence.mod.item.curio.movement.BlizzardInABottle;
import org.confluence.mod.item.curio.movement.BundleOfBalloons;
import org.confluence.mod.item.curio.movement.CloudInABottle;
import org.confluence.mod.item.curio.movement.FartInAJar;
import org.confluence.mod.item.curio.movement.IMayFly;
import org.confluence.mod.item.curio.movement.ITabi;
import org.confluence.mod.item.curio.movement.IWallClimb;
import org.confluence.mod.item.curio.movement.SandstormInABottle;
import org.confluence.mod.item.curio.movement.TsunamiInABottle;
import org.confluence.mod.misc.ModConfigs;
import org.confluence.mod.network.NetworkHandler;
import org.confluence.mod.network.s2c.AutoAttackPacketS2C;
import org.confluence.mod.network.s2c.MagiluminescencePacketS2C;
import org.confluence.mod.network.s2c.PlayerClimbPacketS2C;
import org.confluence.mod.network.s2c.PlayerFlyPacketS2C;
import org.confluence.mod.network.s2c.PlayerJumpPacketS2C;
import org.confluence.mod.network.s2c.RightClickSubtractorPacketS2C;
import org.confluence.mod.network.s2c.ScopeEnablePacketS2C;
import org.confluence.mod.network.s2c.ShieldOfCthulhuPacketS2C;
import org.confluence.mod.network.s2c.TabiPacketS2C;
import top.theillusivec4.curios.api.CuriosApi;

public final class ModUtils {
    public static float nextFloat(RandomSource randomSource, float origin, float bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound - origin is non positive");
        }
        return origin + randomSource.m_188501_() * (bound - origin);
    }

    public static Component getModifierTooltip(double amount, String type) {
        boolean b = amount > 0.0;
        return Component.m_237110_((String)("prefix.confluence.tooltip." + (b ? "plus" : "take")), (Object[])new Object[]{ItemStack.f_41584_.format(b ? amount : -(amount *= 100.0)), Component.m_237115_((String)("prefix.confluence.tooltip." + type))}).m_130940_(b ? ChatFormatting.BLUE : ChatFormatting.RED);
    }

    public static void resetClientPacket(ServerPlayer serverPlayer) {
        AtomicDouble fartSpeed = new AtomicDouble(-1.0);
        AtomicDouble sandstormSpeed = new AtomicDouble(-1.0);
        AtomicInteger sandstormTicks = new AtomicInteger();
        AtomicDouble blizzardSpeed = new AtomicDouble(-1.0);
        AtomicInteger blizzardTicks = new AtomicInteger();
        AtomicDouble tsunamiSpeed = new AtomicDouble(-1.0);
        AtomicDouble cloudSpeed = new AtomicDouble(-1.0);
        AtomicInteger maxFlyTicks = new AtomicInteger();
        AtomicDouble flySpeed = new AtomicDouble();
        AtomicBoolean autoAttack = new AtomicBoolean();
        AtomicBoolean scope = new AtomicBoolean();
        AtomicInteger substractor = new AtomicInteger();
        AtomicInteger climb = new AtomicInteger();
        AtomicBoolean shield = new AtomicBoolean();
        AtomicBoolean tabi = new AtomicBoolean();
        AtomicBoolean magil = new AtomicBoolean();
        CuriosApi.getCuriosInventory((LivingEntity)serverPlayer).ifPresent(curiosItemHandler -> {
            IItemHandlerModifiable itemHandlerModifiable = curiosItemHandler.getEquippedCurios();
            for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
                ItemStack itemStack = itemHandlerModifiable.getStackInSlot(i);
                Item curio = itemStack.m_41720_();
                if (curio == CurioItems.SHIELD_OF_CTHULHU.get()) {
                    shield.set(true);
                    continue;
                }
                if (curio == CurioItems.MAGILUMINESCENCE.get()) {
                    magil.set(true);
                }
                if (curio instanceof FartInAJar) {
                    FartInAJar fart = (FartInAJar)curio;
                    fartSpeed.set(fart.getJumpSpeed());
                } else if (curio instanceof SandstormInABottle) {
                    SandstormInABottle sandstorm = (SandstormInABottle)curio;
                    sandstormSpeed.set(sandstorm.getJumpSpeed());
                    sandstormTicks.set(sandstorm.getJumpTicks());
                } else if (curio instanceof BlizzardInABottle) {
                    BlizzardInABottle blizzard = (BlizzardInABottle)curio;
                    blizzardSpeed.set(blizzard.getJumpSpeed());
                    blizzardTicks.set(blizzard.getJumpTicks());
                } else if (curio instanceof TsunamiInABottle) {
                    TsunamiInABottle tsunami = (TsunamiInABottle)curio;
                    tsunamiSpeed.set(tsunami.getJumpSpeed());
                } else if (curio instanceof CloudInABottle) {
                    CloudInABottle cloud = (CloudInABottle)curio;
                    cloudSpeed.set(cloud.getJumpSpeed());
                } else if (curio instanceof BundleOfBalloons) {
                    sandstormSpeed.set(((Double)ModConfigs.SANDSTORM_IN_A_BALLOON_JUMP_SPEED.get()).doubleValue());
                    sandstormTicks.set((Integer)ModConfigs.SANDSTORM_IN_A_BALLOON_JUMP_TICKS.get());
                    blizzardSpeed.set(((Double)ModConfigs.BLIZZARD_IN_A_BALLOON_JUMP_SPEED.get()).doubleValue());
                    blizzardTicks.set((Integer)ModConfigs.BLIZZARD_IN_A_BALLOON_JUMP_TICKS.get());
                    cloudSpeed.set(((Double)ModConfigs.CLOUD_IN_A_BALLOON_JUMP_SPEED.get()).doubleValue());
                }
                if (curio instanceof IMayFly) {
                    IMayFly iMayFly = (IMayFly)curio;
                    maxFlyTicks.set(Math.max(iMayFly.getFlyTicks(), maxFlyTicks.get()));
                    flySpeed.set(Math.max(iMayFly.getFlySpeed(), flySpeed.get()));
                }
                if (curio instanceof IAutoAttack) {
                    autoAttack.set(true);
                }
                if (curio instanceof IScope) {
                    scope.set(true);
                }
                if (substractor.get() < 2 && curio instanceof IRightClickSubtractor) {
                    if (curio == CurioItems.ARCHITECT_GIZMO_PACK.get()) {
                        substractor.set(2);
                    } else {
                        substractor.addAndGet(1);
                    }
                }
                if (climb.get() < 2 && curio instanceof IWallClimb) {
                    IWallClimb wallClimb = (IWallClimb)curio;
                    if (wallClimb.fullyWallClimb()) {
                        climb.set(2);
                        return;
                    }
                    climb.addAndGet(1);
                }
                if (!(curio instanceof ITabi)) continue;
                tabi.set(true);
            }
        });
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerJumpPacketS2C(fartSpeed.get(), sandstormSpeed.get(), sandstormTicks.get(), blizzardSpeed.get(), blizzardTicks.get(), tsunamiSpeed.get(), cloudSpeed.get()));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerFlyPacketS2C(maxFlyTicks.get(), flySpeed.get()));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new AutoAttackPacketS2C(autoAttack.get()));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ScopeEnablePacketS2C(scope.get()));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new RightClickSubtractorPacketS2C(substractor.get()));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerClimbPacketS2C(climb.get()));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ShieldOfCthulhuPacketS2C(shield.get()));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new TabiPacketS2C(tabi.get()));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MagiluminescencePacketS2C(magil.get()));
    }
}

