/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.mod.client.handler.InformationHandler;
import org.confluence.mod.item.curio.informational.HalfHourWatch;
import org.confluence.mod.item.curio.informational.HourWatch;
import org.confluence.mod.item.curio.informational.ICompass;
import org.confluence.mod.item.curio.informational.IDPSMeter;
import org.confluence.mod.item.curio.informational.IDepthMeter;
import org.confluence.mod.item.curio.informational.IFishermansPocketGuide;
import org.confluence.mod.item.curio.informational.ILifeFormAnalyzer;
import org.confluence.mod.item.curio.informational.IMetalDetector;
import org.confluence.mod.item.curio.informational.IRadar;
import org.confluence.mod.item.curio.informational.ISextant;
import org.confluence.mod.item.curio.informational.IStopwatch;
import org.confluence.mod.item.curio.informational.ITallyCounter;
import org.confluence.mod.item.curio.informational.IWatch;
import org.confluence.mod.item.curio.informational.IWeatherRadio;
import org.confluence.mod.network.NetworkHandler;
import org.confluence.mod.util.CuriosUtils;

public record InfoCurioCheckPacketS2C(int playerId, byte[] enabled) {
    public static void encode(InfoCurioCheckPacketS2C packet, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(packet.playerId);
        friendlyByteBuf.m_130087_(packet.enabled);
    }

    public static InfoCurioCheckPacketS2C decode(FriendlyByteBuf friendlyByteBuf) {
        return new InfoCurioCheckPacketS2C(friendlyByteBuf.readInt(), friendlyByteBuf.m_130052_());
    }

    public static void send(ServerPlayer serverPlayer, Inventory inventory) {
        ArrayList<ItemStack> itemStacks = CuriosUtils.getCurios((LivingEntity)serverPlayer);
        itemStacks.addAll((Collection<ItemStack>)inventory.f_35974_);
        byte watch = 0;
        byte weatherRadio = 0;
        byte sextant = 0;
        byte fishermansPocketGuide = 0;
        byte metalDetector = 0;
        byte lifeFormAnalyzer = 0;
        byte radar = 0;
        byte tallyCounter = 0;
        byte dpsMeter = 0;
        byte stopwatch = 0;
        byte compass = 0;
        byte depthMeter = 0;
        for (ItemStack stack : itemStacks) {
            Item item = stack.m_41720_();
            if (watch < 1 && item instanceof HourWatch) {
                watch = 1;
            } else if (watch < 2 && item instanceof HalfHourWatch) {
                watch = 2;
            } else if (watch < 3 && IWatch.isMinuteWatch(item)) {
                watch = 3;
            }
            if (item instanceof IWeatherRadio) {
                weatherRadio = 1;
            }
            if (item instanceof ISextant) {
                sextant = 1;
            }
            if (item instanceof IFishermansPocketGuide) {
                fishermansPocketGuide = 1;
            }
            if (item instanceof IMetalDetector) {
                metalDetector = 1;
            }
            if (item instanceof ILifeFormAnalyzer) {
                lifeFormAnalyzer = 1;
            }
            if (item instanceof IRadar) {
                radar = 1;
            }
            if (item instanceof ITallyCounter) {
                tallyCounter = 1;
            }
            if (item instanceof IDPSMeter) {
                dpsMeter = 1;
            }
            if (item instanceof IStopwatch) {
                stopwatch = 1;
            }
            if (item instanceof ICompass) {
                compass = 1;
            }
            if (!(item instanceof IDepthMeter)) continue;
            depthMeter = 1;
        }
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new InfoCurioCheckPacketS2C(serverPlayer.m_19879_(), new byte[]{watch, weatherRadio, sextant, fishermansPocketGuide, metalDetector, lifeFormAnalyzer, radar, tallyCounter, dpsMeter, stopwatch, compass, depthMeter}));
    }

    public static void sendToOthers(ServerPlayer serverPlayer) {
        boolean equals;
        ArrayList<ItemStack> itemStacks = CuriosUtils.getCurios((LivingEntity)serverPlayer);
        itemStacks.addAll((Collection<ItemStack>)serverPlayer.m_150109_().f_35974_);
        byte watch = -125;
        byte weatherRadio = -128;
        byte sextant = -128;
        byte fishermansPocketGuide = -128;
        byte metalDetector = -128;
        byte lifeFormAnalyzer = -128;
        byte radar = -128;
        byte tallyCounter = -128;
        byte dpsMeter = -128;
        byte stopwatch = -128;
        byte compass = -128;
        byte depthMeter = -128;
        for (ItemStack stack : itemStacks) {
            Item item = stack.m_41720_();
            if (watch > -126 && item instanceof HourWatch) {
                watch = -126;
            } else if (watch > -127 && item instanceof HalfHourWatch) {
                watch = -127;
            } else if (watch > -128 && IWatch.isMinuteWatch(item)) {
                watch = -128;
            }
            if (item instanceof IWeatherRadio) {
                weatherRadio = -1;
            }
            if (item instanceof ISextant) {
                sextant = -1;
            }
            if (item instanceof IFishermansPocketGuide) {
                fishermansPocketGuide = -1;
            }
            if (item instanceof IMetalDetector) {
                metalDetector = -1;
            }
            if (item instanceof ILifeFormAnalyzer) {
                lifeFormAnalyzer = -1;
            }
            if (item instanceof IRadar) {
                radar = -1;
            }
            if (item instanceof ITallyCounter) {
                tallyCounter = -1;
            }
            if (item instanceof IDPSMeter) {
                dpsMeter = -1;
            }
            if (item instanceof IStopwatch) {
                stopwatch = -1;
            }
            if (item instanceof ICompass) {
                compass = -1;
            }
            if (!(item instanceof IDepthMeter)) continue;
            depthMeter = -1;
        }
        boolean bl = equals = watch == -125 && weatherRadio == -128 && sextant == -128 && fishermansPocketGuide == -128 && metalDetector == -128 && lifeFormAnalyzer == -128 && radar == -128 && tallyCounter == -128 && dpsMeter == -128 && stopwatch == -128 && compass == -128 && depthMeter == -128;
        if (equals) {
            return;
        }
        InfoCurioCheckPacketS2C packet = new InfoCurioCheckPacketS2C(serverPlayer.m_19879_(), new byte[]{watch, weatherRadio, sextant, fishermansPocketGuide, metalDetector, lifeFormAnalyzer, radar, tallyCounter, dpsMeter, stopwatch, compass, depthMeter});
        Team team = serverPlayer.m_5647_();
        serverPlayer.m_284548_().m_6907_().forEach(player -> {
            if (player != serverPlayer && player.m_5647_() == team && player.m_20280_((Entity)serverPlayer) < 1024.0) {
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            }
        });
    }

    public static void handle(InfoCurioCheckPacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> InfoCurioCheckPacketS2C.lambda$handle$4(packet, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handle$4(InfoCurioCheckPacketS2C packet, Supplier ctx) {
        return () -> InfoCurioCheckPacketS2C.lambda$handle$3(packet, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$3(InfoCurioCheckPacketS2C packet, Supplier ctx) {
        InformationHandler.handlePacket(packet, ctx);
    }
}

