/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.capability.ability.AbilityProvider;
import org.confluence.mod.item.curio.BaseCurioItem;
import org.confluence.mod.item.curio.CurioItems;
import org.confluence.mod.item.curio.combat.IFireImmune;
import org.confluence.mod.item.curio.expert.RoyalGel;
import org.confluence.mod.item.curio.expert.ShieldOfCthulhu;
import org.confluence.mod.item.curio.movement.IFallResistance;
import org.confluence.mod.misc.ModAttributes;
import org.confluence.mod.util.CuriosUtils;
import org.confluence.mod.util.IEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IEntity {
    @Unique
    private int c$cthulhuSprintingTime = 0;
    @Unique
    private boolean c$isShouldRot = false;

    @Shadow
    public abstract DamageSources m_269291_();

    @Shadow
    protected abstract BlockPos m_216986_(float var1);

    @Override
    public int c$getCthulhuSprintingTime() {
        return this.c$cthulhuSprintingTime;
    }

    @Override
    public void c$setCthulhuSprintingTime(int amount) {
        this.c$cthulhuSprintingTime = amount;
    }

    @Override
    public void c$setShouldRot(boolean bool) {
        this.c$isShouldRot = bool;
    }

    @Override
    public boolean c$isShouldRot() {
        return this.c$isShouldRot;
    }

    @ModifyExpressionValue(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isInLava()Z", ordinal=1)})
    private boolean resetLavaImmune(boolean original) {
        AtomicBoolean inLava = new AtomicBoolean(original);
        Entity entity = this.c$getSelf();
        if (entity instanceof Player) {
            Player living = (Player)entity;
            BlockPos onPos = living.m_20097_();
            if (living.m_9236_().m_6425_(onPos).m_205070_(FluidTags.f_13132_) && !living.m_9236_().m_6425_(onPos.m_7494_()).m_205070_(FluidTags.f_13132_)) {
                return false;
            }
            living.getCapability(AbilityProvider.CAPABILITY).ifPresent(playerAbility -> {
                if (inLava.get()) {
                    if (playerAbility.decreaseLavaImmuneTicks()) {
                        inLava.set(false);
                    }
                } else {
                    playerAbility.increaseLavaImmuneTicks();
                }
            });
        }
        return inLava.get();
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="RETURN")}, cancellable=true)
    private void immune(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Player living;
        if (damageSource.m_276093_(DamageTypes.f_268724_)) {
            return;
        }
        Entity entity = this.c$getSelf();
        if (entity instanceof Player && (ModAttributes.applyDodge((LivingEntity)(living = (Player)entity)) || IFallResistance.isInvul((LivingEntity)living, damageSource) || IFireImmune.isInvul((LivingEntity)living, damageSource) || RoyalGel.isInvul((LivingEntity)living, damageSource) || ShieldOfCthulhu.isInvul((LivingEntity)living))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setSprinting"}, at={@At(value="TAIL")})
    private void sprinting(boolean bool, CallbackInfo ci) {
        Entity entity;
        if (bool && (entity = this.c$getSelf()) instanceof Player) {
            Player living = (Player)entity;
            if (this.c$cthulhuSprintingTime == 0 && CuriosUtils.hasCurio((LivingEntity)living, (BaseCurioItem)((Object)CurioItems.SHIELD_OF_CTHULHU.get()))) {
                ShieldOfCthulhu.apply((LivingEntity)living);
                this.c$cthulhuSprintingTime = 32;
            }
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V")})
    private void tickProfiler(CallbackInfo ci) {
        if (this.c$cthulhuSprintingTime > 0) {
            --this.c$cthulhuSprintingTime;
        }
    }

    @Inject(method={"playerTouch"}, at={@At(value="TAIL")})
    private void collidingCheck(Player player, CallbackInfo ci) {
        if (((IEntity)player).c$isOnCthulhuSprinting()) {
            Entity self = this.c$getSelf();
            Vec3 vector = player.m_20184_();
            self.m_246865_(new Vec3(vector.f_82479_ * 1.6, 0.6, vector.f_82481_ * 1.6));
            self.m_6469_(this.m_269291_().m_269075_(player), 7.8f);
            player.m_20256_(vector.m_82490_(-0.9));
            ((IEntity)player).c$setCthulhuSprintingTime(20);
        }
    }

    @Inject(method={"getOnPosLegacy"}, at={@At(value="RETURN")}, cancellable=true)
    private void getOnPosAbove(CallbackInfoReturnable<BlockPos> cir) {
        if (this.c$getSelf() instanceof ServerPlayer && this.c$isShouldRot) {
            cir.setReturnValue((Object)this.m_216986_(-2.2f));
        }
    }

    @Unique
    private Entity c$getSelf() {
        return (Entity)this;
    }
}

