/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import org.confluence.mod.block.ModBlocks;
import org.confluence.mod.menu.AmountResultSlot;
import org.confluence.mod.menu.ModMenus;
import org.confluence.mod.recipe.AbstractAmountRecipe;
import org.confluence.mod.recipe.ModRecipes;
import org.confluence.mod.recipe.WorkshopRecipe;
import org.jetbrains.annotations.NotNull;

public class WorkshopMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Player player;
    private final CraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 4);
    private final ResultContainer resultSlot = new ResultContainer();
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private List<WorkshopRecipe> recipes = new ArrayList<WorkshopRecipe>();

    public WorkshopMenu(int pContainerId, Inventory inventory) {
        this(pContainerId, inventory, ContainerLevelAccess.f_39287_);
    }

    public WorkshopMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super((MenuType)ModMenus.WORKSHOP.get(), pContainerId);
        this.player = pPlayerInventory.f_35978_;
        this.access = pAccess;
        this.m_38897_(new AmountResultSlot(this.craftSlots, (Container)this.resultSlot, 0, 62, 35){

            @Override
            public void m_142406_(@NotNull Player pPlayer, @NotNull ItemStack pStack) {
                if (this.recipe != null) {
                    AbstractAmountRecipe.extractIngredients((Container)this.crafting, this.recipe.m_7527_());
                    WorkshopMenu.this.setupResultSlot();
                }
            }
        });
        this.m_38897_(new Slot((Container)this.craftSlots, 0, 35, 8));
        this.m_38897_(new Slot((Container)this.craftSlots, 1, 53, 8));
        this.m_38897_(new Slot((Container)this.craftSlots, 2, 71, 8));
        this.m_38897_(new Slot((Container)this.craftSlots, 3, 89, 8));
        this.m_38897_(new Slot((Container)this.craftSlots, 4, 89, 26));
        this.m_38897_(new Slot((Container)this.craftSlots, 5, 89, 44));
        this.m_38897_(new Slot((Container)this.craftSlots, 6, 89, 62));
        this.m_38897_(new Slot((Container)this.craftSlots, 7, 71, 62));
        this.m_38897_(new Slot((Container)this.craftSlots, 8, 53, 62));
        this.m_38897_(new Slot((Container)this.craftSlots, 9, 35, 62));
        this.m_38897_(new Slot((Container)this.craftSlots, 10, 35, 44));
        this.m_38897_(new Slot((Container)this.craftSlots, 11, 35, 26));
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)pPlayerInventory, l + k * 9 + 9, 8 + l * 18, 84 + k * 18));
            }
        }
        for (int m = 0; m < 9; ++m) {
            this.m_38897_(new Slot((Container)pPlayerInventory, m, 8 + m * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getCurrentIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public int getRecipesAmount() {
        return this.recipes.size();
    }

    public ItemStack getUpResult() {
        int index = this.getUpIndex();
        if (index == -1) {
            return this.resultSlot.m_8020_(0);
        }
        return this.recipes.get(index).m_8043_(null);
    }

    public int getUpIndex() {
        if (this.recipes.isEmpty()) {
            return -1;
        }
        if (this.recipes.size() == 1) {
            return 0;
        }
        if (this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            if (this.selectedRecipeIndex.m_6501_() == 0) {
                return this.recipes.size() - 1;
            }
            return this.selectedRecipeIndex.m_6501_() - 1;
        }
        return -1;
    }

    public ItemStack getDownResult() {
        int index = this.getDownIndex();
        if (index == -1) {
            return this.resultSlot.m_8020_(0);
        }
        return this.recipes.get(index).m_8043_(null);
    }

    public int getDownIndex() {
        if (this.recipes.isEmpty()) {
            return -1;
        }
        if (this.recipes.size() == 1) {
            return 0;
        }
        if (this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            int next = this.selectedRecipeIndex.m_6501_() + 1;
            if (next == this.recipes.size()) {
                return 0;
            }
            return next;
        }
        return -1;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public boolean m_6366_(@NotNull Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.m_6422_(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            WorkshopRecipe recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack itemStack = recipe.m_8043_(null).m_41777_();
            if (itemStack.m_246617_(this.player.m_9236_().m_246046_())) {
                this.resultSlot.m_6836_(0, itemStack);
                this.setCurrentRecipe(recipe);
            } else {
                this.resultSlot.m_6836_(0, ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_6836_(0, ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return WorkshopMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)ModBlocks.WORKSHOP.get()));
    }

    public void m_6877_(@NotNull Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(pPlayer, (Container)this.craftSlots));
    }

    public boolean m_5882_(@NotNull ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.resultSlot && super.m_5882_(pStack, pSlot);
    }

    public void m_6199_(@NotNull Container pContainer) {
        this.recipes.clear();
        this.recipes = this.player.m_9236_().m_7465_().m_44056_((RecipeType)ModRecipes.WORKSHOP_TYPE.get(), pContainer, this.player.m_9236_());
        if (this.selectedRecipeIndex.m_6501_() >= this.recipes.size()) {
            this.selectedRecipeIndex.m_6422_(this.recipes.size() - 1);
        }
        this.access.m_39292_((level, pos) -> {
            Player patt6438$temp = this.player;
            if (patt6438$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt6438$temp;
                ItemStack itemStack = ItemStack.f_41583_;
                if (!this.recipes.isEmpty()) {
                    if (this.selectedRecipeIndex.m_6501_() == -1) {
                        this.selectedRecipeIndex.m_6422_(0);
                    }
                    WorkshopRecipe recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
                    itemStack = recipe.m_8043_(null).m_41777_();
                    this.setCurrentRecipe(recipe);
                }
                this.resultSlot.m_6836_(0, itemStack);
                this.m_150404_(0, itemStack);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, itemStack));
            }
        });
    }

    private void setCurrentRecipe(WorkshopRecipe recipe) {
        Slot slot = this.m_38853_(0);
        if (slot instanceof AmountResultSlot) {
            AmountResultSlot amountResultSlot = (AmountResultSlot)slot;
            amountResultSlot.setCurrentRecipe(recipe);
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            itemStack = slotItem.m_41777_();
            if (pIndex == 0) {
                this.access.m_39292_((level, blockPos) -> slotItem.m_41720_().m_7836_(slotItem, level, pPlayer));
                if (!this.m_38903_(slotItem, 13, 49, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotItem, itemStack);
            } else if (pIndex >= 13 && pIndex < 49 ? !this.m_38903_(slotItem, 1, 13, false) && (pIndex < 40 ? !this.m_38903_(slotItem, 40, 49, false) : !this.m_38903_(slotItem, 13, 40, false)) : !this.m_38903_(slotItem, 13, 49, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItem.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, slotItem);
            if (pIndex == 0) {
                pPlayer.m_36176_(slotItem, false);
            }
        }
        return itemStack;
    }
}

