/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.item.curio.movement;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.confluence.mod.client.color.FloatRGB;
import org.confluence.mod.item.curio.ILavaImmune;
import org.confluence.mod.item.curio.combat.IFireImmune;
import org.confluence.mod.item.curio.combat.ILavaHurtReduce;
import org.confluence.mod.item.curio.movement.FrostsparkBoots;
import org.confluence.mod.item.curio.movement.IFluidWalk;
import org.confluence.mod.item.curio.movement.IceSkates;
import org.confluence.mod.misc.ModConfigs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import top.theillusivec4.curios.api.SlotContext;

public class TerrasparkBoots
extends FrostsparkBoots
implements IFireImmune,
ILavaImmune,
ILavaHurtReduce,
IFluidWalk {
    public static final UUID SPEED_UUID = UUID.fromString("73456995-B70B-48D9-7EA4-191BD76C94C9");
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(SPEED_UUID, "Terraspark Boots", 0.08, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final Vector3f START_COLOR = FloatRGB.fromInteger(1341301).toVector();
    public static final Vector3f END_COLOR = FloatRGB.fromInteger(16579668).toVector();

    @Override
    public Vector3f getParticleColorStart() {
        return START_COLOR;
    }

    @Override
    public Vector3f getParticleColorEnd() {
        return END_COLOR;
    }

    @Override
    public int getFlyTicks() {
        return (Integer)ModConfigs.TERRASPARK_BOOTS_FLY_TICKS.get();
    }

    @Override
    public double getFlySpeed() {
        return (Double)ModConfigs.TERRASPARK_BOOTS_FLY_SPEED.get();
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        IceSkates.tick(slotContext.entity(), stack);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LivingEntity living = slotContext.entity();
        if (living != null) {
            if (stack.m_41784_().m_128471_("onPosIsIce")) {
                return ImmutableMultimap.of((Object)Attributes.f_22279_, (Object)SPEED_MODIFIER, (Object)Attributes.f_22279_, (Object)TerrasparkBoots.getSpeedModifier(stack), (Object)Attributes.f_22279_, (Object)IceSkates.MODIFIER);
            }
            AttributeInstance attribute = living.m_21051_(Attributes.f_22279_);
            if (attribute != null) {
                attribute.m_22120_(IceSkates.SPEED_UUID);
            }
        }
        return ImmutableMultimap.of((Object)Attributes.f_22279_, (Object)SPEED_MODIFIER, (Object)Attributes.f_22279_, (Object)TerrasparkBoots.getSpeedModifier(stack));
    }

    @Override
    public List<TagKey<Fluid>> canStandOn() {
        return ALL_FLUIDS;
    }

    @Override
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add(IFluidWalk.ALL_FLUID);
        list.add((Component)Component.m_237115_((String)"item.confluence.terraspark_boots.tooltip2"));
        list.add(ILavaHurtReduce.TOOLTIP);
    }
}

