/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.item.curio.movement;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.confluence.mod.client.color.FloatRGB;
import org.confluence.mod.item.curio.movement.IceSkates;
import org.confluence.mod.item.curio.movement.LightningBoots;
import org.confluence.mod.misc.ModConfigs;
import org.confluence.mod.misc.ModRarity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import top.theillusivec4.curios.api.SlotContext;

public class FrostsparkBoots
extends LightningBoots {
    public static final UUID SPEED_UUID = UUID.fromString("FF5835B7-FA33-A02D-A91F-E0043403CE69");
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(SPEED_UUID, "Frostspark Boots", 0.08, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final Vector3f START_COLOR = FloatRGB.fromInteger(6934524).toVector();
    private static final Vector3f END_COLOR = FloatRGB.fromInteger(6934524).toVector();

    public FrostsparkBoots() {
        super(ModRarity.LIME);
    }

    @Override
    public Vector3f getParticleColorStart() {
        return START_COLOR;
    }

    @Override
    public Vector3f getParticleColorEnd() {
        return END_COLOR;
    }

    @Override
    public int getFlyTicks() {
        return (Integer)ModConfigs.FROSTSPARK_BOOTS_FLY_TICKS.get();
    }

    @Override
    public double getFlySpeed() {
        return (Double)ModConfigs.FROSTSPARK_BOOTS_FLY_SPEED.get();
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        IceSkates.tick(slotContext.entity(), stack);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LivingEntity living = slotContext.entity();
        if (living != null) {
            if (stack.m_41784_().m_128471_("onPosIsIce")) {
                return ImmutableMultimap.of((Object)Attributes.f_22279_, (Object)SPEED_MODIFIER, (Object)Attributes.f_22279_, (Object)FrostsparkBoots.getSpeedModifier(stack), (Object)Attributes.f_22279_, (Object)IceSkates.MODIFIER);
            }
            AttributeInstance attribute = living.m_21051_(Attributes.f_22279_);
            if (attribute != null) {
                attribute.m_22120_(IceSkates.SPEED_UUID);
            }
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }

    @Override
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237115_((String)"item.confluence.frostspark_boots.tooltip"));
    }
}

