/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.item.curio.expert;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.mod.item.curio.BaseCurioItem;
import org.confluence.mod.item.curio.CurioItems;
import org.confluence.mod.misc.ModAttributes;
import org.confluence.mod.misc.ModConfigs;
import org.confluence.mod.misc.ModRarity;
import org.confluence.mod.network.NetworkHandler;
import org.confluence.mod.network.s2c.ShieldOfCthulhuPacketS2C;
import org.confluence.mod.util.CuriosUtils;
import org.confluence.mod.util.IEntity;
import top.theillusivec4.curios.api.SlotContext;

public class ShieldOfCthulhu
extends BaseCurioItem
implements ModRarity.Expert {
    public static final UUID ARMOR_UUID = UUID.fromString("C99AA305-E0CF-9E8F-06AB-8F61C28EAF51");
    public static final UUID CRIT_UUID = UUID.fromString("46A0C13B-7ADA-7648-777E-64FE56402A49");
    private static ImmutableMultimap<Attribute, AttributeModifier> ATTRIBUTES;

    public ShieldOfCthulhu() {
        super(ModRarity.EXPERT);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        ShieldOfCthulhu.send(slotContext.entity(), true);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        ShieldOfCthulhu.send(slotContext.entity(), false);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (ATTRIBUTES == null) {
            ATTRIBUTES = ImmutableMultimap.of((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_UUID, "Shield Of Cthulhu", (double)((Integer)ModConfigs.SHIELD_OF_CTHULHU_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION), (Object)ModAttributes.getCriticalChance(), (Object)new AttributeModifier(CRIT_UUID, "Shield Of Cthulhu", ((Double)ModConfigs.SHIELD_OF_CTHULHU_CRITICAL_CHANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        return ATTRIBUTES;
    }

    @Override
    public Component[] getInformation() {
        return new Component[]{Component.m_237115_((String)"item.confluence.shield_of_cthulhu.info")};
    }

    public static void apply(LivingEntity living) {
        float f = living.m_146908_() * ((float)Math.PI / 180);
        double factor = living.m_20096_() ? 1.6 : 1.2;
        living.m_20256_(living.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f)) * factor, 0.0, (double)Mth.m_14089_((float)f) * factor));
    }

    public static boolean isInvul(LivingEntity living) {
        if (CuriosUtils.noSameCurio(living, (BaseCurioItem)((Object)CurioItems.SHIELD_OF_CTHULHU.get()))) {
            return false;
        }
        return ((IEntity)living).c$isOnCthulhuSprinting();
    }

    private static void send(LivingEntity living, boolean has) {
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ShieldOfCthulhuPacketS2C(has));
        }
    }
}

