/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.confluence.mod.block.ModBlocks;
import org.confluence.mod.integration.jei.ModJeiPlugin;
import org.confluence.mod.recipe.WorkshopRecipe;
import org.jetbrains.annotations.NotNull;

public class WorkshopCategory
implements IRecipeCategory<WorkshopRecipe> {
    public static final RecipeType<WorkshopRecipe> TYPE = RecipeType.create((String)"confluence", (String)"workshop", WorkshopRecipe.class);
    private static final Component TITLE = Component.m_237115_((String)"title.confluence.workshop");
    private final IDrawable icon;

    public WorkshopCategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.WORKSHOP.get()));
    }

    @NotNull
    public RecipeType<WorkshopRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return ModJeiPlugin.HALF_BACKGROUND;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull WorkshopRecipe recipe, @NotNull IFocusGroup focusGroup) {
        int size = recipe.m_7527_().size();
        int line = size / 3;
        boolean remain = size % 3 != 0;
        int x = 0;
        int y = 0;
        if (line == 0) {
            y = 24;
        } else if (line == 1) {
            y = remain ? 16 : 24;
        } else if (line == 2) {
            y = remain ? 8 : 16;
        } else if (line == 3) {
            y = remain ? 0 : 8;
        }
        for (Ingredient ingredient : recipe.m_7527_()) {
            ModJeiPlugin.addInput(builder, x, y, ingredient);
            if ((x += 16) != 48) continue;
            x = 0;
            y += 16;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 24).addItemStack(recipe.m_8043_(null));
    }

    public void draw(@NotNull WorkshopRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ModJeiPlugin.drawArrowRight(guiGraphics, 50, 22, true);
    }
}

