/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.event;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.confluence.mod.capability.ability.AbilityProvider;
import org.confluence.mod.item.curio.combat.FrozenTurtleShell;
import org.confluence.mod.item.curio.combat.IHoneycomb;
import org.confluence.mod.item.curio.combat.ILavaHurtReduce;
import org.confluence.mod.item.curio.combat.IStarCloak;
import org.confluence.mod.item.curio.combat.MoltenQuiver;
import org.confluence.mod.item.curio.combat.PaladinsShield;
import org.confluence.mod.item.curio.combat.PanicNecklace;
import org.confluence.mod.item.curio.expert.BrainOfConfusion;
import org.confluence.mod.item.curio.expert.WormScarf;
import org.confluence.mod.item.curio.informational.IDPSMeter;
import org.confluence.mod.item.curio.movement.IFallResistance;
import org.confluence.mod.misc.ModAttributes;
import org.confluence.mod.misc.ModConfigs;
import org.confluence.mod.network.NetworkHandler;
import org.confluence.mod.network.s2c.EntityKilledPacketS2C;
import org.confluence.mod.util.ModUtils;

@Mod.EventBusSubscriber(modid="confluence", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEvents {
    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            if (player.getCapability(AbilityProvider.CAPABILITY).isPresent()) {
                return;
            }
            event.addCapability(new ResourceLocation("confluence", "ability"), (ICapabilityProvider)new AbilityProvider());
        }
    }

    @SubscribeEvent
    public static void livingHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        if (living.m_9236_().f_46443_) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_276093_(DamageTypes.f_268724_) || damageSource.m_276093_(DamageTypes.f_286979_)) {
            return;
        }
        RandomSource random = living.m_9236_().f_46441_;
        float amount = event.getAmount();
        if (amount < 0.0f) {
            return;
        }
        IHoneycomb.apply(living, random);
        IStarCloak.apply(living, random);
        PanicNecklace.apply(living);
        amount = ModAttributes.applyMagicDamage(damageSource, amount);
        amount = ModAttributes.applyRangedDamage(damageSource, amount);
        amount = PaladinsShield.apply(living, damageSource, amount);
        amount = FrozenTurtleShell.apply(living, amount);
        amount = ILavaHurtReduce.apply(living, damageSource, amount);
        amount = IFallResistance.apply(living, damageSource, amount);
        amount = WormScarf.apply(living, amount);
        amount = BrainOfConfusion.apply(living, random, amount);
        if (((Boolean)ModConfigs.RANDOM_ATTACK_DAMAGE.get()).booleanValue()) {
            amount *= ModUtils.nextFloat(random, ((Double)ModConfigs.RANDOM_ATTACK_DAMAGE_MIN.get()).floatValue(), ((Double)ModConfigs.RANDOM_ATTACK_DAMAGE_MAX.get()).floatValue());
        }
        IDPSMeter.sendMsg(amount, damageSource.m_7639_());
        event.setAmount(amount);
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            EntityType entityType = living.m_6095_();
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new EntityKilledPacketS2C(serverPlayer.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)entityType)), ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType)));
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity self = event.getEntity();
        if (!(self instanceof Enemy)) {
            return;
        }
        LivingEntity livingEntity = event.getNewTarget();
        if (livingEntity instanceof Player) {
            Player playerO = (Player)livingEntity;
            double range = self.m_21133_(Attributes.f_22277_);
            double rangeSqr = range * range;
            self.m_9236_().m_6907_().stream().filter(player -> player.m_20280_((Entity)self) < rangeSqr && self.m_6779_((LivingEntity)player)).max((playerA, playerB) -> {
                AttributeInstance instanceA = playerA.m_21051_(ModAttributes.getAggro());
                AttributeInstance instanceB = playerB.m_21051_(ModAttributes.getAggro());
                if (instanceA != null && instanceB != null) {
                    return (int)(instanceA.m_22135_() - instanceB.m_22135_());
                }
                return 0;
            }).ifPresent(player -> {
                if (player == playerO) {
                    return;
                }
                AttributeInstance instanceO = playerO.m_21051_(ModAttributes.getAggro());
                AttributeInstance instance = player.m_21051_(ModAttributes.getAggro());
                if (instanceO != null && instance != null && instanceO.m_22135_() < instance.m_22135_()) {
                    event.setNewTarget((LivingEntity)player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingTickEvent event) {
        ModAttributes.applyPickupRange(event.getEntity());
    }

    @SubscribeEvent
    public static void entityJoinLevel(EntityJoinLevelEvent event) {
        AbstractArrow arrow;
        if (event.loadedFromDisk() || event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ModAttributes.applyToArrow(living, arrow);
            MoltenQuiver.applyToArrow(living, arrow);
        }
    }
}

