/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.entity.projectile;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.entity.ModEntities;
import org.jetbrains.annotations.NotNull;

public class BeeProjectile
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Boolean> DATA_IS_GIANT = SynchedEntityData.m_135353_(BeeProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDimensions SMALL = new EntityDimensions(0.25f, 0.25f, true);
    private static final EntityDimensions GIANT = new EntityDimensions(0.375f, 0.375f, true);
    private int blockHitCount = 0;
    private int lifeTime = 0;
    private Entity target;

    public BeeProjectile(EntityType<BeeProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public BeeProjectile(Level level, LivingEntity owner, boolean isGiant) {
        this((EntityType<BeeProjectile>)((EntityType)ModEntities.BEE_PROJECTILE.get()), level);
        this.m_5602_((Entity)owner);
        this.blockHitCount = 0;
        this.lifeTime = 0;
        this.f_19804_.m_135381_(DATA_IS_GIANT, (Object)isGiant);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_GIANT, (Object)false);
    }

    public boolean isGiant() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_GIANT);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 == 2) {
            this.m_9236_().m_6249_(this.m_19749_(), new AABB(this.m_20097_()).m_82400_(8.0), entity -> entity instanceof Enemy).stream().min((a, b) -> (int)(a.m_20280_((Entity)this) - b.m_20280_((Entity)this))).ifPresent(monster -> {
                this.target = monster;
            });
        }
        if (this.target != null) {
            Vec3 vec3;
            double lengthSqr;
            LivingEntity living;
            Entity entity2;
            if (this.target.m_5833_() || (entity2 = this.target) instanceof LivingEntity && (living = (LivingEntity)entity2).m_21224_()) {
                this.target = null;
            }
            if (this.target != null && (lengthSqr = (vec3 = new Vec3(this.target.m_20185_() - this.m_20185_(), this.target.m_20186_() + (double)this.target.m_20192_() / 2.0 - this.m_20186_(), this.target.m_20189_() - this.m_20189_())).m_82556_()) < 64.0) {
                double factor = 1.0 - Math.sqrt(lengthSqr) / 8.0;
                this.m_246865_(vec3.m_82541_().m_82490_(factor * factor * (this.isGiant() ? 0.3 : 0.1)));
            }
        }
        Vec3 motion = this.m_20184_();
        this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)motion.m_165924_()) * 57.2957763671875));
        this.m_6478_(MoverType.SELF, motion);
        if (this.lifeTime++ > (this.isGiant() ? 220 : 200)) {
            this.m_146870_();
        }
    }

    protected boolean m_5931_() {
        return false;
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        Vec3 motion = this.m_20184_();
        double x = motion.f_82479_;
        double y = motion.f_82480_;
        double z = motion.f_82481_;
        switch (blockHitResult.m_82434_().m_122434_()) {
            case X: {
                x = -x;
                break;
            }
            case Y: {
                y = -y;
                break;
            }
            case Z: {
                z = -z;
            }
        }
        this.m_20334_(x, y, z);
        if (this.blockHitCount++ > (this.isGiant() ? 2 : 1)) {
            this.m_146870_();
        }
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity != this.m_19749_()) {
            float damage = 5.0f + (float)(this.isGiant() ? this.f_19796_.m_216339_(1, 4) : (this.f_19796_.m_188499_() ? 1 : 0));
            entity.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)this.m_19749_()), damage);
            if (this.isGiant()) {
                Vec3 motion = this.m_20182_().m_82546_(entity.m_20182_()).m_82541_().m_82490_(0.5);
                entity.m_5997_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return this.isGiant() ? GIANT : SMALL;
    }
}

