/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.mod.entity.ModEntities;
import org.confluence.mod.network.NetworkHandler;
import org.confluence.mod.network.s2c.StepStoolStepPacketS2C;

public class StepStoolEntity
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<Integer> DATA_STEP_ID = SynchedEntityData.m_135353_(StepStoolEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Vec3 GRAVITY = new Vec3(0.0, -0.08, 0.0);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;

    public StepStoolEntity(EntityType<StepStoolEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19850_ = true;
    }

    public StepStoolEntity(Player player) {
        this((EntityType<StepStoolEntity>)((EntityType)ModEntities.STEP_STOOL.get()), player.m_9236_());
        this.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        this.setOwner((Entity)player);
    }

    public void m_8119_() {
        Entity owner;
        super.m_8119_();
        if (!(this.m_9236_().f_46443_ || (owner = this.m_19749_()) != null && owner.m_20202_() == null)) {
            this.m_146870_();
        }
        this.m_246865_(GRAVITY);
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        Entity entity = this.m_19749_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)StepStoolStepPacketS2C.resetStep());
        }
    }

    public boolean m_5829_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_STEP_ID, (Object)1);
    }

    public void setStep(int step) {
        this.f_19804_.m_135381_(DATA_STEP_ID, (Object)step);
    }

    public int getStep() {
        return (Integer)this.f_19804_.m_135370_(DATA_STEP_ID);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_STEP_ID.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public void setOwner(@Nullable Entity pOwner) {
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
        this.cachedOwner = pOwner;
    }

    @Nullable
    public Entity m_19749_() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cachedOwner = serverLevel.m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
            this.cachedOwner = null;
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return super.m_6972_(pPose).m_20390_(1.0f, (float)this.getStep());
    }
}

