/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.datagen;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import org.confluence.mod.datagen.limit.CustomName;
import org.confluence.mod.effect.ModEffects;
import org.confluence.mod.entity.ModEntities;
import org.confluence.mod.item.ModItems;

public class ModEnglishProvider
extends LanguageProvider {
    public ModEnglishProvider(PackOutput output) {
        super(output, "confluence", "en_us");
    }

    protected void addTranslations() {
        this.add("creativetab.confluence.accessories", "Confluence | Accessories");
        this.add("curios.tooltip.speed_boots", "The wearer can run super fast");
        this.add("curios.tooltip.may_fly", "Allows flight");
        this.add("curios.tooltip.jump_boost", "Increases jump height");
        this.add("curios.tooltip.multi_jump", "Allows the holder to double jump");
        this.add("curios.tooltip.fall_resistance", "Increases fall resistance");
        this.add("curios.tooltip.negates_fall_damage", "Negates fall damage");
        this.add("curios.tooltip.watch", "Tell the time");
        this.add("curios.tooltip.fire_immune", "Grants immunity to fire blocks");
        this.add("curios.tooltip.fluid_walk.part", "Provides the ability to walk on water & honey");
        this.add("curios.tooltip.fluid_walk.all", "Provides the ability t walk on water, honey & lava");
        this.add("curios.tooltip.lava_immune", "Provides 7 seconds of immunity to lava");
        this.add("curios.tooltip.lava_hurt_reduce", "Reduces damage from touching lava");
        this.add("curios.tooltip.fire_attack", "Melee attacks inflict fire damage");
        this.add("curios.tooltip.auto_attack", "Enables auto swing for melee weapons");
        this.add("curios.tooltip.aggro_attach", "Enemies are more likely to target you");
        this.add("curios.tooltip.armor_pass", "Increases armor penetration by %s");
        this.add("curios.tooltip.compass", "Displays horizontal position");
        this.add("curios.tooltip.depth_meter", "Displays depth");
        this.add("curios.tooltip.dps_meter", "Displays your damage per second");
        this.add("curios.tooltip.fishermans_pocket_guide", "Displays fishing information");
        this.add("curios.tooltip.life_form_analyzer", "Displays the name of rare creatures around you");
        this.add("curios.tooltip.metal_detector", "Displays the most valuable ore around you");
        this.add("curios.tooltip.radar", "Detects enemies around you");
        this.add("curios.tooltip.sextant", "Displays the phase of the moon");
        this.add("curios.tooltip.stopwatch", "Displays how fast the player is moving");
        this.add("curios.tooltip.tally_counter", "Displays how many monsters have been killed");
        this.add("curios.tooltip.weather_radio", "Displays the weather");
        this.add("curios.tooltip.scope", "Increases view range for ranged weapons");
        this.add("curios.tooltip.scope2", "Hold ranged weapon and crouch to zoom out");
        this.add("curios.tooltip.wall_climb", "Allows the ability to climb walls, hold shift key to slide down");
        this.add("curios.tooltip.wall_slide", "Allows the ability to slide down walls, hold shift key to slide down quickly");
        this.add("curios.tooltip.tabi", "Allows the ability to dash while double tap a direction");
        this.add("curios.tooltip.dodge", "Gives a chance to dodge attacks");
        this.add("info.confluence.time", "Time: [%s:%s]");
        this.add("info.confluence.radar", "Enemies: %s");
        this.add("info.confluence.compass.east", "East: %s, ");
        this.add("info.confluence.compass.west", "West: %s, ");
        this.add("info.confluence.compass.south", "South: %s");
        this.add("info.confluence.compass.north", "North: %s");
        this.add("info.confluence.depth_meter.surface", "Surface: %s");
        this.add("info.confluence.depth_meter.underground", "Underground: %s");
        this.add("info.confluence.tally_counter.unknown", "Kill count unavailable");
        this.add("info.confluence.tally_counter", "Killed '");
        this.add("info.confluence.life_form_analyzer.none", "No rare creatures nearby!");
        this.add("info.confluence.life_form_analyzer", "%s detected nearby!");
        this.add("info.confluence.metal_detector.none", "No treasure nearby!");
        this.add("info.confluence.metal_detector", "%s detected nearby!");
        this.add("info.confluence.stopwatch", "Speed: %s m/s");
        this.add("info.confluence.dps_meter", "DPS: %s");
        this.add("info.confluence.sextant.0", "Moon phase: Full Moon");
        this.add("info.confluence.sextant.1", "Moon phase: Waning Gibbous");
        this.add("info.confluence.sextant.2", "Moon phase: Third Quarter");
        this.add("info.confluence.sextant.3", "Moon phase: Waning Crescent");
        this.add("info.confluence.sextant.4", "Moon phase: New Moon");
        this.add("info.confluence.sextant.5", "Moon phase: Waxing Crescent");
        this.add("info.confluence.sextant.6", "Moon phase: First Quarter");
        this.add("info.confluence.sextant.7", "Moon phase: Waxing Gibbous");
        this.add("info.confluence.weather_radio.clear", "Weather: Clear");
        this.add("info.confluence.weather_radio.cloudy", "Weather: Cloudy");
        this.add("info.confluence.weather_radio.rain", "Weather: Rain");
        this.add("info.confluence.weather_radio.snow", "Weather: Snow");
        this.add("info.confluence.weather_radio.thunder", "Weather: Thunder");
        this.add("info.confluence.fishermans_pocket_guide", "Fishing Power: %s");
        this.add("key.confluence.metal_detector", "Detect Metal");
        this.add("key.confluence.step_stool", "Step Stool");
        this.add("curios.identifier.accessory", "Accessory");
        this.add("curios.modifiers.accessory", "When worn as accessory:");
        this.add("item.confluence.demon_heart.tooltip", "Permanently increases the number of accessory slots");
        this.add("item.confluence.vitamins.tooltip", "Immunity to Weakness");
        this.add("item.confluence.fast_clock.tooltip", "Immunity to Slow");
        this.add("item.confluence.blindfold.tooltip", "Immunity to Blindness");
        this.add("item.confluence.bezoar.tooltip", "Immunity to Poison");
        this.add("item.confluence.trifold_map.tooltip", "Immunity to Nausea");
        this.add("item.confluence.the_plan.tooltip", "Immunity to Slow and Nausea");
        this.add("item.confluence.holy_water.tooltip", "Immunity to Wither");
        this.add("item.confluence.energy_bar.tooltip", "Immunity to Hunger");
        this.add("item.confluence.flashlight.tooltip", "Immunity to Darkness");
        this.add("item.confluence.hand_drill.tooltip", "Immunity to Mining Fatigue");
        this.add("item.confluence.shot_put.tooltip", "Immunity to Levitation");
        this.add("item.confluence.searchlight.tooltip", "Immunity to Blindness and Darkness");
        this.add("item.confluence.detoxification_capsule.tooltip", "Immunity to Poison and Wither");
        this.add("item.confluence.explorers_equipment.tooltip", "Immunity to Mining Fatigue and Levitation");
        this.add("item.confluence.nutrient_solution.tooltip", "Immunity to Weakness and Hunger");
        this.add("item.confluence.ankh_charm.tooltip", "Grants immunity to most debuffs");
        this.add("item.confluence.cobalt_shield.tooltip", "Grants immunity to knockback");
        this.add("item.confluence.band_of_regeneration.tooltip", "Slowly regenerates life");
        this.add("item.confluence.mechanical_lens.tooltip", "Grants improved wire vision");
        this.add("item.confluence.spectre_goggles.tooltip", "Enables Echo Sight, showing hidden blocks");
        this.add("item.confluence.magiluminescence.tooltip", "Increases movement speed and acceleration");
        this.add("item.confluence.magiluminescence.tooltip3", "'A brief light in my dark life.'");
        this.add("item.confluence.sandstorm_on_a_bottle.tooltip", "Allows the holder to do an improved double jump");
        this.add("item.confluence.ice_skates.tooltip", "Provides extra mobility on ice");
        this.add("item.confluence.dunerider_boots.tooltip", "The wearer can run super fast, and even faster on sand");
        this.add("item.confluence.dunerider_boots.tooltip2", "'Walk without rhythm and you won't attract the worm'");
        this.add("item.confluence.lucky_horseshoe.tooltip", "'Said to bring good fortune and keep evil spirits at bay'");
        this.add("item.confluence.lightning_boots.tooltip", "Allows flight, super fast running");
        this.add("item.confluence.horseshoe_balloon.tooltip", "Increases jump height and negates fall damage");
        this.add("item.confluence.lava_waders.tooltip2", "Grants immunity to fire blocks and 7 seconds of immunity to lava");
        this.add("item.confluence.bundle_of_balloons.tooltip", "Allows the holder to quadruple jump");
        this.add("item.confluence.bundle_of_horseshoe_balloon.tooltip", "Allows the holder to quadruple jump");
        this.add("item.confluence.bundle_of_horseshoe_balloon.tooltip2", "Increases jump height and negates fall damage");
        this.add("item.confluence.water_walking_boots.tooltip", "Provides the ability to walk on water & honey");
        this.add("item.confluence.magma_skull.tooltip", "Immunity to fire blocks, melee attacks deal fire damage");
        this.add("item.confluence.frostspark_boots.tooltip", "Allows flight, super fast running, and extra mobility on ice");
        this.add("item.confluence.sun_stone.tooltip", "During daytime, grants minor increase");
        this.add("item.confluence.moon_stone.tooltip", "During nighttime, grants minor increase");
        this.add("item.confluence.putrid_scent.tooltip", "Enemies are less likely to target you");
        this.add("item.confluence.panic_necklace.tooltip", "Increases movement speed after taking damage");
        this.add("item.confluence.paladins_shield.tooltip", "Absorbs 25% of damage done to players on your team when above 25% life");
        this.add("item.confluence.frozen_shield.tooltip", "Absorbs 25% of damage done to players on your team when above 25% life");
        this.add("item.confluence.frozen_shield.tooltip2", "Puts a shell around the owner when below 50% life that reduces damage by 25%");
        this.add("item.confluence.frozen_turtle_shell.tooltip", "Puts a shell around the owner when below 50% life that reduces damage by 25%");
        this.add("item.confluence.fire_gauntlet.tooltip", "Increases melee knockback and melee attacks inflict fire damage");
        this.add("item.confluence.cross_necklace.tooltip", "Increases length of invincibility after taking damage");
        this.add("item.confluence.terraspark_boots.tooltip2", "Grants immunity to fire blocks and 7 seconds of immunity to lava");
        this.add("item.confluence.fledgling_wings.tooltip", "Allows flight and slow fall");
        this.add("item.confluence.worm_scarf.tooltip", "Reduces damage taken by 17%");
        this.add("item.confluence.shield_of_cthulhu.tooltip", "Allows the player to dash into the enemy, sprinting to dsh");
        this.add("item.confluence.brain_of_confusion.tooltip", "Has a chance to create illusions and dodge an attack");
        this.add("item.confluence.brain_of_confusion.tooltip2", "Temporarily increase critical chance after dodge");
        this.add("item.confluence.brain_of_confusion.tooltip3", "May confuse nearby enemies after being struck");
        this.add("item.confluence.royal_gel.tooltip", "Slimes become friendly");
        this.add("item.confluence.arcane_flower.tooltip3", "The enemy is unlikely to target you");
        this.add("item.confluence.celestial_stone.tooltip", "Slightly increases the attribute value");
        this.add("item.confluence.charm_of_myths.tooltip", "Provides health regeneration and reduces the cooldown of healing potions");
        this.add("item.confluence.philosophers_stone.tooltip", "Reduced the cooldown of Healing Potions");
        this.add("item.confluence.gold_ring.tooltip", "Expanded coin pickup");
        this.add("item.confluence.gravity_globe.tooltip", "Allows the holder to reverse gravity");
        this.add("item.confluence.gravity_globe.tooltip2", "Press Jump to change gravity");
        this.add("item.confluence.ancient_chisel.tooltip2", "\u201cAge-old problems require age-old solutions\u201d");
        this.add("item.confluence.treasure_magnet.tooltip", "Expanded item pickup");
        this.add("item.confluence.flower_boots.tooltip", "Flowers grow on the grass you walk on");
        this.add("item.confluence.hand_warmer.tooltip", "Provides immunity to chill and freezing effects");
        this.add("item.confluence.star_cloak.tooltip", "Causes stars to fall after taking damage");
        this.add("item.confluence.honey_comb.tooltip", "Releases bees and douses the user in honey when damaged");
        this.add("item.confluence.sweetheart_necklace.tooltip", "When damaged, the bee is released and the user is immersed in honey and increases movement speed");
        this.add("item.confluence.hive_pack.tooltip", "Increases the strength of friendly bees");
        this.add("item.confluence.magic_quiver.tooltip2", "20% chance to not consume arrows");
        this.add("item.confluence.molten_quiver.tooltip", "Lights wooden arrows ablaze");
        this.add("item.confluence.molten_quiver.tooltip2", "'Quiver in fear!'");
        this.add("item.confluence.recon_scope.tooltip", "'Enemy spotted'");
        this.add("item.confluence.portable_cement_mixer.tooltip", "Decreased 'Right Click Delay' by 1");
        this.add("item.confluence.brick_layer.tooltip", "Decreased 'Right Click Delay' by 1");
        this.add("item.confluence.architect_gizmo_pack.tooltip", "Decreased 'Right Click Delay' by 2, cannot stack the decrease of its materials");
        this.add("item.confluence.climbing_claws.tooltip", "Improved ability if combined with Shoe Spikes");
        this.add("item.confluence.shoe_spikes.tooltip", "Improved ability if combined with Climbing Claws");
        this.add("item.confluence.frog_gear.tooltip", "'It ain't easy being green'");
        this.add("item.confluence.hand_of_creation.tooltip2", "Decreased 'Right Click Delay' by 3, cannot stack the decrease of its material");
        this.add("item.confluence.step_stool.tooltip", "Press \u2191 key to stand higher, and press Shift key to down");
        this.add("item.confluence.step_stool.tooltip2", "Extra Step: %s");
        this.add("item.confluence.magic_mirror.tooltip", "Gaze in the mirror to return home");
        this.add("item.confluence.cell_phone.tooltip", "Displays everything");
        this.add("item.confluence.cell_phone.tooltip2", "Allows you to return home at will");
        this.add("item.confluence.aglet.info", "It can be found in Shipwreck Chests.");
        this.add("item.confluence.climbing_claws.info", "It have a Chance to be dropped from Spider.");
        this.add("item.confluence.cloud_in_a_bottle.info", "It can be found in Chests in the Mineshaft and Dungeon.");
        this.add("item.confluence.dunerider_boots.info", "It have a Chance to be dropped from Husk.");
        this.add("item.confluence.fart_in_a_jar.info", "It have a Chance to be dropped from Ghost.");
        this.add("item.confluence.flipper.info", "It can be found in Chests in the Shipwreck.");
        this.add("item.confluence.flurry_boots.info", "It can be found in Igloo's chest.");
        this.add("item.confluence.frog_leg.info", "The Frog Leg have a Chance to be dropped from Frog.");
        this.add("item.confluence.hermes_boots.info", "It can be found in Chests in the Village Armorer.");
        this.add("item.confluence.lava_charm.info", "It have a Chance to be dropped from Blaze.");
        this.add("item.confluence.lucky_horseshoe.info", "It can be discovered in chests found within Desert Pyramids, End City, Jungle Pyramids, or Ancient Cities.");
        this.add("item.confluence.magiluminescence.info", "It can be found in End City Chests.");
        this.add("item.confluence.sailfish_boots.info", "It can be found in Shipwreck Chests.");
        this.add("item.confluence.sandstorm_in_a_bottle.info", "It can be found in Chests in the Desert Pyramid.");
        this.add("item.confluence.shiny_red_balloon.info", "When the player has the Hero of the Village effect, the librarian has a chance to give the player this item.It can be found in chests in plains villages.");
        this.add("item.confluence.shoe_spikes.info", "It have a Chance to be dropped from Cave Spider.");
        this.add("item.confluence.step_stool.info", "You can use Step Stool to upgrade its Extra Step from Smithing Table");
        this.add("item.confluence.tabi.info", "It can be found in Chests in the Fortress.");
        this.add("item.confluence.tsunami_in_a_bottle.info", "It can be found in Shipwreck Chests");
        this.add("item.confluence.water_walking_boots.info", "It can be found in Ocean Ruins Chests.");
        this.add("item.confluence.depth_meter.info", "The Depth Meter have a Chance to be dropped from Bats.");
        this.add("item.confluence.compass.info", "The Compass have a Chance to be dropped from Bats.");
        this.add("item.confluence.dps_meter.info", "The DPS Meter have a Chance to be dropped from Creeper.");
        this.add("item.confluence.fishermans_pocket_guide.info", "This item can be located in the chests found within Fisherman Villagers' houses.");
        this.add("item.confluence.life_form_analyzer.info", "The Lifeform Analyzer have a Chance to be dropped from Glow Squid.");
        this.add("item.confluence.metal_detector.info", "The Metal Detector have a Chance to be dropped from Warden.");
        this.add("item.confluence.radar.info", "The Radar have a Chance to be dropped from Bats.");
        this.add("item.confluence.sextant.info", "This item can be located in the chests found within Fisherman Villagers' houses.");
        this.add("item.confluence.tally_counter.info", "The Tally Counter a Chance to be dropped from Creeper.");
        this.add("item.confluence.weather_radio.info", "This item can be located in the chests found within Fisherman Villagers' houses.");
        this.add("item.confluence.band_of_regeneration.info", "The Band of Regeneration is an accessory that have a Chance to be dropped from Witch");
        this.add("item.confluence.angler_earring.info", "This item can be located in the chests found within Fisherman Villagers' houses.");
        this.add("item.confluence.brain_of_confusion.info", "It have a Chance to be dropped from Zombie Villager.");
        this.add("item.confluence.gravity_globe.info", "It have a Chance to be dropped from Shulker.");
        this.add("item.confluence.hive_pack.info", "It have a Chance to be dropped from Bee.");
        this.add("item.confluence.royal_gel.info", "It have a Chance to be dropped from Slime.");
        this.add("item.confluence.shield_of_cthulhu.info", "It have a Chance to be dropped from Ravager.");
        this.add("item.confluence.worm_scarf.info", "When a player has a tamed cat, the cat may give the player this item when they wake up.");
        this.add("item.confluence.ancient_chisel.info", "The item can be pass the Archaeology to obtained.");
        this.add("item.confluence.brick_layer.info", "This item can be located in the chests found within Toolsmith Villagers' houses.");
        this.add("item.confluence.extendo_grip.info", "It can be discovered in chests found within Desert Pyramids.");
        this.add("item.confluence.portable_cement_mixer.info", "This item can be located in the chests found within Toolsmith Villagers' houses.");
        this.add("item.confluence.toolbelt.info", "This item can be located in the chests found within Toolsmith Villagers' houses.");
        this.add("item.confluence.toolbox.info", "The item can be located in the chests found within Toolsmith Villagers' houses.");
        this.add("item.confluence.flower_boots.info", "It has a chance of falling from digging through Moss Block.");
        this.add("item.confluence.treasure_magnet.info", "It can be discovered in chests found within Desert Pyramids, End City, Jungle Pyramids, or Ancient Cities.");
        this.add("item.confluence.bezoar.info", "It have a Chance to be dropped from Cave Spider.");
        this.add("item.confluence.black_belt.info", "It have a Chance to be dropped from Wither Skeleton.");
        this.add("item.confluence.blindfold.info", "It can be discovered in chests found within Ancient City.");
        this.add("item.confluence.cobalt_shield.info", "It have a Chance to be dropped from Ravager.");
        this.add("item.confluence.cross_necklace.info", "It have a Chance to be dropped from Evoker.");
        this.add("item.confluence.energy_bar.info", "It have a Chance to be dropped from Zombified Piglin.");
        this.add("item.confluence.eye_of_the_golem.info", "It can be discovered in chests found within Jungle Pyramids.");
        this.add("item.confluence.fast_clock.info", "It have a Chance to be dropped from Stray.");
        this.add("item.confluence.feral_claws.info", "It can be discovered in chests found within Jungle Pyramids.");
        this.add("item.confluence.flashlight.info", "It can be discovered in chests found within Stronghold.");
        this.add("item.confluence.flesh_knuckles.info", "It have a Chance to be dropped from Piglin Brute.");
        this.add("item.confluence.frozen_turtle_shell.info", "When the Turtle died for Freezing chance to dropped this item.");
        this.add("item.confluence.hand_drill.info", "It have a Chance to be dropped from Elder Guardian.");
        this.add("item.confluence.holy_water.info", "It have a Chance to be dropped from Wither Skeleton.");
        this.add("item.confluence.honey_comb.info", "It have a Chance to be dropped from Bee.");
        this.add("item.confluence.magic_quiver.info", "This item have a Chance to be dropped from Skeleton.");
        this.add("item.confluence.magma_stone.info", "It have a Chance to be dropped from Blaze.");
        this.add("item.confluence.moon_stone.info", "It have a Chance to be dropped from Phantom.");
        this.add("item.confluence.obsidian_rose.info", "It can be discovered in chests found within Bastion Remnant.");
        this.add("item.confluence.paladins_shield.info", "It to be dropped from Ender Dragon.");
        this.add("item.confluence.panic_necklace.info", "It can be found in Chests in the Dungeon.");
        this.add("item.confluence.putrid_scent.info", "It can be found in Chests in the Dungeon.");
        this.add("item.confluence.ranger_emblem.info", "It have a Chance to be dropped from Skeleton.");
        this.add("item.confluence.rifle_scope.info", "It have a Chance to be dropped from Enderman.");
        this.add("item.confluence.shackle.info", "It can be found in Chests in the Dungeon.");
        this.add("item.confluence.shark_tooth_necklace.info", "It has a chance to drop from Drowned.");
        this.add("item.confluence.shot_put.info", "It can be found in Chests in the Stronghold.");
        this.add("item.confluence.sorcerer_emblem.info", "It have a Chance to be dropped from Evoker.");
        this.add("item.confluence.star_cloak.info", "It can be discovered in chests found within Woodland Mansion.");
        this.add("item.confluence.sun_stone.info", "It have a Chance to be dropped from Blaze.");
        this.add("item.confluence.titan_glove.info", "It can be found in Chests in the Mineshaft.");
        this.add("item.confluence.trifold_map.info", "It can be found in Chests in the Stronghold Library.");
        this.add("item.confluence.vitamins.info", "It have a Chance to be dropped from Witch.");
        this.add("item.confluence.warrior_emblem.info", "It have a Chance to be dropped from Vindicator.");
        this.add("item.confluence.demon_heart.info", "It to be dropped from Wither.");
        this.add("death.attack.star_cloak", "%1$s was squashed by a falling star");
        this.add("attribute.name.generic.critical_chance", "Critical Chance");
        this.add("attribute.name.generic.ranged_velocity", "Ranged Velocity");
        this.add("attribute.name.generic.ranged_damage", "Ranged Damage");
        this.add("attribute.name.generic.dodge_chance", "Dodge Chance");
        this.add("attribute.name.generic.mining_speed", "Mining Speed");
        this.add("attribute.name.generic.aggro", "Aggro");
        this.add("attribute.name.generic.magic_damage", "Magic Damage");
        this.add("attribute.name.generic.armor_pass", "Armor Pass");
        this.add("attribute.name.generic.pickup_range", "Pickup Range");
        this.add("container.confluence.workshop", "Workshop");
        this.add("title.confluence.workshop", "Workshop");
        this.add("achievements.confluence.boots_of_the_hero.title", "Boots of the Hero");
        this.add("achievements.confluence.boots_of_the_hero.description", "Forged from the finest boots of fire and ice.");
        this.add("achievements.confluence.black_mirror.title", "Black Mirror");
        this.add("achievements.confluence.black_mirror.description", "You'll never leave home without it again.");
        this.add("achievements.confluence.ankhumulation_complete.title", "Ankhumulation Complete");
        this.add("achievements.confluence.ankhumulation_complete.description", "The finest protection from unpleasant maladies and ailments.");
        ModItems.ITEMS.getEntries().forEach(item -> {
            Item item1 = (Item)item.get();
            if (item1 instanceof CustomName) {
                CustomName customName = (CustomName)item1;
                this.add(item1, customName.getGenName());
            } else {
                this.add(item1, ModEnglishProvider.toTitleCase(item.getId().m_135815_()));
            }
        });
        ModEntities.ENTITIES.getEntries().forEach(entity -> this.add((EntityType)entity.get(), ModEnglishProvider.toTitleCase(entity.getId().m_135815_())));
        ModEffects.EFFECTS.getEntries().forEach(effect -> this.add((MobEffect)effect.get(), ModEnglishProvider.toTitleCase(effect.getId().m_135815_())));
    }

    private static String toTitleCase(String raw) {
        return Arrays.stream(raw.split("_")).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }
}

