/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.confluence.mod.client.color.AnimateColor;
import org.confluence.mod.client.handler.ClientPacketHandler;
import org.confluence.mod.client.handler.GravitationHandler;
import org.confluence.mod.client.handler.InformationHandler;
import org.confluence.mod.client.handler.PlayerClimbHandler;
import org.confluence.mod.client.handler.PlayerJumpHandler;
import org.confluence.mod.client.handler.PlayerSprintingHandler;
import org.confluence.mod.client.handler.StepStoolHandler;
import org.confluence.mod.effect.ModEffects;
import org.confluence.mod.item.curio.combat.IAutoAttack;
import org.confluence.mod.misc.ModTags;
import org.confluence.mod.mixin.client.MinecraftAccessor;

@Mod.EventBusSubscriber(modid="confluence", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class ForgeClient {
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        GravitationHandler.tick(localPlayer);
        StepStoolHandler.handle(localPlayer);
        if (localPlayer == null) {
            return;
        }
        IAutoAttack.apply(minecraft, localPlayer);
        InformationHandler.handle(localPlayer);
        AnimateColor.doUpdateExpertColor();
        AnimateColor.doUpdateMasterColor();
    }

    @SubscribeEvent
    public static void movementInputUpdate(MovementInputUpdateEvent event) {
        LocalPlayer localPlayer = (LocalPlayer)event.getEntity();
        Input input = event.getInput();
        boolean jumping = input.f_108572_;
        if (GravitationHandler.isHasGlobe() || localPlayer.m_21023_((MobEffect)ModEffects.GRAVITATION.get())) {
            GravitationHandler.handle(localPlayer, jumping);
        } else {
            GravitationHandler.expire();
            PlayerJumpHandler.handle(localPlayer, jumping);
            PlayerClimbHandler.handle(localPlayer, input.m_108575_(), jumping);
        }
        if (ClientPacketHandler.isHasTabi()) {
            PlayerSprintingHandler.handle(localPlayer, input);
        }
    }

    @SubscribeEvent
    public static void cameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (GravitationHandler.isShouldRot()) {
            event.setRoll(180.0f);
        }
    }

    @SubscribeEvent
    public static void fov(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        if (ClientPacketHandler.isHasScope() && player.m_6047_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && player.m_21120_(InteractionHand.MAIN_HAND).m_204117_(ModTags.RANGED_WEAPON)) {
            event.setNewFovModifier(0.1f);
        }
    }

    @SubscribeEvent
    public static void interactionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isUseItem()) {
            MinecraftAccessor instance = (MinecraftAccessor)Minecraft.m_91087_();
            int delay = instance.getRightClickDelay() - ClientPacketHandler.getRightClickSubtractor();
            instance.setRightClickDelay(Math.max(0, delay));
        }
    }
}

